/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.AbstractConnectorSpec;
import io.strimzi.api.kafka.model.AutoRestart;
import io.strimzi.api.kafka.model.AutoRestartBuilder;
import io.strimzi.api.kafka.model.AutoRestartFluent;
import io.strimzi.api.kafka.model.ConnectorState;
import io.strimzi.api.kafka.model.SpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AbstractConnectorSpecFluent<A extends AbstractConnectorSpecFluent<A>>
extends SpecFluent<A> {
    private Integer tasksMax;
    private Boolean pause;
    private Map<String, Object> config;
    private ConnectorState state;
    private AutoRestartBuilder autoRestart;

    public AbstractConnectorSpecFluent() {
    }

    public AbstractConnectorSpecFluent(AbstractConnectorSpec instance) {
        if (instance != null) {
            this.withTasksMax(instance.getTasksMax());
            this.withPause(instance.getPause());
            this.withConfig(instance.getConfig());
            this.withState(instance.getState());
            this.withAutoRestart(instance.getAutoRestart());
        }
    }

    public Integer getTasksMax() {
        return this.tasksMax;
    }

    public A withTasksMax(Integer tasksMax) {
        this.tasksMax = tasksMax;
        return (A)((Object)this);
    }

    public boolean hasTasksMax() {
        return this.tasksMax != null;
    }

    public Boolean getPause() {
        return this.pause;
    }

    public A withPause(Boolean pause) {
        this.pause = pause;
        return (A)((Object)this);
    }

    public boolean hasPause() {
        return this.pause != null;
    }

    public A addToConfig(String key, Object value) {
        if (this.config == null && key != null && value != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.config.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConfig(Map<String, Object> map) {
        if (this.config == null && map != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.config.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromConfig(String key) {
        if (this.config == null) {
            return (A)((Object)this);
        }
        if (key != null && this.config != null) {
            this.config.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromConfig(Map<String, Object> map) {
        if (this.config == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.config == null) continue;
                this.config.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public <K, V> A withConfig(Map<String, Object> config) {
        this.config = config == null ? null : new LinkedHashMap<String, Object>(config);
        return (A)((Object)this);
    }

    public boolean hasConfig() {
        return this.config != null;
    }

    public ConnectorState getState() {
        return this.state;
    }

    public A withState(ConnectorState state) {
        this.state = state;
        return (A)((Object)this);
    }

    public boolean hasState() {
        return this.state != null;
    }

    public AutoRestart buildAutoRestart() {
        return this.autoRestart != null ? this.autoRestart.build() : null;
    }

    public A withAutoRestart(AutoRestart autoRestart) {
        this._visitables.get((Object)"autoRestart").remove((Object)this.autoRestart);
        if (autoRestart != null) {
            this.autoRestart = new AutoRestartBuilder(autoRestart);
            this._visitables.get((Object)"autoRestart").add(this.autoRestart);
        } else {
            this.autoRestart = null;
            this._visitables.get((Object)"autoRestart").remove((Object)this.autoRestart);
        }
        return (A)((Object)this);
    }

    public boolean hasAutoRestart() {
        return this.autoRestart != null;
    }

    public AutoRestartNested<A> withNewAutoRestart() {
        return new AutoRestartNested(null);
    }

    public AutoRestartNested<A> withNewAutoRestartLike(AutoRestart item) {
        return new AutoRestartNested(item);
    }

    public AutoRestartNested<A> editAutoRestart() {
        return this.withNewAutoRestartLike(Optional.ofNullable(this.buildAutoRestart()).orElse(null));
    }

    public AutoRestartNested<A> editOrNewAutoRestart() {
        return this.withNewAutoRestartLike(Optional.ofNullable(this.buildAutoRestart()).orElse(new AutoRestartBuilder().build()));
    }

    public AutoRestartNested<A> editOrNewAutoRestartLike(AutoRestart item) {
        return this.withNewAutoRestartLike(Optional.ofNullable(this.buildAutoRestart()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractConnectorSpecFluent that = (AbstractConnectorSpecFluent)((Object)o);
        if (!Objects.equals(this.tasksMax, that.tasksMax)) {
            return false;
        }
        if (!Objects.equals(this.pause, that.pause)) {
            return false;
        }
        if (!Objects.equals(this.config, that.config)) {
            return false;
        }
        if (!Objects.equals((Object)this.state, (Object)that.state)) {
            return false;
        }
        return Objects.equals((Object)this.autoRestart, (Object)that.autoRestart);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.tasksMax, this.pause, this.config, this.state, this.autoRestart, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.tasksMax != null) {
            sb.append("tasksMax:");
            sb.append(this.tasksMax + ",");
        }
        if (this.pause != null) {
            sb.append("pause:");
            sb.append(this.pause + ",");
        }
        if (this.config != null && !this.config.isEmpty()) {
            sb.append("config:");
            sb.append(this.config + ",");
        }
        if (this.state != null) {
            sb.append("state:");
            sb.append(this.state + ",");
        }
        if (this.autoRestart != null) {
            sb.append("autoRestart:");
            sb.append((Object)this.autoRestart);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withPause() {
        return this.withPause(true);
    }

    public class AutoRestartNested<N>
    extends AutoRestartFluent<AutoRestartNested<N>>
    implements Nested<N> {
        AutoRestartBuilder builder;

        AutoRestartNested(AutoRestart item) {
            this.builder = new AutoRestartBuilder(this, item);
        }

        public N and() {
            return (N)AbstractConnectorSpecFluent.this.withAutoRestart(this.builder.build());
        }

        public N endAutoRestart() {
            return this.and();
        }
    }
}

