/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.JmxTransSpec;
import io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate;
import io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder;
import io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateFluent;
import io.strimzi.api.kafka.model.template.JmxTransQueryTemplate;
import io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder;
import io.strimzi.api.kafka.model.template.JmxTransQueryTemplateFluent;
import io.strimzi.api.kafka.model.template.JmxTransTemplate;
import io.strimzi.api.kafka.model.template.JmxTransTemplateBuilder;
import io.strimzi.api.kafka.model.template.JmxTransTemplateFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class JmxTransSpecFluent<A extends JmxTransSpecFluent<A>>
extends BaseFluent<A> {
    private String image;
    private String logLevel;
    private ArrayList<JmxTransOutputDefinitionTemplateBuilder> outputDefinitions;
    private ArrayList<JmxTransQueryTemplateBuilder> kafkaQueries;
    private ResourceRequirements resources;
    private JmxTransTemplateBuilder template;

    public JmxTransSpecFluent() {
    }

    public JmxTransSpecFluent(JmxTransSpec instance) {
        JmxTransSpec jmxTransSpec = instance = instance != null ? instance : new JmxTransSpec();
        if (instance != null) {
            this.withImage(instance.getImage());
            this.withLogLevel(instance.getLogLevel());
            this.withOutputDefinitions(instance.getOutputDefinitions());
            this.withKafkaQueries(instance.getKafkaQueries());
            this.withResources(instance.getResources());
            this.withTemplate(instance.getTemplate());
        }
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public A withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return (A)((Object)this);
    }

    public boolean hasLogLevel() {
        return this.logLevel != null;
    }

    public A addToOutputDefinitions(int index, JmxTransOutputDefinitionTemplate item) {
        if (this.outputDefinitions == null) {
            this.outputDefinitions = new ArrayList();
        }
        JmxTransOutputDefinitionTemplateBuilder builder = new JmxTransOutputDefinitionTemplateBuilder(item);
        if (index < 0 || index >= this.outputDefinitions.size()) {
            this._visitables.get((Object)"outputDefinitions").add(builder);
            this.outputDefinitions.add(builder);
        } else {
            this._visitables.get((Object)"outputDefinitions").add(index, builder);
            this.outputDefinitions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToOutputDefinitions(int index, JmxTransOutputDefinitionTemplate item) {
        if (this.outputDefinitions == null) {
            this.outputDefinitions = new ArrayList();
        }
        JmxTransOutputDefinitionTemplateBuilder builder = new JmxTransOutputDefinitionTemplateBuilder(item);
        if (index < 0 || index >= this.outputDefinitions.size()) {
            this._visitables.get((Object)"outputDefinitions").add(builder);
            this.outputDefinitions.add(builder);
        } else {
            this._visitables.get((Object)"outputDefinitions").set(index, builder);
            this.outputDefinitions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToOutputDefinitions(JmxTransOutputDefinitionTemplate ... items) {
        if (this.outputDefinitions == null) {
            this.outputDefinitions = new ArrayList();
        }
        for (JmxTransOutputDefinitionTemplate item : items) {
            JmxTransOutputDefinitionTemplateBuilder builder = new JmxTransOutputDefinitionTemplateBuilder(item);
            this._visitables.get((Object)"outputDefinitions").add(builder);
            this.outputDefinitions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToOutputDefinitions(Collection<JmxTransOutputDefinitionTemplate> items) {
        if (this.outputDefinitions == null) {
            this.outputDefinitions = new ArrayList();
        }
        for (JmxTransOutputDefinitionTemplate item : items) {
            JmxTransOutputDefinitionTemplateBuilder builder = new JmxTransOutputDefinitionTemplateBuilder(item);
            this._visitables.get((Object)"outputDefinitions").add(builder);
            this.outputDefinitions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromOutputDefinitions(JmxTransOutputDefinitionTemplate ... items) {
        if (this.outputDefinitions == null) {
            return (A)((Object)this);
        }
        for (JmxTransOutputDefinitionTemplate item : items) {
            JmxTransOutputDefinitionTemplateBuilder builder = new JmxTransOutputDefinitionTemplateBuilder(item);
            this._visitables.get((Object)"outputDefinitions").remove((Object)builder);
            this.outputDefinitions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOutputDefinitions(Collection<JmxTransOutputDefinitionTemplate> items) {
        if (this.outputDefinitions == null) {
            return (A)((Object)this);
        }
        for (JmxTransOutputDefinitionTemplate item : items) {
            JmxTransOutputDefinitionTemplateBuilder builder = new JmxTransOutputDefinitionTemplateBuilder(item);
            this._visitables.get((Object)"outputDefinitions").remove((Object)builder);
            this.outputDefinitions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromOutputDefinitions(Predicate<JmxTransOutputDefinitionTemplateBuilder> predicate) {
        if (this.outputDefinitions == null) {
            return (A)((Object)this);
        }
        Iterator<JmxTransOutputDefinitionTemplateBuilder> each = this.outputDefinitions.iterator();
        List visitables = this._visitables.get((Object)"outputDefinitions");
        while (each.hasNext()) {
            JmxTransOutputDefinitionTemplateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<JmxTransOutputDefinitionTemplate> buildOutputDefinitions() {
        return this.outputDefinitions != null ? JmxTransSpecFluent.build(this.outputDefinitions) : null;
    }

    public JmxTransOutputDefinitionTemplate buildOutputDefinition(int index) {
        return this.outputDefinitions.get(index).build();
    }

    public JmxTransOutputDefinitionTemplate buildFirstOutputDefinition() {
        return this.outputDefinitions.get(0).build();
    }

    public JmxTransOutputDefinitionTemplate buildLastOutputDefinition() {
        return this.outputDefinitions.get(this.outputDefinitions.size() - 1).build();
    }

    public JmxTransOutputDefinitionTemplate buildMatchingOutputDefinition(Predicate<JmxTransOutputDefinitionTemplateBuilder> predicate) {
        for (JmxTransOutputDefinitionTemplateBuilder item : this.outputDefinitions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingOutputDefinition(Predicate<JmxTransOutputDefinitionTemplateBuilder> predicate) {
        for (JmxTransOutputDefinitionTemplateBuilder item : this.outputDefinitions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOutputDefinitions(List<JmxTransOutputDefinitionTemplate> outputDefinitions) {
        if (this.outputDefinitions != null) {
            this._visitables.get((Object)"outputDefinitions").clear();
        }
        if (outputDefinitions != null) {
            this.outputDefinitions = new ArrayList();
            for (JmxTransOutputDefinitionTemplate item : outputDefinitions) {
                this.addToOutputDefinitions(item);
            }
        } else {
            this.outputDefinitions = null;
        }
        return (A)((Object)this);
    }

    public A withOutputDefinitions(JmxTransOutputDefinitionTemplate ... outputDefinitions) {
        if (this.outputDefinitions != null) {
            this.outputDefinitions.clear();
            this._visitables.remove((Object)"outputDefinitions");
        }
        if (outputDefinitions != null) {
            for (JmxTransOutputDefinitionTemplate item : outputDefinitions) {
                this.addToOutputDefinitions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasOutputDefinitions() {
        return this.outputDefinitions != null && !this.outputDefinitions.isEmpty();
    }

    public OutputDefinitionsNested<A> addNewOutputDefinition() {
        return new OutputDefinitionsNested(-1, null);
    }

    public OutputDefinitionsNested<A> addNewOutputDefinitionLike(JmxTransOutputDefinitionTemplate item) {
        return new OutputDefinitionsNested(-1, item);
    }

    public OutputDefinitionsNested<A> setNewOutputDefinitionLike(int index, JmxTransOutputDefinitionTemplate item) {
        return new OutputDefinitionsNested(index, item);
    }

    public OutputDefinitionsNested<A> editOutputDefinition(int index) {
        if (this.outputDefinitions.size() <= index) {
            throw new RuntimeException("Can't edit outputDefinitions. Index exceeds size.");
        }
        return this.setNewOutputDefinitionLike(index, this.buildOutputDefinition(index));
    }

    public OutputDefinitionsNested<A> editFirstOutputDefinition() {
        if (this.outputDefinitions.size() == 0) {
            throw new RuntimeException("Can't edit first outputDefinitions. The list is empty.");
        }
        return this.setNewOutputDefinitionLike(0, this.buildOutputDefinition(0));
    }

    public OutputDefinitionsNested<A> editLastOutputDefinition() {
        int index = this.outputDefinitions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last outputDefinitions. The list is empty.");
        }
        return this.setNewOutputDefinitionLike(index, this.buildOutputDefinition(index));
    }

    public OutputDefinitionsNested<A> editMatchingOutputDefinition(Predicate<JmxTransOutputDefinitionTemplateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.outputDefinitions.size(); ++i) {
            if (!predicate.test(this.outputDefinitions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching outputDefinitions. No match found.");
        }
        return this.setNewOutputDefinitionLike(index, this.buildOutputDefinition(index));
    }

    public A addToKafkaQueries(int index, JmxTransQueryTemplate item) {
        if (this.kafkaQueries == null) {
            this.kafkaQueries = new ArrayList();
        }
        JmxTransQueryTemplateBuilder builder = new JmxTransQueryTemplateBuilder(item);
        if (index < 0 || index >= this.kafkaQueries.size()) {
            this._visitables.get((Object)"kafkaQueries").add(builder);
            this.kafkaQueries.add(builder);
        } else {
            this._visitables.get((Object)"kafkaQueries").add(index, builder);
            this.kafkaQueries.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToKafkaQueries(int index, JmxTransQueryTemplate item) {
        if (this.kafkaQueries == null) {
            this.kafkaQueries = new ArrayList();
        }
        JmxTransQueryTemplateBuilder builder = new JmxTransQueryTemplateBuilder(item);
        if (index < 0 || index >= this.kafkaQueries.size()) {
            this._visitables.get((Object)"kafkaQueries").add(builder);
            this.kafkaQueries.add(builder);
        } else {
            this._visitables.get((Object)"kafkaQueries").set(index, builder);
            this.kafkaQueries.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToKafkaQueries(JmxTransQueryTemplate ... items) {
        if (this.kafkaQueries == null) {
            this.kafkaQueries = new ArrayList();
        }
        for (JmxTransQueryTemplate item : items) {
            JmxTransQueryTemplateBuilder builder = new JmxTransQueryTemplateBuilder(item);
            this._visitables.get((Object)"kafkaQueries").add(builder);
            this.kafkaQueries.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToKafkaQueries(Collection<JmxTransQueryTemplate> items) {
        if (this.kafkaQueries == null) {
            this.kafkaQueries = new ArrayList();
        }
        for (JmxTransQueryTemplate item : items) {
            JmxTransQueryTemplateBuilder builder = new JmxTransQueryTemplateBuilder(item);
            this._visitables.get((Object)"kafkaQueries").add(builder);
            this.kafkaQueries.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromKafkaQueries(JmxTransQueryTemplate ... items) {
        if (this.kafkaQueries == null) {
            return (A)((Object)this);
        }
        for (JmxTransQueryTemplate item : items) {
            JmxTransQueryTemplateBuilder builder = new JmxTransQueryTemplateBuilder(item);
            this._visitables.get((Object)"kafkaQueries").remove((Object)builder);
            this.kafkaQueries.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromKafkaQueries(Collection<JmxTransQueryTemplate> items) {
        if (this.kafkaQueries == null) {
            return (A)((Object)this);
        }
        for (JmxTransQueryTemplate item : items) {
            JmxTransQueryTemplateBuilder builder = new JmxTransQueryTemplateBuilder(item);
            this._visitables.get((Object)"kafkaQueries").remove((Object)builder);
            this.kafkaQueries.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromKafkaQueries(Predicate<JmxTransQueryTemplateBuilder> predicate) {
        if (this.kafkaQueries == null) {
            return (A)((Object)this);
        }
        Iterator<JmxTransQueryTemplateBuilder> each = this.kafkaQueries.iterator();
        List visitables = this._visitables.get((Object)"kafkaQueries");
        while (each.hasNext()) {
            JmxTransQueryTemplateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<JmxTransQueryTemplate> buildKafkaQueries() {
        return this.kafkaQueries != null ? JmxTransSpecFluent.build(this.kafkaQueries) : null;
    }

    public JmxTransQueryTemplate buildKafkaQuery(int index) {
        return this.kafkaQueries.get(index).build();
    }

    public JmxTransQueryTemplate buildFirstKafkaQuery() {
        return this.kafkaQueries.get(0).build();
    }

    public JmxTransQueryTemplate buildLastKafkaQuery() {
        return this.kafkaQueries.get(this.kafkaQueries.size() - 1).build();
    }

    public JmxTransQueryTemplate buildMatchingKafkaQuery(Predicate<JmxTransQueryTemplateBuilder> predicate) {
        for (JmxTransQueryTemplateBuilder item : this.kafkaQueries) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingKafkaQuery(Predicate<JmxTransQueryTemplateBuilder> predicate) {
        for (JmxTransQueryTemplateBuilder item : this.kafkaQueries) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withKafkaQueries(List<JmxTransQueryTemplate> kafkaQueries) {
        if (this.kafkaQueries != null) {
            this._visitables.get((Object)"kafkaQueries").clear();
        }
        if (kafkaQueries != null) {
            this.kafkaQueries = new ArrayList();
            for (JmxTransQueryTemplate item : kafkaQueries) {
                this.addToKafkaQueries(item);
            }
        } else {
            this.kafkaQueries = null;
        }
        return (A)((Object)this);
    }

    public A withKafkaQueries(JmxTransQueryTemplate ... kafkaQueries) {
        if (this.kafkaQueries != null) {
            this.kafkaQueries.clear();
            this._visitables.remove((Object)"kafkaQueries");
        }
        if (kafkaQueries != null) {
            for (JmxTransQueryTemplate item : kafkaQueries) {
                this.addToKafkaQueries(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasKafkaQueries() {
        return this.kafkaQueries != null && !this.kafkaQueries.isEmpty();
    }

    public KafkaQueriesNested<A> addNewKafkaQuery() {
        return new KafkaQueriesNested(-1, null);
    }

    public KafkaQueriesNested<A> addNewKafkaQueryLike(JmxTransQueryTemplate item) {
        return new KafkaQueriesNested(-1, item);
    }

    public KafkaQueriesNested<A> setNewKafkaQueryLike(int index, JmxTransQueryTemplate item) {
        return new KafkaQueriesNested(index, item);
    }

    public KafkaQueriesNested<A> editKafkaQuery(int index) {
        if (this.kafkaQueries.size() <= index) {
            throw new RuntimeException("Can't edit kafkaQueries. Index exceeds size.");
        }
        return this.setNewKafkaQueryLike(index, this.buildKafkaQuery(index));
    }

    public KafkaQueriesNested<A> editFirstKafkaQuery() {
        if (this.kafkaQueries.size() == 0) {
            throw new RuntimeException("Can't edit first kafkaQueries. The list is empty.");
        }
        return this.setNewKafkaQueryLike(0, this.buildKafkaQuery(0));
    }

    public KafkaQueriesNested<A> editLastKafkaQuery() {
        int index = this.kafkaQueries.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last kafkaQueries. The list is empty.");
        }
        return this.setNewKafkaQueryLike(index, this.buildKafkaQuery(index));
    }

    public KafkaQueriesNested<A> editMatchingKafkaQuery(Predicate<JmxTransQueryTemplateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.kafkaQueries.size(); ++i) {
            if (!predicate.test(this.kafkaQueries.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching kafkaQueries. No match found.");
        }
        return this.setNewKafkaQueryLike(index, this.buildKafkaQuery(index));
    }

    public ResourceRequirements getResources() {
        return this.resources;
    }

    public A withResources(ResourceRequirements resources) {
        this.resources = resources;
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public JmxTransTemplate buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public A withTemplate(JmxTransTemplate template) {
        this._visitables.get((Object)"template").remove((Object)this.template);
        if (template != null) {
            this.template = new JmxTransTemplateBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove((Object)this.template);
        }
        return (A)((Object)this);
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(JmxTransTemplate item) {
        return new TemplateNested(item);
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new JmxTransTemplateBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(JmxTransTemplate item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JmxTransSpecFluent that = (JmxTransSpecFluent)((Object)o);
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.logLevel, that.logLevel)) {
            return false;
        }
        if (!Objects.equals(this.outputDefinitions, that.outputDefinitions)) {
            return false;
        }
        if (!Objects.equals(this.kafkaQueries, that.kafkaQueries)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        return Objects.equals((Object)this.template, (Object)that.template);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.image, this.logLevel, this.outputDefinitions, this.kafkaQueries, this.resources, this.template, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.logLevel != null) {
            sb.append("logLevel:");
            sb.append(this.logLevel + ",");
        }
        if (this.outputDefinitions != null && !this.outputDefinitions.isEmpty()) {
            sb.append("outputDefinitions:");
            sb.append(this.outputDefinitions + ",");
        }
        if (this.kafkaQueries != null && !this.kafkaQueries.isEmpty()) {
            sb.append("kafkaQueries:");
            sb.append(this.kafkaQueries + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append((Object)this.template);
        }
        sb.append("}");
        return sb.toString();
    }

    public class OutputDefinitionsNested<N>
    extends JmxTransOutputDefinitionTemplateFluent<OutputDefinitionsNested<N>>
    implements Nested<N> {
        JmxTransOutputDefinitionTemplateBuilder builder;
        int index;

        OutputDefinitionsNested(int index, JmxTransOutputDefinitionTemplate item) {
            this.index = index;
            this.builder = new JmxTransOutputDefinitionTemplateBuilder(this, item);
        }

        public N and() {
            return (N)JmxTransSpecFluent.this.setToOutputDefinitions(this.index, this.builder.build());
        }

        public N endOutputDefinition() {
            return this.and();
        }
    }

    public class KafkaQueriesNested<N>
    extends JmxTransQueryTemplateFluent<KafkaQueriesNested<N>>
    implements Nested<N> {
        JmxTransQueryTemplateBuilder builder;
        int index;

        KafkaQueriesNested(int index, JmxTransQueryTemplate item) {
            this.index = index;
            this.builder = new JmxTransQueryTemplateBuilder(this, item);
        }

        public N and() {
            return (N)JmxTransSpecFluent.this.setToKafkaQueries(this.index, this.builder.build());
        }

        public N endKafkaQuery() {
            return this.and();
        }
    }

    public class TemplateNested<N>
    extends JmxTransTemplateFluent<TemplateNested<N>>
    implements Nested<N> {
        JmxTransTemplateBuilder builder;

        TemplateNested(JmxTransTemplate item) {
            this.builder = new JmxTransTemplateBuilder(this, item);
        }

        public N and() {
            return (N)JmxTransSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }
}

