/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.CertAndKeySecretSource;
import io.strimzi.api.kafka.model.CertAndKeySecretSourceBuilder;
import io.strimzi.api.kafka.model.CertSecretSource;
import io.strimzi.api.kafka.model.CertSecretSourceBuilder;
import io.strimzi.api.kafka.model.CertSecretSourceFluent;
import io.strimzi.api.kafka.model.KafkaAuthorizationKeycloak;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaAuthorizationKeycloakFluent<A extends KafkaAuthorizationKeycloakFluent<A>>
extends BaseFluent<A> {
    private String clientId;
    private String tokenEndpointUri;
    private ArrayList<CertSecretSourceBuilder> tlsTrustedCertificates;
    private boolean disableTlsHostnameVerification;
    private boolean delegateToKafkaAcls;
    private Integer grantsRefreshPeriodSeconds;
    private Integer grantsRefreshPoolSize;
    private Integer grantsMaxIdleTimeSeconds;
    private Integer grantsGcPeriodSeconds;
    private boolean grantsAlwaysLatest;
    private Integer connectTimeoutSeconds;
    private Integer readTimeoutSeconds;
    private Integer httpRetries;
    private List<String> superUsers;
    private boolean enableMetrics;
    private boolean includeAcceptHeader;

    public KafkaAuthorizationKeycloakFluent() {
    }

    public KafkaAuthorizationKeycloakFluent(KafkaAuthorizationKeycloak instance) {
        KafkaAuthorizationKeycloak kafkaAuthorizationKeycloak = instance = instance != null ? instance : new KafkaAuthorizationKeycloak();
        if (instance != null) {
            this.withClientId(instance.getClientId());
            this.withTokenEndpointUri(instance.getTokenEndpointUri());
            this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
            this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
            this.withDelegateToKafkaAcls(instance.isDelegateToKafkaAcls());
            this.withGrantsRefreshPeriodSeconds(instance.getGrantsRefreshPeriodSeconds());
            this.withGrantsRefreshPoolSize(instance.getGrantsRefreshPoolSize());
            this.withGrantsMaxIdleTimeSeconds(instance.getGrantsMaxIdleTimeSeconds());
            this.withGrantsGcPeriodSeconds(instance.getGrantsGcPeriodSeconds());
            this.withGrantsAlwaysLatest(instance.isGrantsAlwaysLatest());
            this.withConnectTimeoutSeconds(instance.getConnectTimeoutSeconds());
            this.withReadTimeoutSeconds(instance.getReadTimeoutSeconds());
            this.withHttpRetries(instance.getHttpRetries());
            this.withSuperUsers(instance.getSuperUsers());
            this.withEnableMetrics(instance.isEnableMetrics());
            this.withIncludeAcceptHeader(instance.isIncludeAcceptHeader());
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public A withClientId(String clientId) {
        this.clientId = clientId;
        return (A)((Object)this);
    }

    public boolean hasClientId() {
        return this.clientId != null;
    }

    public String getTokenEndpointUri() {
        return this.tokenEndpointUri;
    }

    public A withTokenEndpointUri(String tokenEndpointUri) {
        this.tokenEndpointUri = tokenEndpointUri;
        return (A)((Object)this);
    }

    public boolean hasTokenEndpointUri() {
        return this.tokenEndpointUri != null;
    }

    public A addToTlsTrustedCertificates(int index, CertSecretSource item) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList();
        }
        CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
        if (index < 0 || index >= this.tlsTrustedCertificates.size()) {
            this._visitables.get((Object)"tlsTrustedCertificates").add(builder);
            this.tlsTrustedCertificates.add(builder);
        } else {
            this._visitables.get((Object)"tlsTrustedCertificates").add(index, builder);
            this.tlsTrustedCertificates.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTlsTrustedCertificates(int index, CertSecretSource item) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList();
        }
        CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
        if (index < 0 || index >= this.tlsTrustedCertificates.size()) {
            this._visitables.get((Object)"tlsTrustedCertificates").add(builder);
            this.tlsTrustedCertificates.add(builder);
        } else {
            this._visitables.get((Object)"tlsTrustedCertificates").set(index, builder);
            this.tlsTrustedCertificates.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTlsTrustedCertificates(CertSecretSource ... items) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList();
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").add(builder);
            this.tlsTrustedCertificates.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTlsTrustedCertificates(Collection<CertSecretSource> items) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList();
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").add(builder);
            this.tlsTrustedCertificates.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTlsTrustedCertificates(CertSecretSource ... items) {
        if (this.tlsTrustedCertificates == null) {
            return (A)((Object)this);
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").remove((Object)builder);
            this.tlsTrustedCertificates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTlsTrustedCertificates(Collection<CertSecretSource> items) {
        if (this.tlsTrustedCertificates == null) {
            return (A)((Object)this);
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").remove((Object)builder);
            this.tlsTrustedCertificates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTlsTrustedCertificates(Predicate<CertSecretSourceBuilder> predicate) {
        if (this.tlsTrustedCertificates == null) {
            return (A)((Object)this);
        }
        Iterator<CertSecretSourceBuilder> each = this.tlsTrustedCertificates.iterator();
        List visitables = this._visitables.get((Object)"tlsTrustedCertificates");
        while (each.hasNext()) {
            CertSecretSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<CertSecretSource> buildTlsTrustedCertificates() {
        return this.tlsTrustedCertificates != null ? KafkaAuthorizationKeycloakFluent.build(this.tlsTrustedCertificates) : null;
    }

    public CertSecretSource buildTlsTrustedCertificate(int index) {
        return this.tlsTrustedCertificates.get(index).build();
    }

    public CertSecretSource buildFirstTlsTrustedCertificate() {
        return this.tlsTrustedCertificates.get(0).build();
    }

    public CertSecretSource buildLastTlsTrustedCertificate() {
        return this.tlsTrustedCertificates.get(this.tlsTrustedCertificates.size() - 1).build();
    }

    public CertSecretSource buildMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        for (CertSecretSourceBuilder item : this.tlsTrustedCertificates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        for (CertSecretSourceBuilder item : this.tlsTrustedCertificates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTlsTrustedCertificates(List<CertSecretSource> tlsTrustedCertificates) {
        if (this.tlsTrustedCertificates != null) {
            this._visitables.get((Object)"tlsTrustedCertificates").clear();
        }
        if (tlsTrustedCertificates != null) {
            this.tlsTrustedCertificates = new ArrayList();
            for (CertSecretSource item : tlsTrustedCertificates) {
                this.addToTlsTrustedCertificates(item);
            }
        } else {
            this.tlsTrustedCertificates = null;
        }
        return (A)((Object)this);
    }

    public A withTlsTrustedCertificates(CertSecretSource ... tlsTrustedCertificates) {
        if (this.tlsTrustedCertificates != null) {
            this.tlsTrustedCertificates.clear();
            this._visitables.remove((Object)"tlsTrustedCertificates");
        }
        if (tlsTrustedCertificates != null) {
            for (CertSecretSource item : tlsTrustedCertificates) {
                this.addToTlsTrustedCertificates(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTlsTrustedCertificates() {
        return this.tlsTrustedCertificates != null && !this.tlsTrustedCertificates.isEmpty();
    }

    public TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificate() {
        return new TlsTrustedCertificatesNested(-1, null);
    }

    public TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificateLike(CertSecretSource item) {
        return new TlsTrustedCertificatesNested(-1, item);
    }

    public TlsTrustedCertificatesNested<A> setNewTlsTrustedCertificateLike(int index, CertSecretSource item) {
        return new TlsTrustedCertificatesNested(index, item);
    }

    public TlsTrustedCertificatesNested<A> editTlsTrustedCertificate(int index) {
        if (this.tlsTrustedCertificates.size() <= index) {
            throw new RuntimeException("Can't edit tlsTrustedCertificates. Index exceeds size.");
        }
        return this.setNewTlsTrustedCertificateLike(index, this.buildTlsTrustedCertificate(index));
    }

    public TlsTrustedCertificatesNested<A> editFirstTlsTrustedCertificate() {
        if (this.tlsTrustedCertificates.size() == 0) {
            throw new RuntimeException("Can't edit first tlsTrustedCertificates. The list is empty.");
        }
        return this.setNewTlsTrustedCertificateLike(0, this.buildTlsTrustedCertificate(0));
    }

    public TlsTrustedCertificatesNested<A> editLastTlsTrustedCertificate() {
        int index = this.tlsTrustedCertificates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tlsTrustedCertificates. The list is empty.");
        }
        return this.setNewTlsTrustedCertificateLike(index, this.buildTlsTrustedCertificate(index));
    }

    public TlsTrustedCertificatesNested<A> editMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tlsTrustedCertificates.size(); ++i) {
            if (!predicate.test(this.tlsTrustedCertificates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tlsTrustedCertificates. No match found.");
        }
        return this.setNewTlsTrustedCertificateLike(index, this.buildTlsTrustedCertificate(index));
    }

    public boolean isDisableTlsHostnameVerification() {
        return this.disableTlsHostnameVerification;
    }

    public A withDisableTlsHostnameVerification(boolean disableTlsHostnameVerification) {
        this.disableTlsHostnameVerification = disableTlsHostnameVerification;
        return (A)((Object)this);
    }

    public boolean hasDisableTlsHostnameVerification() {
        return true;
    }

    public boolean isDelegateToKafkaAcls() {
        return this.delegateToKafkaAcls;
    }

    public A withDelegateToKafkaAcls(boolean delegateToKafkaAcls) {
        this.delegateToKafkaAcls = delegateToKafkaAcls;
        return (A)((Object)this);
    }

    public boolean hasDelegateToKafkaAcls() {
        return true;
    }

    public Integer getGrantsRefreshPeriodSeconds() {
        return this.grantsRefreshPeriodSeconds;
    }

    public A withGrantsRefreshPeriodSeconds(Integer grantsRefreshPeriodSeconds) {
        this.grantsRefreshPeriodSeconds = grantsRefreshPeriodSeconds;
        return (A)((Object)this);
    }

    public boolean hasGrantsRefreshPeriodSeconds() {
        return this.grantsRefreshPeriodSeconds != null;
    }

    public Integer getGrantsRefreshPoolSize() {
        return this.grantsRefreshPoolSize;
    }

    public A withGrantsRefreshPoolSize(Integer grantsRefreshPoolSize) {
        this.grantsRefreshPoolSize = grantsRefreshPoolSize;
        return (A)((Object)this);
    }

    public boolean hasGrantsRefreshPoolSize() {
        return this.grantsRefreshPoolSize != null;
    }

    public Integer getGrantsMaxIdleTimeSeconds() {
        return this.grantsMaxIdleTimeSeconds;
    }

    public A withGrantsMaxIdleTimeSeconds(Integer grantsMaxIdleTimeSeconds) {
        this.grantsMaxIdleTimeSeconds = grantsMaxIdleTimeSeconds;
        return (A)((Object)this);
    }

    public boolean hasGrantsMaxIdleTimeSeconds() {
        return this.grantsMaxIdleTimeSeconds != null;
    }

    public Integer getGrantsGcPeriodSeconds() {
        return this.grantsGcPeriodSeconds;
    }

    public A withGrantsGcPeriodSeconds(Integer grantsGcPeriodSeconds) {
        this.grantsGcPeriodSeconds = grantsGcPeriodSeconds;
        return (A)((Object)this);
    }

    public boolean hasGrantsGcPeriodSeconds() {
        return this.grantsGcPeriodSeconds != null;
    }

    public boolean isGrantsAlwaysLatest() {
        return this.grantsAlwaysLatest;
    }

    public A withGrantsAlwaysLatest(boolean grantsAlwaysLatest) {
        this.grantsAlwaysLatest = grantsAlwaysLatest;
        return (A)((Object)this);
    }

    public boolean hasGrantsAlwaysLatest() {
        return true;
    }

    public Integer getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    public A withConnectTimeoutSeconds(Integer connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
        return (A)((Object)this);
    }

    public boolean hasConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds != null;
    }

    public Integer getReadTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    public A withReadTimeoutSeconds(Integer readTimeoutSeconds) {
        this.readTimeoutSeconds = readTimeoutSeconds;
        return (A)((Object)this);
    }

    public boolean hasReadTimeoutSeconds() {
        return this.readTimeoutSeconds != null;
    }

    public Integer getHttpRetries() {
        return this.httpRetries;
    }

    public A withHttpRetries(Integer httpRetries) {
        this.httpRetries = httpRetries;
        return (A)((Object)this);
    }

    public boolean hasHttpRetries() {
        return this.httpRetries != null;
    }

    public A addToSuperUsers(int index, String item) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        }
        this.superUsers.add(index, item);
        return (A)((Object)this);
    }

    public A setToSuperUsers(int index, String item) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        }
        this.superUsers.set(index, item);
        return (A)((Object)this);
    }

    public A addToSuperUsers(String ... items) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        }
        for (String item : items) {
            this.superUsers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToSuperUsers(Collection<String> items) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        }
        for (String item : items) {
            this.superUsers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromSuperUsers(String ... items) {
        if (this.superUsers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.superUsers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSuperUsers(Collection<String> items) {
        if (this.superUsers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.superUsers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getSuperUsers() {
        return this.superUsers;
    }

    public String getSuperUser(int index) {
        return this.superUsers.get(index);
    }

    public String getFirstSuperUser() {
        return this.superUsers.get(0);
    }

    public String getLastSuperUser() {
        return this.superUsers.get(this.superUsers.size() - 1);
    }

    public String getMatchingSuperUser(Predicate<String> predicate) {
        for (String item : this.superUsers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSuperUser(Predicate<String> predicate) {
        for (String item : this.superUsers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSuperUsers(List<String> superUsers) {
        if (superUsers != null) {
            this.superUsers = new ArrayList<String>();
            for (String item : superUsers) {
                this.addToSuperUsers(item);
            }
        } else {
            this.superUsers = null;
        }
        return (A)((Object)this);
    }

    public A withSuperUsers(String ... superUsers) {
        if (this.superUsers != null) {
            this.superUsers.clear();
            this._visitables.remove((Object)"superUsers");
        }
        if (superUsers != null) {
            for (String item : superUsers) {
                this.addToSuperUsers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSuperUsers() {
        return this.superUsers != null && !this.superUsers.isEmpty();
    }

    public boolean isEnableMetrics() {
        return this.enableMetrics;
    }

    public A withEnableMetrics(boolean enableMetrics) {
        this.enableMetrics = enableMetrics;
        return (A)((Object)this);
    }

    public boolean hasEnableMetrics() {
        return true;
    }

    public boolean isIncludeAcceptHeader() {
        return this.includeAcceptHeader;
    }

    public A withIncludeAcceptHeader(boolean includeAcceptHeader) {
        this.includeAcceptHeader = includeAcceptHeader;
        return (A)((Object)this);
    }

    public boolean hasIncludeAcceptHeader() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaAuthorizationKeycloakFluent that = (KafkaAuthorizationKeycloakFluent)((Object)o);
        if (!Objects.equals(this.clientId, that.clientId)) {
            return false;
        }
        if (!Objects.equals(this.tokenEndpointUri, that.tokenEndpointUri)) {
            return false;
        }
        if (!Objects.equals(this.tlsTrustedCertificates, that.tlsTrustedCertificates)) {
            return false;
        }
        if (this.disableTlsHostnameVerification != that.disableTlsHostnameVerification) {
            return false;
        }
        if (this.delegateToKafkaAcls != that.delegateToKafkaAcls) {
            return false;
        }
        if (!Objects.equals(this.grantsRefreshPeriodSeconds, that.grantsRefreshPeriodSeconds)) {
            return false;
        }
        if (!Objects.equals(this.grantsRefreshPoolSize, that.grantsRefreshPoolSize)) {
            return false;
        }
        if (!Objects.equals(this.grantsMaxIdleTimeSeconds, that.grantsMaxIdleTimeSeconds)) {
            return false;
        }
        if (!Objects.equals(this.grantsGcPeriodSeconds, that.grantsGcPeriodSeconds)) {
            return false;
        }
        if (this.grantsAlwaysLatest != that.grantsAlwaysLatest) {
            return false;
        }
        if (!Objects.equals(this.connectTimeoutSeconds, that.connectTimeoutSeconds)) {
            return false;
        }
        if (!Objects.equals(this.readTimeoutSeconds, that.readTimeoutSeconds)) {
            return false;
        }
        if (!Objects.equals(this.httpRetries, that.httpRetries)) {
            return false;
        }
        if (!Objects.equals(this.superUsers, that.superUsers)) {
            return false;
        }
        if (this.enableMetrics != that.enableMetrics) {
            return false;
        }
        return this.includeAcceptHeader == that.includeAcceptHeader;
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.tokenEndpointUri, this.tlsTrustedCertificates, this.disableTlsHostnameVerification, this.delegateToKafkaAcls, this.grantsRefreshPeriodSeconds, this.grantsRefreshPoolSize, this.grantsMaxIdleTimeSeconds, this.grantsGcPeriodSeconds, this.grantsAlwaysLatest, this.connectTimeoutSeconds, this.readTimeoutSeconds, this.httpRetries, this.superUsers, this.enableMetrics, this.includeAcceptHeader, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientId != null) {
            sb.append("clientId:");
            sb.append(this.clientId + ",");
        }
        if (this.tokenEndpointUri != null) {
            sb.append("tokenEndpointUri:");
            sb.append(this.tokenEndpointUri + ",");
        }
        if (this.tlsTrustedCertificates != null && !this.tlsTrustedCertificates.isEmpty()) {
            sb.append("tlsTrustedCertificates:");
            sb.append(this.tlsTrustedCertificates + ",");
        }
        sb.append("disableTlsHostnameVerification:");
        sb.append(this.disableTlsHostnameVerification + ",");
        sb.append("delegateToKafkaAcls:");
        sb.append(this.delegateToKafkaAcls + ",");
        if (this.grantsRefreshPeriodSeconds != null) {
            sb.append("grantsRefreshPeriodSeconds:");
            sb.append(this.grantsRefreshPeriodSeconds + ",");
        }
        if (this.grantsRefreshPoolSize != null) {
            sb.append("grantsRefreshPoolSize:");
            sb.append(this.grantsRefreshPoolSize + ",");
        }
        if (this.grantsMaxIdleTimeSeconds != null) {
            sb.append("grantsMaxIdleTimeSeconds:");
            sb.append(this.grantsMaxIdleTimeSeconds + ",");
        }
        if (this.grantsGcPeriodSeconds != null) {
            sb.append("grantsGcPeriodSeconds:");
            sb.append(this.grantsGcPeriodSeconds + ",");
        }
        sb.append("grantsAlwaysLatest:");
        sb.append(this.grantsAlwaysLatest + ",");
        if (this.connectTimeoutSeconds != null) {
            sb.append("connectTimeoutSeconds:");
            sb.append(this.connectTimeoutSeconds + ",");
        }
        if (this.readTimeoutSeconds != null) {
            sb.append("readTimeoutSeconds:");
            sb.append(this.readTimeoutSeconds + ",");
        }
        if (this.httpRetries != null) {
            sb.append("httpRetries:");
            sb.append(this.httpRetries + ",");
        }
        if (this.superUsers != null && !this.superUsers.isEmpty()) {
            sb.append("superUsers:");
            sb.append(this.superUsers + ",");
        }
        sb.append("enableMetrics:");
        sb.append(this.enableMetrics + ",");
        sb.append("includeAcceptHeader:");
        sb.append(this.includeAcceptHeader);
        sb.append("}");
        return sb.toString();
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "io.strimzi.api.kafka.model.CertAndKeySecretSource": {
                return new CertAndKeySecretSourceBuilder((CertAndKeySecretSource)item);
            }
        }
        return KafkaAuthorizationKeycloakFluent.builderOf((Object)item);
    }

    public A withDisableTlsHostnameVerification() {
        return this.withDisableTlsHostnameVerification(true);
    }

    public A withDelegateToKafkaAcls() {
        return this.withDelegateToKafkaAcls(true);
    }

    public A withGrantsAlwaysLatest() {
        return this.withGrantsAlwaysLatest(true);
    }

    public A withEnableMetrics() {
        return this.withEnableMetrics(true);
    }

    public A withIncludeAcceptHeader() {
        return this.withIncludeAcceptHeader(true);
    }

    public class TlsTrustedCertificatesNested<N>
    extends CertSecretSourceFluent<TlsTrustedCertificatesNested<N>>
    implements Nested<N> {
        CertSecretSourceBuilder builder;
        int index;

        TlsTrustedCertificatesNested(int index, CertSecretSource item) {
            this.index = index;
            this.builder = new CertSecretSourceBuilder(this, item);
        }

        public N and() {
            return (N)KafkaAuthorizationKeycloakFluent.this.setToTlsTrustedCertificates(this.index, this.builder.build());
        }

        public N endTlsTrustedCertificate() {
            return this.and();
        }
    }
}

