/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.KafkaBridgeHttpCors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaBridgeHttpCorsFluent<A extends KafkaBridgeHttpCorsFluent<A>>
extends BaseFluent<A> {
    private List<String> allowedOrigins;
    private List<String> allowedMethods;

    public KafkaBridgeHttpCorsFluent() {
    }

    public KafkaBridgeHttpCorsFluent(KafkaBridgeHttpCors instance) {
        KafkaBridgeHttpCors kafkaBridgeHttpCors = instance = instance != null ? instance : new KafkaBridgeHttpCors();
        if (instance != null) {
            this.withAllowedOrigins(instance.getAllowedOrigins());
            this.withAllowedMethods(instance.getAllowedMethods());
        }
    }

    public A addToAllowedOrigins(int index, String item) {
        if (this.allowedOrigins == null) {
            this.allowedOrigins = new ArrayList<String>();
        }
        this.allowedOrigins.add(index, item);
        return (A)((Object)this);
    }

    public A setToAllowedOrigins(int index, String item) {
        if (this.allowedOrigins == null) {
            this.allowedOrigins = new ArrayList<String>();
        }
        this.allowedOrigins.set(index, item);
        return (A)((Object)this);
    }

    public A addToAllowedOrigins(String ... items) {
        if (this.allowedOrigins == null) {
            this.allowedOrigins = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedOrigins.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAllowedOrigins(Collection<String> items) {
        if (this.allowedOrigins == null) {
            this.allowedOrigins = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedOrigins.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAllowedOrigins(String ... items) {
        if (this.allowedOrigins == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.allowedOrigins.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAllowedOrigins(Collection<String> items) {
        if (this.allowedOrigins == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.allowedOrigins.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public String getAllowedOrigin(int index) {
        return this.allowedOrigins.get(index);
    }

    public String getFirstAllowedOrigin() {
        return this.allowedOrigins.get(0);
    }

    public String getLastAllowedOrigin() {
        return this.allowedOrigins.get(this.allowedOrigins.size() - 1);
    }

    public String getMatchingAllowedOrigin(Predicate<String> predicate) {
        for (String item : this.allowedOrigins) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAllowedOrigin(Predicate<String> predicate) {
        for (String item : this.allowedOrigins) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAllowedOrigins(List<String> allowedOrigins) {
        if (allowedOrigins != null) {
            this.allowedOrigins = new ArrayList<String>();
            for (String item : allowedOrigins) {
                this.addToAllowedOrigins(item);
            }
        } else {
            this.allowedOrigins = null;
        }
        return (A)((Object)this);
    }

    public A withAllowedOrigins(String ... allowedOrigins) {
        if (this.allowedOrigins != null) {
            this.allowedOrigins.clear();
            this._visitables.remove((Object)"allowedOrigins");
        }
        if (allowedOrigins != null) {
            for (String item : allowedOrigins) {
                this.addToAllowedOrigins(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAllowedOrigins() {
        return this.allowedOrigins != null && !this.allowedOrigins.isEmpty();
    }

    public A addToAllowedMethods(int index, String item) {
        if (this.allowedMethods == null) {
            this.allowedMethods = new ArrayList<String>();
        }
        this.allowedMethods.add(index, item);
        return (A)((Object)this);
    }

    public A setToAllowedMethods(int index, String item) {
        if (this.allowedMethods == null) {
            this.allowedMethods = new ArrayList<String>();
        }
        this.allowedMethods.set(index, item);
        return (A)((Object)this);
    }

    public A addToAllowedMethods(String ... items) {
        if (this.allowedMethods == null) {
            this.allowedMethods = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedMethods.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAllowedMethods(Collection<String> items) {
        if (this.allowedMethods == null) {
            this.allowedMethods = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedMethods.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAllowedMethods(String ... items) {
        if (this.allowedMethods == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.allowedMethods.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAllowedMethods(Collection<String> items) {
        if (this.allowedMethods == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.allowedMethods.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    public String getAllowedMethod(int index) {
        return this.allowedMethods.get(index);
    }

    public String getFirstAllowedMethod() {
        return this.allowedMethods.get(0);
    }

    public String getLastAllowedMethod() {
        return this.allowedMethods.get(this.allowedMethods.size() - 1);
    }

    public String getMatchingAllowedMethod(Predicate<String> predicate) {
        for (String item : this.allowedMethods) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAllowedMethod(Predicate<String> predicate) {
        for (String item : this.allowedMethods) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAllowedMethods(List<String> allowedMethods) {
        if (allowedMethods != null) {
            this.allowedMethods = new ArrayList<String>();
            for (String item : allowedMethods) {
                this.addToAllowedMethods(item);
            }
        } else {
            this.allowedMethods = null;
        }
        return (A)((Object)this);
    }

    public A withAllowedMethods(String ... allowedMethods) {
        if (this.allowedMethods != null) {
            this.allowedMethods.clear();
            this._visitables.remove((Object)"allowedMethods");
        }
        if (allowedMethods != null) {
            for (String item : allowedMethods) {
                this.addToAllowedMethods(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAllowedMethods() {
        return this.allowedMethods != null && !this.allowedMethods.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaBridgeHttpCorsFluent that = (KafkaBridgeHttpCorsFluent)((Object)o);
        if (!Objects.equals(this.allowedOrigins, that.allowedOrigins)) {
            return false;
        }
        return Objects.equals(this.allowedMethods, that.allowedMethods);
    }

    public int hashCode() {
        return Objects.hash(this.allowedOrigins, this.allowedMethods, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowedOrigins != null && !this.allowedOrigins.isEmpty()) {
            sb.append("allowedOrigins:");
            sb.append(this.allowedOrigins + ",");
        }
        if (this.allowedMethods != null && !this.allowedMethods.isEmpty()) {
            sb.append("allowedMethods:");
            sb.append(this.allowedMethods);
        }
        sb.append("}");
        return sb.toString();
    }
}

