/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.HasConfigurableLogging;
import io.strimzi.api.kafka.model.HasConfigurableMetrics;
import io.strimzi.api.kafka.model.HasJmxOptions;
import io.strimzi.api.kafka.model.HasLivenessProbe;
import io.strimzi.api.kafka.model.HasReadinessProbe;
import io.strimzi.api.kafka.model.JvmOptions;
import io.strimzi.api.kafka.model.KafkaAuthorization;
import io.strimzi.api.kafka.model.KafkaJmxOptions;
import io.strimzi.api.kafka.model.Logging;
import io.strimzi.api.kafka.model.MetricsConfig;
import io.strimzi.api.kafka.model.Probe;
import io.strimzi.api.kafka.model.Rack;
import io.strimzi.api.kafka.model.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener;
import io.strimzi.api.kafka.model.storage.Storage;
import io.strimzi.api.kafka.model.template.KafkaClusterTemplate;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import io.strimzi.crdgenerator.annotations.KubeLink;
import io.strimzi.crdgenerator.annotations.Minimum;
import io.strimzi.crdgenerator.annotations.MinimumItems;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"version", "replicas", "image", "listeners", "config", "storage", "authorization", "rack", "brokerRackInitImage", "livenessProbe", "readinessProbe", "jvmOptions", "jmxOptions", "resources", "metricsConfig", "logging", "template"})
public class KafkaClusterSpec
implements HasConfigurableMetrics,
HasConfigurableLogging,
HasJmxOptions,
HasReadinessProbe,
HasLivenessProbe,
UnknownPropertyPreserving,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FORBIDDEN_PREFIXES = "listeners, advertised., broker., listener., host.name, port, inter.broker.listener.name, sasl., ssl., security., password., log.dir, zookeeper.connect, zookeeper.set.acl, zookeeper.ssl, zookeeper.clientCnxnSocket, authorizer., super.user, cruise.control.metrics.topic, cruise.control.metrics.reporter.bootstrap.servers,node.id, process.roles, controller., metadata.log.dir";
    public static final String FORBIDDEN_PREFIX_EXCEPTIONS = "zookeeper.connection.timeout.ms, sasl.server.max.receive.size,ssl.cipher.suites, ssl.protocol, ssl.enabled.protocols, ssl.secure.random.implementation,cruise.control.metrics.topic.num.partitions, cruise.control.metrics.topic.replication.factor, cruise.control.metrics.topic.retention.ms,cruise.control.metrics.topic.auto.create.retries, cruise.control.metrics.topic.auto.create.timeout.ms,cruise.control.metrics.topic.min.insync.replicas,controller.quorum.election.backoff.max.ms, controller.quorum.election.timeout.ms, controller.quorum.fetch.timeout.ms";
    protected Storage storage;
    private String version;
    private Map<String, Object> config = new HashMap<String, Object>(0);
    private String brokerRackInitImage;
    private Rack rack;
    private Logging logging;
    private int replicas;
    private String image;
    private ResourceRequirements resources;
    private Probe livenessProbe;
    private Probe readinessProbe;
    private JvmOptions jvmOptions;
    private KafkaJmxOptions jmxOptions;
    private MetricsConfig metricsConfig;
    private List<GenericKafkaListener> listeners;
    private KafkaAuthorization authorization;
    private KafkaClusterTemplate template;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    @Description(value="The kafka broker version. Defaults to {DefaultKafkaVersion}. Consult the user documentation to understand the process required to upgrade or downgrade the version.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Description(value="Kafka broker config properties with the following prefixes cannot be set: listeners, advertised., broker., listener., host.name, port, inter.broker.listener.name, sasl., ssl., security., password., log.dir, zookeeper.connect, zookeeper.set.acl, zookeeper.ssl, zookeeper.clientCnxnSocket, authorizer., super.user, cruise.control.metrics.topic, cruise.control.metrics.reporter.bootstrap.servers,node.id, process.roles, controller., metadata.log.dir (with the exception of: zookeeper.connection.timeout.ms, sasl.server.max.receive.size,ssl.cipher.suites, ssl.protocol, ssl.enabled.protocols, ssl.secure.random.implementation,cruise.control.metrics.topic.num.partitions, cruise.control.metrics.topic.replication.factor, cruise.control.metrics.topic.retention.ms,cruise.control.metrics.topic.auto.create.retries, cruise.control.metrics.topic.auto.create.timeout.ms,cruise.control.metrics.topic.min.insync.replicas,controller.quorum.election.backoff.max.ms, controller.quorum.election.timeout.ms, controller.quorum.fetch.timeout.ms).")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    @Description(value="The image of the init container used for initializing the `broker.rack`.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBrokerRackInitImage() {
        return this.brokerRackInitImage;
    }

    public void setBrokerRackInitImage(String brokerRackInitImage) {
        this.brokerRackInitImage = brokerRackInitImage;
    }

    @Description(value="Configuration of the `broker.rack` broker config.")
    @JsonProperty(value="rack")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Rack getRack() {
        return this.rack;
    }

    public void setRack(Rack rack) {
        this.rack = rack;
    }

    @Description(value="Storage configuration (disk). Cannot be updated.")
    @JsonProperty(required=true)
    public Storage getStorage() {
        return this.storage;
    }

    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    @Override
    @Description(value="Logging configuration for Kafka")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Logging getLogging() {
        return this.logging;
    }

    @Override
    public void setLogging(Logging logging) {
        this.logging = logging;
    }

    @Description(value="The number of pods in the cluster.")
    @Minimum(value=1)
    @JsonProperty(required=true)
    public int getReplicas() {
        return this.replicas;
    }

    public void setReplicas(int replicas) {
        this.replicas = replicas;
    }

    @Description(value="The docker image for the pods. The default value depends on the configured `Kafka.spec.kafka.version`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @KubeLink(group="core", version="v1", kind="resourcerequirements")
    @Description(value="CPU and memory resources to reserve.")
    public ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(ResourceRequirements resources) {
        this.resources = resources;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="Pod liveness checking.")
    public Probe getLivenessProbe() {
        return this.livenessProbe;
    }

    @Override
    public void setLivenessProbe(Probe livenessProbe) {
        this.livenessProbe = livenessProbe;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @Description(value="Pod readiness checking.")
    public Probe getReadinessProbe() {
        return this.readinessProbe;
    }

    @Override
    public void setReadinessProbe(Probe readinessProbe) {
        this.readinessProbe = readinessProbe;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="JVM Options for pods")
    public JvmOptions getJvmOptions() {
        return this.jvmOptions;
    }

    public void setJvmOptions(JvmOptions jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="JMX Options for Kafka brokers")
    @JsonProperty(value="jmxOptions")
    public KafkaJmxOptions getJmxOptions() {
        return this.jmxOptions;
    }

    @Override
    public void setJmxOptions(KafkaJmxOptions jmxOptions) {
        this.jmxOptions = jmxOptions;
    }

    @Override
    @Description(value="Metrics configuration.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public MetricsConfig getMetricsConfig() {
        return this.metricsConfig;
    }

    @Override
    public void setMetricsConfig(MetricsConfig metricsConfig) {
        this.metricsConfig = metricsConfig;
    }

    @Description(value="Configures listeners of Kafka brokers")
    @MinimumItems(value=1)
    @JsonProperty(required=true)
    public List<GenericKafkaListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<GenericKafkaListener> listeners) {
        this.listeners = listeners;
    }

    @Description(value="Authorization configuration for Kafka brokers")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public KafkaAuthorization getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(KafkaAuthorization authorization) {
        this.authorization = authorization;
    }

    @Override
    @Description(value="Template for Kafka cluster resources. The template allows users to specify how the Kubernetes resources are generated.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public KafkaClusterTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(KafkaClusterTemplate template) {
        this.template = template;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaClusterSpec)) {
            return false;
        }
        KafkaClusterSpec other = (KafkaClusterSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getReplicas() != other.getReplicas()) {
            return false;
        }
        Storage this$storage = this.getStorage();
        Storage other$storage = other.getStorage();
        if (this$storage == null ? other$storage != null : !((Object)this$storage).equals(other$storage)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Map<String, Object> this$config = this.getConfig();
        Map<String, Object> other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        String this$brokerRackInitImage = this.getBrokerRackInitImage();
        String other$brokerRackInitImage = other.getBrokerRackInitImage();
        if (this$brokerRackInitImage == null ? other$brokerRackInitImage != null : !this$brokerRackInitImage.equals(other$brokerRackInitImage)) {
            return false;
        }
        Rack this$rack = this.getRack();
        Rack other$rack = other.getRack();
        if (this$rack == null ? other$rack != null : !((Object)this$rack).equals(other$rack)) {
            return false;
        }
        Logging this$logging = this.getLogging();
        Logging other$logging = other.getLogging();
        if (this$logging == null ? other$logging != null : !((Object)this$logging).equals(other$logging)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        ResourceRequirements this$resources = this.getResources();
        ResourceRequirements other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !this$resources.equals(other$resources)) {
            return false;
        }
        Probe this$livenessProbe = this.getLivenessProbe();
        Probe other$livenessProbe = other.getLivenessProbe();
        if (this$livenessProbe == null ? other$livenessProbe != null : !((Object)this$livenessProbe).equals(other$livenessProbe)) {
            return false;
        }
        Probe this$readinessProbe = this.getReadinessProbe();
        Probe other$readinessProbe = other.getReadinessProbe();
        if (this$readinessProbe == null ? other$readinessProbe != null : !((Object)this$readinessProbe).equals(other$readinessProbe)) {
            return false;
        }
        JvmOptions this$jvmOptions = this.getJvmOptions();
        JvmOptions other$jvmOptions = other.getJvmOptions();
        if (this$jvmOptions == null ? other$jvmOptions != null : !((Object)this$jvmOptions).equals(other$jvmOptions)) {
            return false;
        }
        KafkaJmxOptions this$jmxOptions = this.getJmxOptions();
        KafkaJmxOptions other$jmxOptions = other.getJmxOptions();
        if (this$jmxOptions == null ? other$jmxOptions != null : !((Object)this$jmxOptions).equals(other$jmxOptions)) {
            return false;
        }
        MetricsConfig this$metricsConfig = this.getMetricsConfig();
        MetricsConfig other$metricsConfig = other.getMetricsConfig();
        if (this$metricsConfig == null ? other$metricsConfig != null : !((Object)this$metricsConfig).equals(other$metricsConfig)) {
            return false;
        }
        List<GenericKafkaListener> this$listeners = this.getListeners();
        List<GenericKafkaListener> other$listeners = other.getListeners();
        if (this$listeners == null ? other$listeners != null : !((Object)this$listeners).equals(other$listeners)) {
            return false;
        }
        KafkaAuthorization this$authorization = this.getAuthorization();
        KafkaAuthorization other$authorization = other.getAuthorization();
        if (this$authorization == null ? other$authorization != null : !((Object)this$authorization).equals(other$authorization)) {
            return false;
        }
        KafkaClusterTemplate this$template = this.getTemplate();
        KafkaClusterTemplate other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !((Object)this$template).equals(other$template)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaClusterSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getReplicas();
        Storage $storage = this.getStorage();
        result = result * 59 + ($storage == null ? 43 : ((Object)$storage).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Map<String, Object> $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        String $brokerRackInitImage = this.getBrokerRackInitImage();
        result = result * 59 + ($brokerRackInitImage == null ? 43 : $brokerRackInitImage.hashCode());
        Rack $rack = this.getRack();
        result = result * 59 + ($rack == null ? 43 : ((Object)$rack).hashCode());
        Logging $logging = this.getLogging();
        result = result * 59 + ($logging == null ? 43 : ((Object)$logging).hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        ResourceRequirements $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : $resources.hashCode());
        Probe $livenessProbe = this.getLivenessProbe();
        result = result * 59 + ($livenessProbe == null ? 43 : ((Object)$livenessProbe).hashCode());
        Probe $readinessProbe = this.getReadinessProbe();
        result = result * 59 + ($readinessProbe == null ? 43 : ((Object)$readinessProbe).hashCode());
        JvmOptions $jvmOptions = this.getJvmOptions();
        result = result * 59 + ($jvmOptions == null ? 43 : ((Object)$jvmOptions).hashCode());
        KafkaJmxOptions $jmxOptions = this.getJmxOptions();
        result = result * 59 + ($jmxOptions == null ? 43 : ((Object)$jmxOptions).hashCode());
        MetricsConfig $metricsConfig = this.getMetricsConfig();
        result = result * 59 + ($metricsConfig == null ? 43 : ((Object)$metricsConfig).hashCode());
        List<GenericKafkaListener> $listeners = this.getListeners();
        result = result * 59 + ($listeners == null ? 43 : ((Object)$listeners).hashCode());
        KafkaAuthorization $authorization = this.getAuthorization();
        result = result * 59 + ($authorization == null ? 43 : ((Object)$authorization).hashCode());
        KafkaClusterTemplate $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : ((Object)$template).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

