/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.KafkaExporterSpec;
import io.strimzi.api.kafka.model.Probe;
import io.strimzi.api.kafka.model.ProbeBuilder;
import io.strimzi.api.kafka.model.ProbeFluent;
import io.strimzi.api.kafka.model.template.KafkaExporterTemplate;
import io.strimzi.api.kafka.model.template.KafkaExporterTemplateBuilder;
import io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent;
import java.util.Objects;
import java.util.Optional;

public class KafkaExporterSpecFluent<A extends KafkaExporterSpecFluent<A>>
extends BaseFluent<A> {
    private String image;
    private String groupRegex;
    private String topicRegex;
    private String topicExcludeRegex;
    private String groupExcludeRegex;
    private ResourceRequirements resources;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private String logging;
    private boolean enableSaramaLogging;
    private KafkaExporterTemplateBuilder template;

    public KafkaExporterSpecFluent() {
    }

    public KafkaExporterSpecFluent(KafkaExporterSpec instance) {
        KafkaExporterSpec kafkaExporterSpec = instance = instance != null ? instance : new KafkaExporterSpec();
        if (instance != null) {
            this.withImage(instance.getImage());
            this.withGroupRegex(instance.getGroupRegex());
            this.withTopicRegex(instance.getTopicRegex());
            this.withTopicExcludeRegex(instance.getTopicExcludeRegex());
            this.withGroupExcludeRegex(instance.getGroupExcludeRegex());
            this.withResources(instance.getResources());
            this.withLivenessProbe(instance.getLivenessProbe());
            this.withReadinessProbe(instance.getReadinessProbe());
            this.withLogging(instance.getLogging());
            this.withEnableSaramaLogging(instance.getEnableSaramaLogging());
            this.withTemplate(instance.getTemplate());
        }
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public String getGroupRegex() {
        return this.groupRegex;
    }

    public A withGroupRegex(String groupRegex) {
        this.groupRegex = groupRegex;
        return (A)((Object)this);
    }

    public boolean hasGroupRegex() {
        return this.groupRegex != null;
    }

    public String getTopicRegex() {
        return this.topicRegex;
    }

    public A withTopicRegex(String topicRegex) {
        this.topicRegex = topicRegex;
        return (A)((Object)this);
    }

    public boolean hasTopicRegex() {
        return this.topicRegex != null;
    }

    public String getTopicExcludeRegex() {
        return this.topicExcludeRegex;
    }

    public A withTopicExcludeRegex(String topicExcludeRegex) {
        this.topicExcludeRegex = topicExcludeRegex;
        return (A)((Object)this);
    }

    public boolean hasTopicExcludeRegex() {
        return this.topicExcludeRegex != null;
    }

    public String getGroupExcludeRegex() {
        return this.groupExcludeRegex;
    }

    public A withGroupExcludeRegex(String groupExcludeRegex) {
        this.groupExcludeRegex = groupExcludeRegex;
        return (A)((Object)this);
    }

    public boolean hasGroupExcludeRegex() {
        return this.groupExcludeRegex != null;
    }

    public ResourceRequirements getResources() {
        return this.resources;
    }

    public A withResources(ResourceRequirements resources) {
        this.resources = resources;
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.get((Object)"livenessProbe").remove((Object)this.livenessProbe);
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.get((Object)"livenessProbe").add(this.livenessProbe);
        } else {
            this.livenessProbe = null;
            this._visitables.get((Object)"livenessProbe").remove((Object)this.livenessProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    public A withNewLivenessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNested(null);
    }

    public LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNested(item);
    }

    public LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(null));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(new ProbeBuilder().build()));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(item));
    }

    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.get((Object)"readinessProbe").remove((Object)this.readinessProbe);
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.get((Object)"readinessProbe").add(this.readinessProbe);
        } else {
            this.readinessProbe = null;
            this._visitables.get((Object)"readinessProbe").remove((Object)this.readinessProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    public A withNewReadinessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNested(null);
    }

    public ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNested(item);
    }

    public ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(null));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(new ProbeBuilder().build()));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(item));
    }

    public String getLogging() {
        return this.logging;
    }

    public A withLogging(String logging) {
        this.logging = logging;
        return (A)((Object)this);
    }

    public boolean hasLogging() {
        return this.logging != null;
    }

    public boolean isEnableSaramaLogging() {
        return this.enableSaramaLogging;
    }

    public A withEnableSaramaLogging(boolean enableSaramaLogging) {
        this.enableSaramaLogging = enableSaramaLogging;
        return (A)((Object)this);
    }

    public boolean hasEnableSaramaLogging() {
        return true;
    }

    public KafkaExporterTemplate buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public A withTemplate(KafkaExporterTemplate template) {
        this._visitables.get((Object)"template").remove((Object)this.template);
        if (template != null) {
            this.template = new KafkaExporterTemplateBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove((Object)this.template);
        }
        return (A)((Object)this);
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(KafkaExporterTemplate item) {
        return new TemplateNested(item);
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new KafkaExporterTemplateBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(KafkaExporterTemplate item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaExporterSpecFluent that = (KafkaExporterSpecFluent)((Object)o);
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.groupRegex, that.groupRegex)) {
            return false;
        }
        if (!Objects.equals(this.topicRegex, that.topicRegex)) {
            return false;
        }
        if (!Objects.equals(this.topicExcludeRegex, that.topicExcludeRegex)) {
            return false;
        }
        if (!Objects.equals(this.groupExcludeRegex, that.groupExcludeRegex)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals((Object)this.livenessProbe, (Object)that.livenessProbe)) {
            return false;
        }
        if (!Objects.equals((Object)this.readinessProbe, (Object)that.readinessProbe)) {
            return false;
        }
        if (!Objects.equals(this.logging, that.logging)) {
            return false;
        }
        if (this.enableSaramaLogging != that.enableSaramaLogging) {
            return false;
        }
        return Objects.equals((Object)this.template, (Object)that.template);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.image, this.groupRegex, this.topicRegex, this.topicExcludeRegex, this.groupExcludeRegex, this.resources, this.livenessProbe, this.readinessProbe, this.logging, this.enableSaramaLogging, this.template, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.groupRegex != null) {
            sb.append("groupRegex:");
            sb.append(this.groupRegex + ",");
        }
        if (this.topicRegex != null) {
            sb.append("topicRegex:");
            sb.append(this.topicRegex + ",");
        }
        if (this.topicExcludeRegex != null) {
            sb.append("topicExcludeRegex:");
            sb.append(this.topicExcludeRegex + ",");
        }
        if (this.groupExcludeRegex != null) {
            sb.append("groupExcludeRegex:");
            sb.append(this.groupExcludeRegex + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.livenessProbe != null) {
            sb.append("livenessProbe:");
            sb.append(this.livenessProbe + ",");
        }
        if (this.readinessProbe != null) {
            sb.append("readinessProbe:");
            sb.append(this.readinessProbe + ",");
        }
        if (this.logging != null) {
            sb.append("logging:");
            sb.append(this.logging + ",");
        }
        sb.append("enableSaramaLogging:");
        sb.append(this.enableSaramaLogging + ",");
        if (this.template != null) {
            sb.append("template:");
            sb.append((Object)this.template);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnableSaramaLogging() {
        return this.withEnableSaramaLogging(true);
    }

    public class LivenessProbeNested<N>
    extends ProbeFluent<LivenessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        LivenessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)KafkaExporterSpecFluent.this.withLivenessProbe(this.builder.build());
        }

        public N endLivenessProbe() {
            return this.and();
        }
    }

    public class ReadinessProbeNested<N>
    extends ProbeFluent<ReadinessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        ReadinessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)KafkaExporterSpecFluent.this.withReadinessProbe(this.builder.build());
        }

        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class TemplateNested<N>
    extends KafkaExporterTemplateFluent<TemplateNested<N>>
    implements Nested<N> {
        KafkaExporterTemplateBuilder builder;

        TemplateNested(KafkaExporterTemplate item) {
            this.builder = new KafkaExporterTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaExporterSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }
}

