/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.KafkaMirrorMakerClientSpec;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import io.strimzi.crdgenerator.annotations.Minimum;
import java.util.Map;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"numStreams", "offsetCommitInterval", "bootstrapServers", "groupId", "logging"})
public class KafkaMirrorMakerConsumerSpec
extends KafkaMirrorMakerClientSpec {
    private static final long serialVersionUID = 1L;
    public static final String FORBIDDEN_PREFIXES = "ssl., bootstrap.servers, group.id, sasl., security., interceptor.classes";
    public static final String FORBIDDEN_PREFIX_EXCEPTIONS = "ssl.endpoint.identification.algorithm, ssl.cipher.suites, ssl.protocol, ssl.enabled.protocols";
    private Integer numStreams;
    private String groupId;
    private Integer offsetCommitInterval;

    @Override
    @Description(value="The MirrorMaker consumer config. Properties with the following prefixes cannot be set: ssl., bootstrap.servers, group.id, sasl., security., interceptor.classes (with the exception of: ssl.endpoint.identification.algorithm, ssl.cipher.suites, ssl.protocol, ssl.enabled.protocols).")
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @Description(value="Specifies the number of consumer stream threads to create.")
    @Minimum(value=1)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getNumStreams() {
        return this.numStreams;
    }

    public void setNumStreams(Integer numStreams) {
        this.numStreams = numStreams;
    }

    @Description(value="A unique string that identifies the consumer group this consumer belongs to.")
    @JsonProperty(required=true)
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Description(value="Specifies the offset auto-commit interval in ms. Default value is 60000.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Integer getOffsetCommitInterval() {
        return this.offsetCommitInterval;
    }

    public void setOffsetCommitInterval(Integer offsetCommitInterval) {
        this.offsetCommitInterval = offsetCommitInterval;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaMirrorMakerConsumerSpec)) {
            return false;
        }
        KafkaMirrorMakerConsumerSpec other = (KafkaMirrorMakerConsumerSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$numStreams = this.getNumStreams();
        Integer other$numStreams = other.getNumStreams();
        if (this$numStreams == null ? other$numStreams != null : !((Object)this$numStreams).equals(other$numStreams)) {
            return false;
        }
        Integer this$offsetCommitInterval = this.getOffsetCommitInterval();
        Integer other$offsetCommitInterval = other.getOffsetCommitInterval();
        if (this$offsetCommitInterval == null ? other$offsetCommitInterval != null : !((Object)this$offsetCommitInterval).equals(other$offsetCommitInterval)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        return !(this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaMirrorMakerConsumerSpec;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $numStreams = this.getNumStreams();
        result = result * 59 + ($numStreams == null ? 43 : ((Object)$numStreams).hashCode());
        Integer $offsetCommitInterval = this.getOffsetCommitInterval();
        result = result * 59 + ($offsetCommitInterval == null ? 43 : ((Object)$offsetCommitInterval).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        return result;
    }
}

