/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.ExternalLogging;
import io.strimzi.api.kafka.model.ExternalLoggingBuilder;
import io.strimzi.api.kafka.model.ExternalLoggingFluent;
import io.strimzi.api.kafka.model.InlineLogging;
import io.strimzi.api.kafka.model.InlineLoggingBuilder;
import io.strimzi.api.kafka.model.InlineLoggingFluent;
import io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics;
import io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder;
import io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsFluent;
import io.strimzi.api.kafka.model.JvmOptions;
import io.strimzi.api.kafka.model.JvmOptionsBuilder;
import io.strimzi.api.kafka.model.JvmOptionsFluent;
import io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpec;
import io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpecBuilder;
import io.strimzi.api.kafka.model.KafkaMirrorMakerConsumerSpecFluent;
import io.strimzi.api.kafka.model.KafkaMirrorMakerProducerSpec;
import io.strimzi.api.kafka.model.KafkaMirrorMakerProducerSpecBuilder;
import io.strimzi.api.kafka.model.KafkaMirrorMakerProducerSpecFluent;
import io.strimzi.api.kafka.model.KafkaMirrorMakerSpec;
import io.strimzi.api.kafka.model.Logging;
import io.strimzi.api.kafka.model.MetricsConfig;
import io.strimzi.api.kafka.model.Probe;
import io.strimzi.api.kafka.model.ProbeBuilder;
import io.strimzi.api.kafka.model.ProbeFluent;
import io.strimzi.api.kafka.model.SpecFluent;
import io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplate;
import io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplateBuilder;
import io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplateFluent;
import io.strimzi.api.kafka.model.tracing.JaegerTracing;
import io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder;
import io.strimzi.api.kafka.model.tracing.JaegerTracingFluent;
import io.strimzi.api.kafka.model.tracing.OpenTelemetryTracing;
import io.strimzi.api.kafka.model.tracing.OpenTelemetryTracingBuilder;
import io.strimzi.api.kafka.model.tracing.OpenTelemetryTracingFluent;
import io.strimzi.api.kafka.model.tracing.Tracing;
import java.util.Objects;
import java.util.Optional;

public class KafkaMirrorMakerSpecFluent<A extends KafkaMirrorMakerSpecFluent<A>>
extends SpecFluent<A> {
    private int replicas;
    private String version;
    private String image;
    private String whitelist;
    private String include;
    private KafkaMirrorMakerConsumerSpecBuilder consumer;
    private KafkaMirrorMakerProducerSpecBuilder producer;
    private ResourceRequirements resources;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private JvmOptionsBuilder jvmOptions;
    private VisitableBuilder<? extends Logging, ?> logging;
    private VisitableBuilder<? extends MetricsConfig, ?> metricsConfig;
    private VisitableBuilder<? extends Tracing, ?> tracing;
    private KafkaMirrorMakerTemplateBuilder template;

    public KafkaMirrorMakerSpecFluent() {
    }

    public KafkaMirrorMakerSpecFluent(KafkaMirrorMakerSpec instance) {
        KafkaMirrorMakerSpec kafkaMirrorMakerSpec = instance = instance != null ? instance : new KafkaMirrorMakerSpec();
        if (instance != null) {
            this.withReplicas(instance.getReplicas());
            this.withVersion(instance.getVersion());
            this.withImage(instance.getImage());
            this.withWhitelist(instance.getWhitelist());
            this.withInclude(instance.getInclude());
            this.withConsumer(instance.getConsumer());
            this.withProducer(instance.getProducer());
            this.withResources(instance.getResources());
            this.withLivenessProbe(instance.getLivenessProbe());
            this.withReadinessProbe(instance.getReadinessProbe());
            this.withJvmOptions(instance.getJvmOptions());
            this.withLogging(instance.getLogging());
            this.withMetricsConfig(instance.getMetricsConfig());
            this.withTracing(instance.getTracing());
            this.withTemplate(instance.getTemplate());
        }
    }

    public int getReplicas() {
        return this.replicas;
    }

    public A withReplicas(int replicas) {
        this.replicas = replicas;
        return (A)((Object)this);
    }

    public boolean hasReplicas() {
        return true;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public String getWhitelist() {
        return this.whitelist;
    }

    public A withWhitelist(String whitelist) {
        this.whitelist = whitelist;
        return (A)((Object)this);
    }

    public boolean hasWhitelist() {
        return this.whitelist != null;
    }

    public String getInclude() {
        return this.include;
    }

    public A withInclude(String include) {
        this.include = include;
        return (A)((Object)this);
    }

    public boolean hasInclude() {
        return this.include != null;
    }

    public KafkaMirrorMakerConsumerSpec buildConsumer() {
        return this.consumer != null ? this.consumer.build() : null;
    }

    public A withConsumer(KafkaMirrorMakerConsumerSpec consumer) {
        this._visitables.get((Object)"consumer").remove((Object)this.consumer);
        if (consumer != null) {
            this.consumer = new KafkaMirrorMakerConsumerSpecBuilder(consumer);
            this._visitables.get((Object)"consumer").add(this.consumer);
        } else {
            this.consumer = null;
            this._visitables.get((Object)"consumer").remove((Object)this.consumer);
        }
        return (A)((Object)this);
    }

    public boolean hasConsumer() {
        return this.consumer != null;
    }

    public ConsumerNested<A> withNewConsumer() {
        return new ConsumerNested(null);
    }

    public ConsumerNested<A> withNewConsumerLike(KafkaMirrorMakerConsumerSpec item) {
        return new ConsumerNested(item);
    }

    public ConsumerNested<A> editConsumer() {
        return this.withNewConsumerLike(Optional.ofNullable(this.buildConsumer()).orElse(null));
    }

    public ConsumerNested<A> editOrNewConsumer() {
        return this.withNewConsumerLike(Optional.ofNullable(this.buildConsumer()).orElse(new KafkaMirrorMakerConsumerSpecBuilder().build()));
    }

    public ConsumerNested<A> editOrNewConsumerLike(KafkaMirrorMakerConsumerSpec item) {
        return this.withNewConsumerLike(Optional.ofNullable(this.buildConsumer()).orElse(item));
    }

    public KafkaMirrorMakerProducerSpec buildProducer() {
        return this.producer != null ? this.producer.build() : null;
    }

    public A withProducer(KafkaMirrorMakerProducerSpec producer) {
        this._visitables.get((Object)"producer").remove((Object)this.producer);
        if (producer != null) {
            this.producer = new KafkaMirrorMakerProducerSpecBuilder(producer);
            this._visitables.get((Object)"producer").add(this.producer);
        } else {
            this.producer = null;
            this._visitables.get((Object)"producer").remove((Object)this.producer);
        }
        return (A)((Object)this);
    }

    public boolean hasProducer() {
        return this.producer != null;
    }

    public ProducerNested<A> withNewProducer() {
        return new ProducerNested(null);
    }

    public ProducerNested<A> withNewProducerLike(KafkaMirrorMakerProducerSpec item) {
        return new ProducerNested(item);
    }

    public ProducerNested<A> editProducer() {
        return this.withNewProducerLike(Optional.ofNullable(this.buildProducer()).orElse(null));
    }

    public ProducerNested<A> editOrNewProducer() {
        return this.withNewProducerLike(Optional.ofNullable(this.buildProducer()).orElse(new KafkaMirrorMakerProducerSpecBuilder().build()));
    }

    public ProducerNested<A> editOrNewProducerLike(KafkaMirrorMakerProducerSpec item) {
        return this.withNewProducerLike(Optional.ofNullable(this.buildProducer()).orElse(item));
    }

    public ResourceRequirements getResources() {
        return this.resources;
    }

    public A withResources(ResourceRequirements resources) {
        this.resources = resources;
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.get((Object)"livenessProbe").remove((Object)this.livenessProbe);
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.get((Object)"livenessProbe").add(this.livenessProbe);
        } else {
            this.livenessProbe = null;
            this._visitables.get((Object)"livenessProbe").remove((Object)this.livenessProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    public A withNewLivenessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNested(null);
    }

    public LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNested(item);
    }

    public LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(null));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(new ProbeBuilder().build()));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(item));
    }

    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.get((Object)"readinessProbe").remove((Object)this.readinessProbe);
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.get((Object)"readinessProbe").add(this.readinessProbe);
        } else {
            this.readinessProbe = null;
            this._visitables.get((Object)"readinessProbe").remove((Object)this.readinessProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    public A withNewReadinessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNested(null);
    }

    public ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNested(item);
    }

    public ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(null));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(new ProbeBuilder().build()));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(item));
    }

    public JvmOptions buildJvmOptions() {
        return this.jvmOptions != null ? this.jvmOptions.build() : null;
    }

    public A withJvmOptions(JvmOptions jvmOptions) {
        this._visitables.get((Object)"jvmOptions").remove((Object)this.jvmOptions);
        if (jvmOptions != null) {
            this.jvmOptions = new JvmOptionsBuilder(jvmOptions);
            this._visitables.get((Object)"jvmOptions").add(this.jvmOptions);
        } else {
            this.jvmOptions = null;
            this._visitables.get((Object)"jvmOptions").remove((Object)this.jvmOptions);
        }
        return (A)((Object)this);
    }

    public boolean hasJvmOptions() {
        return this.jvmOptions != null;
    }

    public JvmOptionsNested<A> withNewJvmOptions() {
        return new JvmOptionsNested(null);
    }

    public JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
        return new JvmOptionsNested(item);
    }

    public JvmOptionsNested<A> editJvmOptions() {
        return this.withNewJvmOptionsLike(Optional.ofNullable(this.buildJvmOptions()).orElse(null));
    }

    public JvmOptionsNested<A> editOrNewJvmOptions() {
        return this.withNewJvmOptionsLike(Optional.ofNullable(this.buildJvmOptions()).orElse(new JvmOptionsBuilder().build()));
    }

    public JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
        return this.withNewJvmOptionsLike(Optional.ofNullable(this.buildJvmOptions()).orElse(item));
    }

    public Logging buildLogging() {
        return this.logging != null ? (Logging)this.logging.build() : null;
    }

    public A withLogging(Logging logging) {
        if (logging == null) {
            this.logging = null;
            this._visitables.remove((Object)"logging");
            return (A)((Object)this);
        }
        VisitableBuilder builder = KafkaMirrorMakerSpecFluent.builder(logging);
        this._visitables.get((Object)"logging").clear();
        this._visitables.get((Object)"logging").add(builder);
        this.logging = builder;
        return (A)((Object)this);
    }

    public boolean hasLogging() {
        return this.logging != null;
    }

    public ExternalLoggingNested<A> withNewExternalLogging() {
        return new ExternalLoggingNested(null);
    }

    public ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item) {
        return new ExternalLoggingNested(item);
    }

    public InlineLoggingNested<A> withNewInlineLogging() {
        return new InlineLoggingNested(null);
    }

    public InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item) {
        return new InlineLoggingNested(item);
    }

    public MetricsConfig buildMetricsConfig() {
        return this.metricsConfig != null ? (MetricsConfig)this.metricsConfig.build() : null;
    }

    public A withMetricsConfig(MetricsConfig metricsConfig) {
        if (metricsConfig == null) {
            this.metricsConfig = null;
            this._visitables.remove((Object)"metricsConfig");
            return (A)((Object)this);
        }
        VisitableBuilder builder = KafkaMirrorMakerSpecFluent.builder(metricsConfig);
        this._visitables.get((Object)"metricsConfig").clear();
        this._visitables.get((Object)"metricsConfig").add(builder);
        this.metricsConfig = builder;
        return (A)((Object)this);
    }

    public boolean hasMetricsConfig() {
        return this.metricsConfig != null;
    }

    public JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfig() {
        return new JmxPrometheusExporterMetricsConfigNested(null);
    }

    public JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfigLike(JmxPrometheusExporterMetrics item) {
        return new JmxPrometheusExporterMetricsConfigNested(item);
    }

    public Tracing buildTracing() {
        return this.tracing != null ? (Tracing)this.tracing.build() : null;
    }

    public A withTracing(Tracing tracing) {
        if (tracing == null) {
            this.tracing = null;
            this._visitables.remove((Object)"tracing");
            return (A)((Object)this);
        }
        VisitableBuilder builder = KafkaMirrorMakerSpecFluent.builder(tracing);
        this._visitables.get((Object)"tracing").clear();
        this._visitables.get((Object)"tracing").add(builder);
        this.tracing = builder;
        return (A)((Object)this);
    }

    public boolean hasTracing() {
        return this.tracing != null;
    }

    public JaegerTracingNested<A> withNewJaegerTracing() {
        return new JaegerTracingNested(null);
    }

    public JaegerTracingNested<A> withNewJaegerTracingLike(JaegerTracing item) {
        return new JaegerTracingNested(item);
    }

    public OpenTelemetryTracingNested<A> withNewOpenTelemetryTracing() {
        return new OpenTelemetryTracingNested(null);
    }

    public OpenTelemetryTracingNested<A> withNewOpenTelemetryTracingLike(OpenTelemetryTracing item) {
        return new OpenTelemetryTracingNested(item);
    }

    public KafkaMirrorMakerTemplate buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public A withTemplate(KafkaMirrorMakerTemplate template) {
        this._visitables.get((Object)"template").remove((Object)this.template);
        if (template != null) {
            this.template = new KafkaMirrorMakerTemplateBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove((Object)this.template);
        }
        return (A)((Object)this);
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(KafkaMirrorMakerTemplate item) {
        return new TemplateNested(item);
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new KafkaMirrorMakerTemplateBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(KafkaMirrorMakerTemplate item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaMirrorMakerSpecFluent that = (KafkaMirrorMakerSpecFluent)((Object)o);
        if (this.replicas != that.replicas) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.whitelist, that.whitelist)) {
            return false;
        }
        if (!Objects.equals(this.include, that.include)) {
            return false;
        }
        if (!Objects.equals((Object)this.consumer, (Object)that.consumer)) {
            return false;
        }
        if (!Objects.equals((Object)this.producer, (Object)that.producer)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals((Object)this.livenessProbe, (Object)that.livenessProbe)) {
            return false;
        }
        if (!Objects.equals((Object)this.readinessProbe, (Object)that.readinessProbe)) {
            return false;
        }
        if (!Objects.equals((Object)this.jvmOptions, (Object)that.jvmOptions)) {
            return false;
        }
        if (!Objects.equals(this.logging, that.logging)) {
            return false;
        }
        if (!Objects.equals(this.metricsConfig, that.metricsConfig)) {
            return false;
        }
        if (!Objects.equals(this.tracing, that.tracing)) {
            return false;
        }
        return Objects.equals((Object)this.template, (Object)that.template);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.replicas, this.version, this.image, this.whitelist, this.include, this.consumer, this.producer, this.resources, this.livenessProbe, this.readinessProbe, this.jvmOptions, this.logging, this.metricsConfig, this.tracing, this.template, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("replicas:");
        sb.append(this.replicas + ",");
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.whitelist != null) {
            sb.append("whitelist:");
            sb.append(this.whitelist + ",");
        }
        if (this.include != null) {
            sb.append("include:");
            sb.append(this.include + ",");
        }
        if (this.consumer != null) {
            sb.append("consumer:");
            sb.append(this.consumer + ",");
        }
        if (this.producer != null) {
            sb.append("producer:");
            sb.append(this.producer + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.livenessProbe != null) {
            sb.append("livenessProbe:");
            sb.append(this.livenessProbe + ",");
        }
        if (this.readinessProbe != null) {
            sb.append("readinessProbe:");
            sb.append(this.readinessProbe + ",");
        }
        if (this.jvmOptions != null) {
            sb.append("jvmOptions:");
            sb.append(this.jvmOptions + ",");
        }
        if (this.logging != null) {
            sb.append("logging:");
            sb.append(this.logging + ",");
        }
        if (this.metricsConfig != null) {
            sb.append("metricsConfig:");
            sb.append(this.metricsConfig + ",");
        }
        if (this.tracing != null) {
            sb.append("tracing:");
            sb.append(this.tracing + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append((Object)this.template);
        }
        sb.append("}");
        return sb.toString();
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "io.strimzi.api.kafka.model.ExternalLogging": {
                return new ExternalLoggingBuilder((ExternalLogging)item);
            }
            case "io.strimzi.api.kafka.model.InlineLogging": {
                return new InlineLoggingBuilder((InlineLogging)item);
            }
            case "io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics": {
                return new JmxPrometheusExporterMetricsBuilder((JmxPrometheusExporterMetrics)item);
            }
            case "io.strimzi.api.kafka.model.tracing.JaegerTracing": {
                return new JaegerTracingBuilder((JaegerTracing)item);
            }
            case "io.strimzi.api.kafka.model.tracing.OpenTelemetryTracing": {
                return new OpenTelemetryTracingBuilder((OpenTelemetryTracing)item);
            }
        }
        return KafkaMirrorMakerSpecFluent.builderOf((Object)item);
    }

    public class ConsumerNested<N>
    extends KafkaMirrorMakerConsumerSpecFluent<ConsumerNested<N>>
    implements Nested<N> {
        KafkaMirrorMakerConsumerSpecBuilder builder;

        ConsumerNested(KafkaMirrorMakerConsumerSpec item) {
            this.builder = new KafkaMirrorMakerConsumerSpecBuilder(this, item);
        }

        public N and() {
            return (N)KafkaMirrorMakerSpecFluent.this.withConsumer(this.builder.build());
        }

        public N endConsumer() {
            return this.and();
        }
    }

    public class ProducerNested<N>
    extends KafkaMirrorMakerProducerSpecFluent<ProducerNested<N>>
    implements Nested<N> {
        KafkaMirrorMakerProducerSpecBuilder builder;

        ProducerNested(KafkaMirrorMakerProducerSpec item) {
            this.builder = new KafkaMirrorMakerProducerSpecBuilder(this, item);
        }

        public N and() {
            return (N)KafkaMirrorMakerSpecFluent.this.withProducer(this.builder.build());
        }

        public N endProducer() {
            return this.and();
        }
    }

    public class LivenessProbeNested<N>
    extends ProbeFluent<LivenessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        LivenessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)KafkaMirrorMakerSpecFluent.this.withLivenessProbe(this.builder.build());
        }

        public N endLivenessProbe() {
            return this.and();
        }
    }

    public class ReadinessProbeNested<N>
    extends ProbeFluent<ReadinessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        ReadinessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)KafkaMirrorMakerSpecFluent.this.withReadinessProbe(this.builder.build());
        }

        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class JvmOptionsNested<N>
    extends JvmOptionsFluent<JvmOptionsNested<N>>
    implements Nested<N> {
        JvmOptionsBuilder builder;

        JvmOptionsNested(JvmOptions item) {
            this.builder = new JvmOptionsBuilder(this, item);
        }

        public N and() {
            return (N)KafkaMirrorMakerSpecFluent.this.withJvmOptions(this.builder.build());
        }

        public N endJvmOptions() {
            return this.and();
        }
    }

    public class ExternalLoggingNested<N>
    extends ExternalLoggingFluent<ExternalLoggingNested<N>>
    implements Nested<N> {
        ExternalLoggingBuilder builder;

        ExternalLoggingNested(ExternalLogging item) {
            this.builder = new ExternalLoggingBuilder(this, item);
        }

        public N and() {
            return (N)KafkaMirrorMakerSpecFluent.this.withLogging(this.builder.build());
        }

        public N endExternalLogging() {
            return this.and();
        }
    }

    public class InlineLoggingNested<N>
    extends InlineLoggingFluent<InlineLoggingNested<N>>
    implements Nested<N> {
        InlineLoggingBuilder builder;

        InlineLoggingNested(InlineLogging item) {
            this.builder = new InlineLoggingBuilder(this, item);
        }

        public N and() {
            return (N)KafkaMirrorMakerSpecFluent.this.withLogging(this.builder.build());
        }

        public N endInlineLogging() {
            return this.and();
        }
    }

    public class JmxPrometheusExporterMetricsConfigNested<N>
    extends JmxPrometheusExporterMetricsFluent<JmxPrometheusExporterMetricsConfigNested<N>>
    implements Nested<N> {
        JmxPrometheusExporterMetricsBuilder builder;

        JmxPrometheusExporterMetricsConfigNested(JmxPrometheusExporterMetrics item) {
            this.builder = new JmxPrometheusExporterMetricsBuilder(this, item);
        }

        public N and() {
            return (N)KafkaMirrorMakerSpecFluent.this.withMetricsConfig(this.builder.build());
        }

        public N endJmxPrometheusExporterMetricsConfig() {
            return this.and();
        }
    }

    public class JaegerTracingNested<N>
    extends JaegerTracingFluent<JaegerTracingNested<N>>
    implements Nested<N> {
        JaegerTracingBuilder builder;

        JaegerTracingNested(JaegerTracing item) {
            this.builder = new JaegerTracingBuilder(this, item);
        }

        public N and() {
            return (N)KafkaMirrorMakerSpecFluent.this.withTracing(this.builder.build());
        }

        public N endJaegerTracing() {
            return this.and();
        }
    }

    public class OpenTelemetryTracingNested<N>
    extends OpenTelemetryTracingFluent<OpenTelemetryTracingNested<N>>
    implements Nested<N> {
        OpenTelemetryTracingBuilder builder;

        OpenTelemetryTracingNested(OpenTelemetryTracing item) {
            this.builder = new OpenTelemetryTracingBuilder(this, item);
        }

        public N and() {
            return (N)KafkaMirrorMakerSpecFluent.this.withTracing(this.builder.build());
        }

        public N endOpenTelemetryTracing() {
            return this.and();
        }
    }

    public class TemplateNested<N>
    extends KafkaMirrorMakerTemplateFluent<TemplateNested<N>>
    implements Nested<N> {
        KafkaMirrorMakerTemplateBuilder builder;

        TemplateNested(KafkaMirrorMakerTemplate item) {
            this.builder = new KafkaMirrorMakerTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaMirrorMakerSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }
}

