/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.KafkaSpec;
import io.strimzi.api.kafka.model.KafkaSpecFluent;

public class KafkaSpecBuilder
extends KafkaSpecFluent<KafkaSpecBuilder>
implements VisitableBuilder<KafkaSpec, KafkaSpecBuilder> {
    KafkaSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaSpecBuilder() {
        this(false);
    }

    public KafkaSpecBuilder(Boolean validationEnabled) {
        this(new KafkaSpec(), validationEnabled);
    }

    public KafkaSpecBuilder(KafkaSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public KafkaSpecBuilder(KafkaSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KafkaSpec(), validationEnabled);
    }

    public KafkaSpecBuilder(KafkaSpecFluent<?> fluent, KafkaSpec instance) {
        this(fluent, instance, false);
    }

    public KafkaSpecBuilder(KafkaSpecFluent<?> fluent, KafkaSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        KafkaSpec kafkaSpec = instance = instance != null ? instance : new KafkaSpec();
        if (instance != null) {
            fluent.withKafka(instance.getKafka());
            fluent.withZookeeper(instance.getZookeeper());
            fluent.withEntityOperator(instance.getEntityOperator());
            fluent.withClusterCa(instance.getClusterCa());
            fluent.withJmxTrans(instance.getJmxTrans());
            fluent.withKafkaExporter(instance.getKafkaExporter());
            fluent.withCruiseControl(instance.getCruiseControl());
            fluent.withClientsCa(instance.getClientsCa());
            fluent.withMaintenanceTimeWindows(instance.getMaintenanceTimeWindows());
        }
        this.validationEnabled = validationEnabled;
    }

    public KafkaSpecBuilder(KafkaSpec instance) {
        this(instance, (Boolean)false);
    }

    public KafkaSpecBuilder(KafkaSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        KafkaSpec kafkaSpec = instance = instance != null ? instance : new KafkaSpec();
        if (instance != null) {
            this.withKafka(instance.getKafka());
            this.withZookeeper(instance.getZookeeper());
            this.withEntityOperator(instance.getEntityOperator());
            this.withClusterCa(instance.getClusterCa());
            this.withJmxTrans(instance.getJmxTrans());
            this.withKafkaExporter(instance.getKafkaExporter());
            this.withCruiseControl(instance.getCruiseControl());
            this.withClientsCa(instance.getClientsCa());
            this.withMaintenanceTimeWindows(instance.getMaintenanceTimeWindows());
        }
        this.validationEnabled = validationEnabled;
    }

    public KafkaSpec build() {
        KafkaSpec buildable = new KafkaSpec();
        buildable.setKafka(this.fluent.buildKafka());
        buildable.setZookeeper(this.fluent.buildZookeeper());
        buildable.setEntityOperator(this.fluent.buildEntityOperator());
        buildable.setClusterCa(this.fluent.buildClusterCa());
        buildable.setJmxTrans(this.fluent.buildJmxTrans());
        buildable.setKafkaExporter(this.fluent.buildKafkaExporter());
        buildable.setCruiseControl(this.fluent.buildCruiseControl());
        buildable.setClientsCa(this.fluent.buildClientsCa());
        buildable.setMaintenanceTimeWindows(this.fluent.getMaintenanceTimeWindows());
        return buildable;
    }
}

