/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.KafkaUserAuthentication;
import io.strimzi.api.kafka.model.KafkaUserAuthorization;
import io.strimzi.api.kafka.model.KafkaUserAuthorizationSimple;
import io.strimzi.api.kafka.model.KafkaUserAuthorizationSimpleBuilder;
import io.strimzi.api.kafka.model.KafkaUserAuthorizationSimpleFluent;
import io.strimzi.api.kafka.model.KafkaUserQuotas;
import io.strimzi.api.kafka.model.KafkaUserQuotasBuilder;
import io.strimzi.api.kafka.model.KafkaUserQuotasFluent;
import io.strimzi.api.kafka.model.KafkaUserScramSha512ClientAuthentication;
import io.strimzi.api.kafka.model.KafkaUserScramSha512ClientAuthenticationBuilder;
import io.strimzi.api.kafka.model.KafkaUserScramSha512ClientAuthenticationFluent;
import io.strimzi.api.kafka.model.KafkaUserSpec;
import io.strimzi.api.kafka.model.KafkaUserTlsClientAuthentication;
import io.strimzi.api.kafka.model.KafkaUserTlsClientAuthenticationBuilder;
import io.strimzi.api.kafka.model.KafkaUserTlsClientAuthenticationFluent;
import io.strimzi.api.kafka.model.KafkaUserTlsExternalClientAuthentication;
import io.strimzi.api.kafka.model.KafkaUserTlsExternalClientAuthenticationBuilder;
import io.strimzi.api.kafka.model.KafkaUserTlsExternalClientAuthenticationFluent;
import io.strimzi.api.kafka.model.SpecFluent;
import io.strimzi.api.kafka.model.template.KafkaUserTemplate;
import io.strimzi.api.kafka.model.template.KafkaUserTemplateBuilder;
import io.strimzi.api.kafka.model.template.KafkaUserTemplateFluent;
import java.util.Objects;
import java.util.Optional;

public class KafkaUserSpecFluent<A extends KafkaUserSpecFluent<A>>
extends SpecFluent<A> {
    private VisitableBuilder<? extends KafkaUserAuthentication, ?> authentication;
    private VisitableBuilder<? extends KafkaUserAuthorization, ?> authorization;
    private KafkaUserQuotasBuilder quotas;
    private KafkaUserTemplateBuilder template;

    public KafkaUserSpecFluent() {
    }

    public KafkaUserSpecFluent(KafkaUserSpec instance) {
        KafkaUserSpec kafkaUserSpec = instance = instance != null ? instance : new KafkaUserSpec();
        if (instance != null) {
            this.withAuthentication(instance.getAuthentication());
            this.withAuthorization(instance.getAuthorization());
            this.withQuotas(instance.getQuotas());
            this.withTemplate(instance.getTemplate());
        }
    }

    public KafkaUserAuthentication buildAuthentication() {
        return this.authentication != null ? (KafkaUserAuthentication)this.authentication.build() : null;
    }

    public A withAuthentication(KafkaUserAuthentication authentication) {
        if (authentication == null) {
            this.authentication = null;
            this._visitables.remove((Object)"authentication");
            return (A)((Object)this);
        }
        VisitableBuilder builder = KafkaUserSpecFluent.builder(authentication);
        this._visitables.get((Object)"authentication").clear();
        this._visitables.get((Object)"authentication").add(builder);
        this.authentication = builder;
        return (A)((Object)this);
    }

    public boolean hasAuthentication() {
        return this.authentication != null;
    }

    public KafkaUserTlsClientAuthenticationNested<A> withNewKafkaUserTlsClientAuthentication() {
        return new KafkaUserTlsClientAuthenticationNested(null);
    }

    public KafkaUserTlsClientAuthenticationNested<A> withNewKafkaUserTlsClientAuthenticationLike(KafkaUserTlsClientAuthentication item) {
        return new KafkaUserTlsClientAuthenticationNested(item);
    }

    public KafkaUserTlsExternalClientAuthenticationNested<A> withNewKafkaUserTlsExternalClientAuthentication() {
        return new KafkaUserTlsExternalClientAuthenticationNested(null);
    }

    public KafkaUserTlsExternalClientAuthenticationNested<A> withNewKafkaUserTlsExternalClientAuthenticationLike(KafkaUserTlsExternalClientAuthentication item) {
        return new KafkaUserTlsExternalClientAuthenticationNested(item);
    }

    public KafkaUserScramSha512ClientAuthenticationNested<A> withNewKafkaUserScramSha512ClientAuthentication() {
        return new KafkaUserScramSha512ClientAuthenticationNested(null);
    }

    public KafkaUserScramSha512ClientAuthenticationNested<A> withNewKafkaUserScramSha512ClientAuthenticationLike(KafkaUserScramSha512ClientAuthentication item) {
        return new KafkaUserScramSha512ClientAuthenticationNested(item);
    }

    public KafkaUserAuthorization buildAuthorization() {
        return this.authorization != null ? (KafkaUserAuthorization)this.authorization.build() : null;
    }

    public A withAuthorization(KafkaUserAuthorization authorization) {
        if (authorization == null) {
            this.authorization = null;
            this._visitables.remove((Object)"authorization");
            return (A)((Object)this);
        }
        VisitableBuilder builder = KafkaUserSpecFluent.builder(authorization);
        this._visitables.get((Object)"authorization").clear();
        this._visitables.get((Object)"authorization").add(builder);
        this.authorization = builder;
        return (A)((Object)this);
    }

    public boolean hasAuthorization() {
        return this.authorization != null;
    }

    public KafkaUserAuthorizationSimpleNested<A> withNewKafkaUserAuthorizationSimple() {
        return new KafkaUserAuthorizationSimpleNested(null);
    }

    public KafkaUserAuthorizationSimpleNested<A> withNewKafkaUserAuthorizationSimpleLike(KafkaUserAuthorizationSimple item) {
        return new KafkaUserAuthorizationSimpleNested(item);
    }

    public KafkaUserQuotas buildQuotas() {
        return this.quotas != null ? this.quotas.build() : null;
    }

    public A withQuotas(KafkaUserQuotas quotas) {
        this._visitables.get((Object)"quotas").remove((Object)this.quotas);
        if (quotas != null) {
            this.quotas = new KafkaUserQuotasBuilder(quotas);
            this._visitables.get((Object)"quotas").add(this.quotas);
        } else {
            this.quotas = null;
            this._visitables.get((Object)"quotas").remove((Object)this.quotas);
        }
        return (A)((Object)this);
    }

    public boolean hasQuotas() {
        return this.quotas != null;
    }

    public QuotasNested<A> withNewQuotas() {
        return new QuotasNested(null);
    }

    public QuotasNested<A> withNewQuotasLike(KafkaUserQuotas item) {
        return new QuotasNested(item);
    }

    public QuotasNested<A> editQuotas() {
        return this.withNewQuotasLike(Optional.ofNullable(this.buildQuotas()).orElse(null));
    }

    public QuotasNested<A> editOrNewQuotas() {
        return this.withNewQuotasLike(Optional.ofNullable(this.buildQuotas()).orElse(new KafkaUserQuotasBuilder().build()));
    }

    public QuotasNested<A> editOrNewQuotasLike(KafkaUserQuotas item) {
        return this.withNewQuotasLike(Optional.ofNullable(this.buildQuotas()).orElse(item));
    }

    public KafkaUserTemplate buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public A withTemplate(KafkaUserTemplate template) {
        this._visitables.get((Object)"template").remove((Object)this.template);
        if (template != null) {
            this.template = new KafkaUserTemplateBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove((Object)this.template);
        }
        return (A)((Object)this);
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(KafkaUserTemplate item) {
        return new TemplateNested(item);
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new KafkaUserTemplateBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(KafkaUserTemplate item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaUserSpecFluent that = (KafkaUserSpecFluent)((Object)o);
        if (!Objects.equals(this.authentication, that.authentication)) {
            return false;
        }
        if (!Objects.equals(this.authorization, that.authorization)) {
            return false;
        }
        if (!Objects.equals((Object)this.quotas, (Object)that.quotas)) {
            return false;
        }
        return Objects.equals((Object)this.template, (Object)that.template);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.authentication, this.authorization, this.quotas, this.template, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authentication != null) {
            sb.append("authentication:");
            sb.append(this.authentication + ",");
        }
        if (this.authorization != null) {
            sb.append("authorization:");
            sb.append(this.authorization + ",");
        }
        if (this.quotas != null) {
            sb.append("quotas:");
            sb.append(this.quotas + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append((Object)this.template);
        }
        sb.append("}");
        return sb.toString();
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "io.strimzi.api.kafka.model.KafkaUserTlsClientAuthentication": {
                return new KafkaUserTlsClientAuthenticationBuilder((KafkaUserTlsClientAuthentication)item);
            }
            case "io.strimzi.api.kafka.model.KafkaUserTlsExternalClientAuthentication": {
                return new KafkaUserTlsExternalClientAuthenticationBuilder((KafkaUserTlsExternalClientAuthentication)item);
            }
            case "io.strimzi.api.kafka.model.KafkaUserScramSha512ClientAuthentication": {
                return new KafkaUserScramSha512ClientAuthenticationBuilder((KafkaUserScramSha512ClientAuthentication)item);
            }
            case "io.strimzi.api.kafka.model.KafkaUserAuthorizationSimple": {
                return new KafkaUserAuthorizationSimpleBuilder((KafkaUserAuthorizationSimple)item);
            }
        }
        return KafkaUserSpecFluent.builderOf((Object)item);
    }

    public class KafkaUserTlsClientAuthenticationNested<N>
    extends KafkaUserTlsClientAuthenticationFluent<KafkaUserTlsClientAuthenticationNested<N>>
    implements Nested<N> {
        KafkaUserTlsClientAuthenticationBuilder builder;

        KafkaUserTlsClientAuthenticationNested(KafkaUserTlsClientAuthentication item) {
            this.builder = new KafkaUserTlsClientAuthenticationBuilder(this, item);
        }

        public N and() {
            return (N)KafkaUserSpecFluent.this.withAuthentication(this.builder.build());
        }

        public N endKafkaUserTlsClientAuthentication() {
            return this.and();
        }
    }

    public class KafkaUserTlsExternalClientAuthenticationNested<N>
    extends KafkaUserTlsExternalClientAuthenticationFluent<KafkaUserTlsExternalClientAuthenticationNested<N>>
    implements Nested<N> {
        KafkaUserTlsExternalClientAuthenticationBuilder builder;

        KafkaUserTlsExternalClientAuthenticationNested(KafkaUserTlsExternalClientAuthentication item) {
            this.builder = new KafkaUserTlsExternalClientAuthenticationBuilder(this, item);
        }

        public N and() {
            return (N)KafkaUserSpecFluent.this.withAuthentication(this.builder.build());
        }

        public N endKafkaUserTlsExternalClientAuthentication() {
            return this.and();
        }
    }

    public class KafkaUserScramSha512ClientAuthenticationNested<N>
    extends KafkaUserScramSha512ClientAuthenticationFluent<KafkaUserScramSha512ClientAuthenticationNested<N>>
    implements Nested<N> {
        KafkaUserScramSha512ClientAuthenticationBuilder builder;

        KafkaUserScramSha512ClientAuthenticationNested(KafkaUserScramSha512ClientAuthentication item) {
            this.builder = new KafkaUserScramSha512ClientAuthenticationBuilder(this, item);
        }

        public N and() {
            return (N)KafkaUserSpecFluent.this.withAuthentication(this.builder.build());
        }

        public N endKafkaUserScramSha512ClientAuthentication() {
            return this.and();
        }
    }

    public class KafkaUserAuthorizationSimpleNested<N>
    extends KafkaUserAuthorizationSimpleFluent<KafkaUserAuthorizationSimpleNested<N>>
    implements Nested<N> {
        KafkaUserAuthorizationSimpleBuilder builder;

        KafkaUserAuthorizationSimpleNested(KafkaUserAuthorizationSimple item) {
            this.builder = new KafkaUserAuthorizationSimpleBuilder(this, item);
        }

        public N and() {
            return (N)KafkaUserSpecFluent.this.withAuthorization(this.builder.build());
        }

        public N endKafkaUserAuthorizationSimple() {
            return this.and();
        }
    }

    public class QuotasNested<N>
    extends KafkaUserQuotasFluent<QuotasNested<N>>
    implements Nested<N> {
        KafkaUserQuotasBuilder builder;

        QuotasNested(KafkaUserQuotas item) {
            this.builder = new KafkaUserQuotasBuilder(this, item);
        }

        public N and() {
            return (N)KafkaUserSpecFluent.this.withQuotas(this.builder.build());
        }

        public N endQuotas() {
            return this.and();
        }
    }

    public class TemplateNested<N>
    extends KafkaUserTemplateFluent<TemplateNested<N>>
    implements Nested<N> {
        KafkaUserTemplateBuilder builder;

        TemplateNested(KafkaUserTemplate item) {
            this.builder = new KafkaUserTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaUserSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }
}

