/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.authentication;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.PasswordSecretSource;
import io.strimzi.api.kafka.model.PasswordSecretSourceBuilder;
import io.strimzi.api.kafka.model.PasswordSecretSourceFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512;
import java.util.Objects;
import java.util.Optional;

public class KafkaClientAuthenticationScramSha512Fluent<A extends KafkaClientAuthenticationScramSha512Fluent<A>>
extends BaseFluent<A> {
    private String username;
    private PasswordSecretSourceBuilder passwordSecret;

    public KafkaClientAuthenticationScramSha512Fluent() {
    }

    public KafkaClientAuthenticationScramSha512Fluent(KafkaClientAuthenticationScramSha512 instance) {
        KafkaClientAuthenticationScramSha512 kafkaClientAuthenticationScramSha512 = instance = instance != null ? instance : new KafkaClientAuthenticationScramSha512();
        if (instance != null) {
            this.withUsername(instance.getUsername());
            this.withPasswordSecret(instance.getPasswordSecret());
        }
    }

    public String getUsername() {
        return this.username;
    }

    public A withUsername(String username) {
        this.username = username;
        return (A)((Object)this);
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    public PasswordSecretSource buildPasswordSecret() {
        return this.passwordSecret != null ? this.passwordSecret.build() : null;
    }

    public A withPasswordSecret(PasswordSecretSource passwordSecret) {
        this._visitables.get((Object)"passwordSecret").remove((Object)this.passwordSecret);
        if (passwordSecret != null) {
            this.passwordSecret = new PasswordSecretSourceBuilder(passwordSecret);
            this._visitables.get((Object)"passwordSecret").add(this.passwordSecret);
        } else {
            this.passwordSecret = null;
            this._visitables.get((Object)"passwordSecret").remove((Object)this.passwordSecret);
        }
        return (A)((Object)this);
    }

    public boolean hasPasswordSecret() {
        return this.passwordSecret != null;
    }

    public PasswordSecretNested<A> withNewPasswordSecret() {
        return new PasswordSecretNested(null);
    }

    public PasswordSecretNested<A> withNewPasswordSecretLike(PasswordSecretSource item) {
        return new PasswordSecretNested(item);
    }

    public PasswordSecretNested<A> editPasswordSecret() {
        return this.withNewPasswordSecretLike(Optional.ofNullable(this.buildPasswordSecret()).orElse(null));
    }

    public PasswordSecretNested<A> editOrNewPasswordSecret() {
        return this.withNewPasswordSecretLike(Optional.ofNullable(this.buildPasswordSecret()).orElse(new PasswordSecretSourceBuilder().build()));
    }

    public PasswordSecretNested<A> editOrNewPasswordSecretLike(PasswordSecretSource item) {
        return this.withNewPasswordSecretLike(Optional.ofNullable(this.buildPasswordSecret()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaClientAuthenticationScramSha512Fluent that = (KafkaClientAuthenticationScramSha512Fluent)((Object)o);
        if (!Objects.equals(this.username, that.username)) {
            return false;
        }
        return Objects.equals((Object)this.passwordSecret, (Object)that.passwordSecret);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.username, this.passwordSecret, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.username != null) {
            sb.append("username:");
            sb.append(this.username + ",");
        }
        if (this.passwordSecret != null) {
            sb.append("passwordSecret:");
            sb.append((Object)this.passwordSecret);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PasswordSecretNested<N>
    extends PasswordSecretSourceFluent<PasswordSecretNested<N>>
    implements Nested<N> {
        PasswordSecretSourceBuilder builder;

        PasswordSecretNested(PasswordSecretSource item) {
            this.builder = new PasswordSecretSourceBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClientAuthenticationScramSha512Fluent.this.withPasswordSecret(this.builder.build());
        }

        public N endPasswordSecret() {
            return this.and();
        }
    }
}

