/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.GenericSecretSource;
import io.strimzi.api.kafka.model.GenericSecretSourceBuilder;
import io.strimzi.api.kafka.model.GenericSecretSourceFluent;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustom;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaListenerAuthenticationCustomFluent<A extends KafkaListenerAuthenticationCustomFluent<A>>
extends KafkaListenerAuthenticationFluent<A> {
    private Map<String, Object> listenerConfig;
    private boolean sasl;
    private ArrayList<GenericSecretSourceBuilder> secrets;

    public KafkaListenerAuthenticationCustomFluent() {
    }

    public KafkaListenerAuthenticationCustomFluent(KafkaListenerAuthenticationCustom instance) {
        KafkaListenerAuthenticationCustom kafkaListenerAuthenticationCustom = instance = instance != null ? instance : new KafkaListenerAuthenticationCustom();
        if (instance != null) {
            this.withListenerConfig(instance.getListenerConfig());
            this.withSasl(instance.isSasl());
            this.withSecrets(instance.getSecrets());
        }
    }

    public A addToListenerConfig(String key, Object value) {
        if (this.listenerConfig == null && key != null && value != null) {
            this.listenerConfig = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.listenerConfig.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToListenerConfig(Map<String, Object> map) {
        if (this.listenerConfig == null && map != null) {
            this.listenerConfig = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.listenerConfig.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromListenerConfig(String key) {
        if (this.listenerConfig == null) {
            return (A)((Object)this);
        }
        if (key != null && this.listenerConfig != null) {
            this.listenerConfig.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromListenerConfig(Map<String, Object> map) {
        if (this.listenerConfig == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.listenerConfig == null) continue;
                this.listenerConfig.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getListenerConfig() {
        return this.listenerConfig;
    }

    public <K, V> A withListenerConfig(Map<String, Object> listenerConfig) {
        this.listenerConfig = listenerConfig == null ? null : new LinkedHashMap<String, Object>(listenerConfig);
        return (A)((Object)this);
    }

    public boolean hasListenerConfig() {
        return this.listenerConfig != null;
    }

    public boolean isSasl() {
        return this.sasl;
    }

    public A withSasl(boolean sasl) {
        this.sasl = sasl;
        return (A)((Object)this);
    }

    public boolean hasSasl() {
        return true;
    }

    public A addToSecrets(int index, GenericSecretSource item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        GenericSecretSourceBuilder builder = new GenericSecretSourceBuilder(item);
        if (index < 0 || index >= this.secrets.size()) {
            this._visitables.get((Object)"secrets").add(builder);
            this.secrets.add(builder);
        } else {
            this._visitables.get((Object)"secrets").add(index, builder);
            this.secrets.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSecrets(int index, GenericSecretSource item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        GenericSecretSourceBuilder builder = new GenericSecretSourceBuilder(item);
        if (index < 0 || index >= this.secrets.size()) {
            this._visitables.get((Object)"secrets").add(builder);
            this.secrets.add(builder);
        } else {
            this._visitables.get((Object)"secrets").set(index, builder);
            this.secrets.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSecrets(GenericSecretSource ... items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        for (GenericSecretSource item : items) {
            GenericSecretSourceBuilder builder = new GenericSecretSourceBuilder(item);
            this._visitables.get((Object)"secrets").add(builder);
            this.secrets.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSecrets(Collection<GenericSecretSource> items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        for (GenericSecretSource item : items) {
            GenericSecretSourceBuilder builder = new GenericSecretSourceBuilder(item);
            this._visitables.get((Object)"secrets").add(builder);
            this.secrets.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSecrets(GenericSecretSource ... items) {
        if (this.secrets == null) {
            return (A)((Object)this);
        }
        for (GenericSecretSource item : items) {
            GenericSecretSourceBuilder builder = new GenericSecretSourceBuilder(item);
            this._visitables.get((Object)"secrets").remove((Object)builder);
            this.secrets.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSecrets(Collection<GenericSecretSource> items) {
        if (this.secrets == null) {
            return (A)((Object)this);
        }
        for (GenericSecretSource item : items) {
            GenericSecretSourceBuilder builder = new GenericSecretSourceBuilder(item);
            this._visitables.get((Object)"secrets").remove((Object)builder);
            this.secrets.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSecrets(Predicate<GenericSecretSourceBuilder> predicate) {
        if (this.secrets == null) {
            return (A)((Object)this);
        }
        Iterator<GenericSecretSourceBuilder> each = this.secrets.iterator();
        List visitables = this._visitables.get((Object)"secrets");
        while (each.hasNext()) {
            GenericSecretSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<GenericSecretSource> buildSecrets() {
        return this.secrets != null ? KafkaListenerAuthenticationCustomFluent.build(this.secrets) : null;
    }

    public GenericSecretSource buildSecret(int index) {
        return this.secrets.get(index).build();
    }

    public GenericSecretSource buildFirstSecret() {
        return this.secrets.get(0).build();
    }

    public GenericSecretSource buildLastSecret() {
        return this.secrets.get(this.secrets.size() - 1).build();
    }

    public GenericSecretSource buildMatchingSecret(Predicate<GenericSecretSourceBuilder> predicate) {
        for (GenericSecretSourceBuilder item : this.secrets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSecret(Predicate<GenericSecretSourceBuilder> predicate) {
        for (GenericSecretSourceBuilder item : this.secrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSecrets(List<GenericSecretSource> secrets) {
        if (this.secrets != null) {
            this._visitables.get((Object)"secrets").clear();
        }
        if (secrets != null) {
            this.secrets = new ArrayList();
            for (GenericSecretSource item : secrets) {
                this.addToSecrets(item);
            }
        } else {
            this.secrets = null;
        }
        return (A)((Object)this);
    }

    public A withSecrets(GenericSecretSource ... secrets) {
        if (this.secrets != null) {
            this.secrets.clear();
            this._visitables.remove((Object)"secrets");
        }
        if (secrets != null) {
            for (GenericSecretSource item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSecrets() {
        return this.secrets != null && !this.secrets.isEmpty();
    }

    public SecretsNested<A> addNewSecret() {
        return new SecretsNested(-1, null);
    }

    public SecretsNested<A> addNewSecretLike(GenericSecretSource item) {
        return new SecretsNested(-1, item);
    }

    public SecretsNested<A> setNewSecretLike(int index, GenericSecretSource item) {
        return new SecretsNested(index, item);
    }

    public SecretsNested<A> editSecret(int index) {
        if (this.secrets.size() <= index) {
            throw new RuntimeException("Can't edit secrets. Index exceeds size.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    public SecretsNested<A> editFirstSecret() {
        if (this.secrets.size() == 0) {
            throw new RuntimeException("Can't edit first secrets. The list is empty.");
        }
        return this.setNewSecretLike(0, this.buildSecret(0));
    }

    public SecretsNested<A> editLastSecret() {
        int index = this.secrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last secrets. The list is empty.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    public SecretsNested<A> editMatchingSecret(Predicate<GenericSecretSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.secrets.size(); ++i) {
            if (!predicate.test(this.secrets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching secrets. No match found.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaListenerAuthenticationCustomFluent that = (KafkaListenerAuthenticationCustomFluent)((Object)o);
        if (!Objects.equals(this.listenerConfig, that.listenerConfig)) {
            return false;
        }
        if (this.sasl != that.sasl) {
            return false;
        }
        return Objects.equals(this.secrets, that.secrets);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.listenerConfig, this.sasl, this.secrets, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.listenerConfig != null && !this.listenerConfig.isEmpty()) {
            sb.append("listenerConfig:");
            sb.append(this.listenerConfig + ",");
        }
        sb.append("sasl:");
        sb.append(this.sasl + ",");
        if (this.secrets != null && !this.secrets.isEmpty()) {
            sb.append("secrets:");
            sb.append(this.secrets);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withSasl() {
        return this.withSasl(true);
    }

    public class SecretsNested<N>
    extends GenericSecretSourceFluent<SecretsNested<N>>
    implements Nested<N> {
        GenericSecretSourceBuilder builder;
        int index;

        SecretsNested(int index, GenericSecretSource item) {
            this.index = index;
            this.builder = new GenericSecretSourceBuilder(this, item);
        }

        public N and() {
            return (N)KafkaListenerAuthenticationCustomFluent.this.setToSecrets(this.index, this.builder.build());
        }

        public N endSecret() {
            return this.and();
        }
    }
}

