/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener.arraylistener;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer;
import io.strimzi.api.kafka.model.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthentication;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfiguration;
import io.strimzi.api.kafka.model.listener.arraylistener.KafkaListenerType;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import io.strimzi.crdgenerator.annotations.KubeLink;
import io.strimzi.crdgenerator.annotations.Minimum;
import io.strimzi.crdgenerator.annotations.Pattern;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@DescriptionFile
@JsonPropertyOrder(value={"name", "port", "type", "tls", "authentication", "configuration", "networkPolicyPeers"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GenericKafkaListener
implements UnknownPropertyPreserving,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String LISTENER_NAME_REGEX = "^[a-z0-9]{1,11}$";
    private String name;
    private int port;
    private KafkaListenerType type;
    private boolean tls = false;
    private KafkaListenerAuthentication auth;
    private GenericKafkaListenerConfiguration configuration;
    private List<NetworkPolicyPeer> networkPolicyPeers;
    private Map<String, Object> additionalProperties;

    @Description(value="Name of the listener. The name will be used to identify the listener and the related Kubernetes objects. The name has to be unique within given a Kafka cluster. The name can consist of lowercase characters and numbers and be up to 11 characters long.")
    @JsonProperty(required=true)
    @Pattern(value="^[a-z0-9]{1,11}$")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Description(value="Port number used by the listener inside Kafka. The port number has to be unique within a given Kafka cluster. Allowed port numbers are 9092 and higher with the exception of ports 9404 and 9999, which are already used for Prometheus and JMX. Depending on the listener type, the port number might not be the same as the port number that connects Kafka clients.")
    @JsonProperty(required=true)
    @Minimum(value=9092)
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Description(value="Type of the listener. Currently the supported types are `internal`, `route`, `loadbalancer`, `nodeport` and `ingress`. \n\n* `internal` type exposes Kafka internally only within the Kubernetes cluster.\n* `route` type uses OpenShift Routes to expose Kafka.\n* `loadbalancer` type uses LoadBalancer type services to expose Kafka.\n* `nodeport` type uses NodePort type services to expose Kafka.\n* `ingress` type uses Kubernetes Nginx Ingress to expose Kafka with TLS passthrough.\n* `cluster-ip` type uses a per-broker `ClusterIP` service.\n")
    @JsonProperty(required=true)
    public KafkaListenerType getType() {
        return this.type;
    }

    public void setType(KafkaListenerType type) {
        this.type = type;
    }

    @Description(value="Authentication configuration for this listener")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="authentication")
    public KafkaListenerAuthentication getAuth() {
        return this.auth;
    }

    public void setAuth(KafkaListenerAuthentication auth) {
        this.auth = auth;
    }

    @Description(value="Enables TLS encryption on the listener. This is a required property.")
    @JsonProperty(required=true)
    public boolean isTls() {
        return this.tls;
    }

    public void setTls(boolean tls) {
        this.tls = tls;
    }

    @Description(value="Additional listener configuration")
    public GenericKafkaListenerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(GenericKafkaListenerConfiguration configuration) {
        this.configuration = configuration;
    }

    @Description(value="List of peers which should be able to connect to this listener. Peers in this list are combined using a logical OR operation. If this field is empty or missing, all connections will be allowed for this listener. If this field is present and contains at least one item, the listener only allows the traffic which matches at least one item in this list.")
    @KubeLink(group="networking.k8s.io", version="v1", kind="networkpolicypeer")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<NetworkPolicyPeer> getNetworkPolicyPeers() {
        return this.networkPolicyPeers;
    }

    public void setNetworkPolicyPeers(List<NetworkPolicyPeer> networkPolicyPeers) {
        this.networkPolicyPeers = networkPolicyPeers;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(1);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericKafkaListener)) {
            return false;
        }
        GenericKafkaListener other = (GenericKafkaListener)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isTls() != other.isTls()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        KafkaListenerType this$type = this.getType();
        KafkaListenerType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        KafkaListenerAuthentication this$auth = this.getAuth();
        KafkaListenerAuthentication other$auth = other.getAuth();
        if (this$auth == null ? other$auth != null : !((Object)this$auth).equals(other$auth)) {
            return false;
        }
        GenericKafkaListenerConfiguration this$configuration = this.getConfiguration();
        GenericKafkaListenerConfiguration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        List<NetworkPolicyPeer> this$networkPolicyPeers = this.getNetworkPolicyPeers();
        List<NetworkPolicyPeer> other$networkPolicyPeers = other.getNetworkPolicyPeers();
        if (this$networkPolicyPeers == null ? other$networkPolicyPeers != null : !((Object)this$networkPolicyPeers).equals(other$networkPolicyPeers)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenericKafkaListener;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isTls() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        KafkaListenerType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        KafkaListenerAuthentication $auth = this.getAuth();
        result = result * 59 + ($auth == null ? 43 : ((Object)$auth).hashCode());
        GenericKafkaListenerConfiguration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        List<NetworkPolicyPeer> $networkPolicyPeers = this.getNetworkPolicyPeers();
        result = result * 59 + ($networkPolicyPeers == null ? 43 : ((Object)$networkPolicyPeers).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

