/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener.arraylistener;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class GenericKafkaListenerConfigurationBrokerFluent<A extends GenericKafkaListenerConfigurationBrokerFluent<A>>
extends BaseFluent<A> {
    private Integer broker;
    private String advertisedHost;
    private Integer advertisedPort;
    private String host;
    private Map<String, String> annotations;
    private Map<String, String> labels;
    private Integer nodePort;
    private String loadBalancerIP;

    public GenericKafkaListenerConfigurationBrokerFluent() {
    }

    public GenericKafkaListenerConfigurationBrokerFluent(GenericKafkaListenerConfigurationBroker instance) {
        GenericKafkaListenerConfigurationBroker genericKafkaListenerConfigurationBroker = instance = instance != null ? instance : new GenericKafkaListenerConfigurationBroker();
        if (instance != null) {
            this.withBroker(instance.getBroker());
            this.withAdvertisedHost(instance.getAdvertisedHost());
            this.withAdvertisedPort(instance.getAdvertisedPort());
            this.withHost(instance.getHost());
            this.withAnnotations(instance.getAnnotations());
            this.withLabels(instance.getLabels());
            this.withNodePort(instance.getNodePort());
            this.withLoadBalancerIP(instance.getLoadBalancerIP());
        }
    }

    public Integer getBroker() {
        return this.broker;
    }

    public A withBroker(Integer broker) {
        this.broker = broker;
        return (A)((Object)this);
    }

    public boolean hasBroker() {
        return this.broker != null;
    }

    public String getAdvertisedHost() {
        return this.advertisedHost;
    }

    public A withAdvertisedHost(String advertisedHost) {
        this.advertisedHost = advertisedHost;
        return (A)((Object)this);
    }

    public boolean hasAdvertisedHost() {
        return this.advertisedHost != null;
    }

    public Integer getAdvertisedPort() {
        return this.advertisedPort;
    }

    public A withAdvertisedPort(Integer advertisedPort) {
        this.advertisedPort = advertisedPort;
        return (A)((Object)this);
    }

    public boolean hasAdvertisedPort() {
        return this.advertisedPort != null;
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)((Object)this);
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)((Object)this);
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public <K, V> A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)((Object)this);
    }

    public boolean hasLabels() {
        return this.labels != null;
    }

    public Integer getNodePort() {
        return this.nodePort;
    }

    public A withNodePort(Integer nodePort) {
        this.nodePort = nodePort;
        return (A)((Object)this);
    }

    public boolean hasNodePort() {
        return this.nodePort != null;
    }

    public String getLoadBalancerIP() {
        return this.loadBalancerIP;
    }

    public A withLoadBalancerIP(String loadBalancerIP) {
        this.loadBalancerIP = loadBalancerIP;
        return (A)((Object)this);
    }

    public boolean hasLoadBalancerIP() {
        return this.loadBalancerIP != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GenericKafkaListenerConfigurationBrokerFluent that = (GenericKafkaListenerConfigurationBrokerFluent)((Object)o);
        if (!Objects.equals(this.broker, that.broker)) {
            return false;
        }
        if (!Objects.equals(this.advertisedHost, that.advertisedHost)) {
            return false;
        }
        if (!Objects.equals(this.advertisedPort, that.advertisedPort)) {
            return false;
        }
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.labels, that.labels)) {
            return false;
        }
        if (!Objects.equals(this.nodePort, that.nodePort)) {
            return false;
        }
        return Objects.equals(this.loadBalancerIP, that.loadBalancerIP);
    }

    public int hashCode() {
        return Objects.hash(this.broker, this.advertisedHost, this.advertisedPort, this.host, this.annotations, this.labels, this.nodePort, this.loadBalancerIP, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.broker != null) {
            sb.append("broker:");
            sb.append(this.broker + ",");
        }
        if (this.advertisedHost != null) {
            sb.append("advertisedHost:");
            sb.append(this.advertisedHost + ",");
        }
        if (this.advertisedPort != null) {
            sb.append("advertisedPort:");
            sb.append(this.advertisedPort + ",");
        }
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            sb.append("labels:");
            sb.append(this.labels + ",");
        }
        if (this.nodePort != null) {
            sb.append("nodePort:");
            sb.append(this.nodePort + ",");
        }
        if (this.loadBalancerIP != null) {
            sb.append("loadBalancerIP:");
            sb.append(this.loadBalancerIP);
        }
        sb.append("}");
        return sb.toString();
    }
}

