/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.status;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.status.Status;
import io.strimzi.crdgenerator.annotations.Description;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"conditions", "observedGeneration", "pods", "readyPods", "currentPods"})
public class StrimziPodSetStatus
extends Status {
    private static final long serialVersionUID = 1L;
    private int pods;
    private int readyPods;
    private int currentPods;

    @Description(value="Number of pods managed by this `StrimziPodSet` resource.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public int getPods() {
        return this.pods;
    }

    public void setPods(int pods) {
        this.pods = pods;
    }

    @Description(value="Number of pods managed by this `StrimziPodSet` resource that are ready.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public int getReadyPods() {
        return this.readyPods;
    }

    public void setReadyPods(int readyPods) {
        this.readyPods = readyPods;
    }

    @Description(value="Number of pods managed by this `StrimziPodSet` resource that have the current revision.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public int getCurrentPods() {
        return this.currentPods;
    }

    public void setCurrentPods(int currentPods) {
        this.currentPods = currentPods;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StrimziPodSetStatus)) {
            return false;
        }
        StrimziPodSetStatus other = (StrimziPodSetStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPods() != other.getPods()) {
            return false;
        }
        if (this.getReadyPods() != other.getReadyPods()) {
            return false;
        }
        return this.getCurrentPods() == other.getCurrentPods();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StrimziPodSetStatus;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPods();
        result = result * 59 + this.getReadyPods();
        result = result * 59 + this.getCurrentPods();
        return result;
    }

    @Override
    public String toString() {
        return "StrimziPodSetStatus(super=" + super.toString() + ", pods=" + this.getPods() + ", readyPods=" + this.getReadyPods() + ", currentPods=" + this.getCurrentPods() + ")";
    }
}

