/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.storage;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride;
import io.strimzi.api.kafka.model.storage.SingleVolumeStorage;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Minimum;
import java.util.List;
import java.util.Map;

@JsonPropertyOrder(value={"type", "size", "storageClass", "selector", "deleteClaim"})
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class PersistentClaimStorage
extends SingleVolumeStorage {
    private static final long serialVersionUID = 1L;
    private String size;
    private String storageClass;
    private Map<String, String> selector;
    private boolean deleteClaim;
    private List<PersistentClaimStorageOverride> overrides;
    private Integer id;

    @Override
    @Description(value="Must be `persistent-claim`")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return "persistent-claim";
    }

    @Override
    @Description(value="Storage identification number. It is mandatory only for storage volumes defined in a storage of type 'jbod'")
    @Minimum(value=0)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getId() {
        return super.getId();
    }

    @Override
    public void setId(Integer id) {
        super.setId(id);
    }

    @Description(value="When type=persistent-claim, defines the size of the persistent volume claim (i.e 1Gi). Mandatory when type=persistent-claim.")
    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    @JsonProperty(value="class")
    @Description(value="The storage class to use for dynamic volume allocation.")
    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    @Description(value="Specifies a specific persistent volume to use. It contains key:value pairs representing labels for selecting such a volume.")
    public Map<String, String> getSelector() {
        return this.selector;
    }

    public void setSelector(Map<String, String> selector) {
        this.selector = selector;
    }

    @Description(value="Specifies if the persistent volume claim has to be deleted when the cluster is un-deployed.")
    @JsonProperty(defaultValue="false")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isDeleteClaim() {
        return this.deleteClaim;
    }

    public void setDeleteClaim(boolean deleteClaim) {
        this.deleteClaim = deleteClaim;
    }

    @Description(value="Overrides for individual brokers. The `overrides` field allows to specify a different configuration for different brokers.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<PersistentClaimStorageOverride> getOverrides() {
        return this.overrides;
    }

    public void setOverrides(List<PersistentClaimStorageOverride> overrides) {
        this.overrides = overrides;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PersistentClaimStorage)) {
            return false;
        }
        PersistentClaimStorage other = (PersistentClaimStorage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDeleteClaim() != other.isDeleteClaim()) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$size = this.getSize();
        String other$size = other.getSize();
        if (this$size == null ? other$size != null : !this$size.equals(other$size)) {
            return false;
        }
        String this$storageClass = this.getStorageClass();
        String other$storageClass = other.getStorageClass();
        if (this$storageClass == null ? other$storageClass != null : !this$storageClass.equals(other$storageClass)) {
            return false;
        }
        Map<String, String> this$selector = this.getSelector();
        Map<String, String> other$selector = other.getSelector();
        if (this$selector == null ? other$selector != null : !((Object)this$selector).equals(other$selector)) {
            return false;
        }
        List<PersistentClaimStorageOverride> this$overrides = this.getOverrides();
        List<PersistentClaimStorageOverride> other$overrides = other.getOverrides();
        return !(this$overrides == null ? other$overrides != null : !((Object)this$overrides).equals(other$overrides));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PersistentClaimStorage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDeleteClaim() ? 79 : 97);
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : $size.hashCode());
        String $storageClass = this.getStorageClass();
        result = result * 59 + ($storageClass == null ? 43 : $storageClass.hashCode());
        Map<String, String> $selector = this.getSelector();
        result = result * 59 + ($selector == null ? 43 : ((Object)$selector).hashCode());
        List<PersistentClaimStorageOverride> $overrides = this.getOverrides();
        result = result * 59 + ($overrides == null ? 43 : ((Object)$overrides).hashCode());
        return result;
    }
}

