/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.storage;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorage;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PersistentClaimStorageFluent<A extends PersistentClaimStorageFluent<A>>
extends BaseFluent<A> {
    private String size;
    private String storageClass;
    private Map<String, String> selector;
    private boolean deleteClaim;
    private ArrayList<PersistentClaimStorageOverrideBuilder> overrides;
    private Integer id;

    public PersistentClaimStorageFluent() {
    }

    public PersistentClaimStorageFluent(PersistentClaimStorage instance) {
        PersistentClaimStorage persistentClaimStorage = instance = instance != null ? instance : new PersistentClaimStorage();
        if (instance != null) {
            this.withSize(instance.getSize());
            this.withStorageClass(instance.getStorageClass());
            this.withSelector(instance.getSelector());
            this.withDeleteClaim(instance.isDeleteClaim());
            this.withOverrides(instance.getOverrides());
            this.withId(instance.getId());
        }
    }

    public String getSize() {
        return this.size;
    }

    public A withSize(String size) {
        this.size = size;
        return (A)((Object)this);
    }

    public boolean hasSize() {
        return this.size != null;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public A withStorageClass(String storageClass) {
        this.storageClass = storageClass;
        return (A)((Object)this);
    }

    public boolean hasStorageClass() {
        return this.storageClass != null;
    }

    public A addToSelector(String key, String value) {
        if (this.selector == null && key != null && value != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToSelector(Map<String, String> map) {
        if (this.selector == null && map != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.selector.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromSelector(String key) {
        if (this.selector == null) {
            return (A)((Object)this);
        }
        if (key != null && this.selector != null) {
            this.selector.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromSelector(Map<String, String> map) {
        if (this.selector == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.selector == null) continue;
                this.selector.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getSelector() {
        return this.selector;
    }

    public <K, V> A withSelector(Map<String, String> selector) {
        this.selector = selector == null ? null : new LinkedHashMap<String, String>(selector);
        return (A)((Object)this);
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public boolean isDeleteClaim() {
        return this.deleteClaim;
    }

    public A withDeleteClaim(boolean deleteClaim) {
        this.deleteClaim = deleteClaim;
        return (A)((Object)this);
    }

    public boolean hasDeleteClaim() {
        return true;
    }

    public A addToOverrides(int index, PersistentClaimStorageOverride item) {
        if (this.overrides == null) {
            this.overrides = new ArrayList();
        }
        PersistentClaimStorageOverrideBuilder builder = new PersistentClaimStorageOverrideBuilder(item);
        if (index < 0 || index >= this.overrides.size()) {
            this._visitables.get((Object)"overrides").add(builder);
            this.overrides.add(builder);
        } else {
            this._visitables.get((Object)"overrides").add(index, builder);
            this.overrides.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToOverrides(int index, PersistentClaimStorageOverride item) {
        if (this.overrides == null) {
            this.overrides = new ArrayList();
        }
        PersistentClaimStorageOverrideBuilder builder = new PersistentClaimStorageOverrideBuilder(item);
        if (index < 0 || index >= this.overrides.size()) {
            this._visitables.get((Object)"overrides").add(builder);
            this.overrides.add(builder);
        } else {
            this._visitables.get((Object)"overrides").set(index, builder);
            this.overrides.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToOverrides(PersistentClaimStorageOverride ... items) {
        if (this.overrides == null) {
            this.overrides = new ArrayList();
        }
        for (PersistentClaimStorageOverride item : items) {
            PersistentClaimStorageOverrideBuilder builder = new PersistentClaimStorageOverrideBuilder(item);
            this._visitables.get((Object)"overrides").add(builder);
            this.overrides.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToOverrides(Collection<PersistentClaimStorageOverride> items) {
        if (this.overrides == null) {
            this.overrides = new ArrayList();
        }
        for (PersistentClaimStorageOverride item : items) {
            PersistentClaimStorageOverrideBuilder builder = new PersistentClaimStorageOverrideBuilder(item);
            this._visitables.get((Object)"overrides").add(builder);
            this.overrides.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromOverrides(PersistentClaimStorageOverride ... items) {
        if (this.overrides == null) {
            return (A)((Object)this);
        }
        for (PersistentClaimStorageOverride item : items) {
            PersistentClaimStorageOverrideBuilder builder = new PersistentClaimStorageOverrideBuilder(item);
            this._visitables.get((Object)"overrides").remove((Object)builder);
            this.overrides.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOverrides(Collection<PersistentClaimStorageOverride> items) {
        if (this.overrides == null) {
            return (A)((Object)this);
        }
        for (PersistentClaimStorageOverride item : items) {
            PersistentClaimStorageOverrideBuilder builder = new PersistentClaimStorageOverrideBuilder(item);
            this._visitables.get((Object)"overrides").remove((Object)builder);
            this.overrides.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromOverrides(Predicate<PersistentClaimStorageOverrideBuilder> predicate) {
        if (this.overrides == null) {
            return (A)((Object)this);
        }
        Iterator<PersistentClaimStorageOverrideBuilder> each = this.overrides.iterator();
        List visitables = this._visitables.get((Object)"overrides");
        while (each.hasNext()) {
            PersistentClaimStorageOverrideBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<PersistentClaimStorageOverride> buildOverrides() {
        return this.overrides != null ? PersistentClaimStorageFluent.build(this.overrides) : null;
    }

    public PersistentClaimStorageOverride buildOverride(int index) {
        return this.overrides.get(index).build();
    }

    public PersistentClaimStorageOverride buildFirstOverride() {
        return this.overrides.get(0).build();
    }

    public PersistentClaimStorageOverride buildLastOverride() {
        return this.overrides.get(this.overrides.size() - 1).build();
    }

    public PersistentClaimStorageOverride buildMatchingOverride(Predicate<PersistentClaimStorageOverrideBuilder> predicate) {
        for (PersistentClaimStorageOverrideBuilder item : this.overrides) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingOverride(Predicate<PersistentClaimStorageOverrideBuilder> predicate) {
        for (PersistentClaimStorageOverrideBuilder item : this.overrides) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOverrides(List<PersistentClaimStorageOverride> overrides) {
        if (this.overrides != null) {
            this._visitables.get((Object)"overrides").clear();
        }
        if (overrides != null) {
            this.overrides = new ArrayList();
            for (PersistentClaimStorageOverride item : overrides) {
                this.addToOverrides(item);
            }
        } else {
            this.overrides = null;
        }
        return (A)((Object)this);
    }

    public A withOverrides(PersistentClaimStorageOverride ... overrides) {
        if (this.overrides != null) {
            this.overrides.clear();
            this._visitables.remove((Object)"overrides");
        }
        if (overrides != null) {
            for (PersistentClaimStorageOverride item : overrides) {
                this.addToOverrides(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasOverrides() {
        return this.overrides != null && !this.overrides.isEmpty();
    }

    public OverridesNested<A> addNewOverride() {
        return new OverridesNested(-1, null);
    }

    public OverridesNested<A> addNewOverrideLike(PersistentClaimStorageOverride item) {
        return new OverridesNested(-1, item);
    }

    public OverridesNested<A> setNewOverrideLike(int index, PersistentClaimStorageOverride item) {
        return new OverridesNested(index, item);
    }

    public OverridesNested<A> editOverride(int index) {
        if (this.overrides.size() <= index) {
            throw new RuntimeException("Can't edit overrides. Index exceeds size.");
        }
        return this.setNewOverrideLike(index, this.buildOverride(index));
    }

    public OverridesNested<A> editFirstOverride() {
        if (this.overrides.size() == 0) {
            throw new RuntimeException("Can't edit first overrides. The list is empty.");
        }
        return this.setNewOverrideLike(0, this.buildOverride(0));
    }

    public OverridesNested<A> editLastOverride() {
        int index = this.overrides.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last overrides. The list is empty.");
        }
        return this.setNewOverrideLike(index, this.buildOverride(index));
    }

    public OverridesNested<A> editMatchingOverride(Predicate<PersistentClaimStorageOverrideBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.overrides.size(); ++i) {
            if (!predicate.test(this.overrides.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching overrides. No match found.");
        }
        return this.setNewOverrideLike(index, this.buildOverride(index));
    }

    public Integer getId() {
        return this.id;
    }

    public A withId(Integer id) {
        this.id = id;
        return (A)((Object)this);
    }

    public boolean hasId() {
        return this.id != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PersistentClaimStorageFluent that = (PersistentClaimStorageFluent)((Object)o);
        if (!Objects.equals(this.size, that.size)) {
            return false;
        }
        if (!Objects.equals(this.storageClass, that.storageClass)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        if (this.deleteClaim != that.deleteClaim) {
            return false;
        }
        if (!Objects.equals(this.overrides, that.overrides)) {
            return false;
        }
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.size, this.storageClass, this.selector, this.deleteClaim, this.overrides, this.id, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.size != null) {
            sb.append("size:");
            sb.append(this.size + ",");
        }
        if (this.storageClass != null) {
            sb.append("storageClass:");
            sb.append(this.storageClass + ",");
        }
        if (this.selector != null && !this.selector.isEmpty()) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        sb.append("deleteClaim:");
        sb.append(this.deleteClaim + ",");
        if (this.overrides != null && !this.overrides.isEmpty()) {
            sb.append("overrides:");
            sb.append(this.overrides + ",");
        }
        if (this.id != null) {
            sb.append("id:");
            sb.append(this.id);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withDeleteClaim() {
        return this.withDeleteClaim(true);
    }

    public class OverridesNested<N>
    extends PersistentClaimStorageOverrideFluent<OverridesNested<N>>
    implements Nested<N> {
        PersistentClaimStorageOverrideBuilder builder;
        int index;

        OverridesNested(int index, PersistentClaimStorageOverride item) {
            this.index = index;
            this.builder = new PersistentClaimStorageOverrideBuilder(this, item);
        }

        public N and() {
            return (N)PersistentClaimStorageFluent.this.setToOverrides(this.index, this.builder.build());
        }

        public N endOverride() {
            return this.and();
        }
    }
}

