/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class JmxTransOutputDefinitionTemplateFluent<A extends JmxTransOutputDefinitionTemplateFluent<A>>
extends BaseFluent<A> {
    private String outputType;
    private String host;
    private Integer port;
    private Integer flushDelayInSeconds;
    private String name;
    private List<String> typeNames;

    public JmxTransOutputDefinitionTemplateFluent() {
    }

    public JmxTransOutputDefinitionTemplateFluent(JmxTransOutputDefinitionTemplate instance) {
        JmxTransOutputDefinitionTemplate jmxTransOutputDefinitionTemplate = instance = instance != null ? instance : new JmxTransOutputDefinitionTemplate();
        if (instance != null) {
            this.withOutputType(instance.getOutputType());
            this.withHost(instance.getHost());
            this.withPort(instance.getPort());
            this.withFlushDelayInSeconds(instance.getFlushDelayInSeconds());
            this.withName(instance.getName());
            this.withTypeNames(instance.getTypeNames());
        }
    }

    public String getOutputType() {
        return this.outputType;
    }

    public A withOutputType(String outputType) {
        this.outputType = outputType;
        return (A)((Object)this);
    }

    public boolean hasOutputType() {
        return this.outputType != null;
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)((Object)this);
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public Integer getPort() {
        return this.port;
    }

    public A withPort(Integer port) {
        this.port = port;
        return (A)((Object)this);
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public Integer getFlushDelayInSeconds() {
        return this.flushDelayInSeconds;
    }

    public A withFlushDelayInSeconds(Integer flushDelayInSeconds) {
        this.flushDelayInSeconds = flushDelayInSeconds;
        return (A)((Object)this);
    }

    public boolean hasFlushDelayInSeconds() {
        return this.flushDelayInSeconds != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToTypeNames(int index, String item) {
        if (this.typeNames == null) {
            this.typeNames = new ArrayList<String>();
        }
        this.typeNames.add(index, item);
        return (A)((Object)this);
    }

    public A setToTypeNames(int index, String item) {
        if (this.typeNames == null) {
            this.typeNames = new ArrayList<String>();
        }
        this.typeNames.set(index, item);
        return (A)((Object)this);
    }

    public A addToTypeNames(String ... items) {
        if (this.typeNames == null) {
            this.typeNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.typeNames.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTypeNames(Collection<String> items) {
        if (this.typeNames == null) {
            this.typeNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.typeNames.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTypeNames(String ... items) {
        if (this.typeNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.typeNames.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTypeNames(Collection<String> items) {
        if (this.typeNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.typeNames.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getTypeNames() {
        return this.typeNames;
    }

    public String getTypeName(int index) {
        return this.typeNames.get(index);
    }

    public String getFirstTypeName() {
        return this.typeNames.get(0);
    }

    public String getLastTypeName() {
        return this.typeNames.get(this.typeNames.size() - 1);
    }

    public String getMatchingTypeName(Predicate<String> predicate) {
        for (String item : this.typeNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTypeName(Predicate<String> predicate) {
        for (String item : this.typeNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTypeNames(List<String> typeNames) {
        if (typeNames != null) {
            this.typeNames = new ArrayList<String>();
            for (String item : typeNames) {
                this.addToTypeNames(item);
            }
        } else {
            this.typeNames = null;
        }
        return (A)((Object)this);
    }

    public A withTypeNames(String ... typeNames) {
        if (this.typeNames != null) {
            this.typeNames.clear();
            this._visitables.remove((Object)"typeNames");
        }
        if (typeNames != null) {
            for (String item : typeNames) {
                this.addToTypeNames(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTypeNames() {
        return this.typeNames != null && !this.typeNames.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JmxTransOutputDefinitionTemplateFluent that = (JmxTransOutputDefinitionTemplateFluent)((Object)o);
        if (!Objects.equals(this.outputType, that.outputType)) {
            return false;
        }
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.flushDelayInSeconds, that.flushDelayInSeconds)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.typeNames, that.typeNames);
    }

    public int hashCode() {
        return Objects.hash(this.outputType, this.host, this.port, this.flushDelayInSeconds, this.name, this.typeNames, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.outputType != null) {
            sb.append("outputType:");
            sb.append(this.outputType + ",");
        }
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.flushDelayInSeconds != null) {
            sb.append("flushDelayInSeconds:");
            sb.append(this.flushDelayInSeconds + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.typeNames != null && !this.typeNames.isEmpty()) {
            sb.append("typeNames:");
            sb.append(this.typeNames);
        }
        sb.append("}");
        return sb.toString();
    }
}

