/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.template.JmxTransQueryTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class JmxTransQueryTemplateFluent<A extends JmxTransQueryTemplateFluent<A>>
extends BaseFluent<A> {
    private String targetMBean;
    private List<String> attributes;
    private List<String> outputs;

    public JmxTransQueryTemplateFluent() {
    }

    public JmxTransQueryTemplateFluent(JmxTransQueryTemplate instance) {
        JmxTransQueryTemplate jmxTransQueryTemplate = instance = instance != null ? instance : new JmxTransQueryTemplate();
        if (instance != null) {
            this.withTargetMBean(instance.getTargetMBean());
            this.withAttributes(instance.getAttributes());
            this.withOutputs(instance.getOutputs());
        }
    }

    public String getTargetMBean() {
        return this.targetMBean;
    }

    public A withTargetMBean(String targetMBean) {
        this.targetMBean = targetMBean;
        return (A)((Object)this);
    }

    public boolean hasTargetMBean() {
        return this.targetMBean != null;
    }

    public A addToAttributes(int index, String item) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<String>();
        }
        this.attributes.add(index, item);
        return (A)((Object)this);
    }

    public A setToAttributes(int index, String item) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<String>();
        }
        this.attributes.set(index, item);
        return (A)((Object)this);
    }

    public A addToAttributes(String ... items) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<String>();
        }
        for (String item : items) {
            this.attributes.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAttributes(Collection<String> items) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<String>();
        }
        for (String item : items) {
            this.attributes.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAttributes(String ... items) {
        if (this.attributes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.attributes.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAttributes(Collection<String> items) {
        if (this.attributes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.attributes.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public String getAttribute(int index) {
        return this.attributes.get(index);
    }

    public String getFirstAttribute() {
        return this.attributes.get(0);
    }

    public String getLastAttribute() {
        return this.attributes.get(this.attributes.size() - 1);
    }

    public String getMatchingAttribute(Predicate<String> predicate) {
        for (String item : this.attributes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAttribute(Predicate<String> predicate) {
        for (String item : this.attributes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAttributes(List<String> attributes) {
        if (attributes != null) {
            this.attributes = new ArrayList<String>();
            for (String item : attributes) {
                this.addToAttributes(item);
            }
        } else {
            this.attributes = null;
        }
        return (A)((Object)this);
    }

    public A withAttributes(String ... attributes) {
        if (this.attributes != null) {
            this.attributes.clear();
            this._visitables.remove((Object)"attributes");
        }
        if (attributes != null) {
            for (String item : attributes) {
                this.addToAttributes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public A addToOutputs(int index, String item) {
        if (this.outputs == null) {
            this.outputs = new ArrayList<String>();
        }
        this.outputs.add(index, item);
        return (A)((Object)this);
    }

    public A setToOutputs(int index, String item) {
        if (this.outputs == null) {
            this.outputs = new ArrayList<String>();
        }
        this.outputs.set(index, item);
        return (A)((Object)this);
    }

    public A addToOutputs(String ... items) {
        if (this.outputs == null) {
            this.outputs = new ArrayList<String>();
        }
        for (String item : items) {
            this.outputs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToOutputs(Collection<String> items) {
        if (this.outputs == null) {
            this.outputs = new ArrayList<String>();
        }
        for (String item : items) {
            this.outputs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromOutputs(String ... items) {
        if (this.outputs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.outputs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOutputs(Collection<String> items) {
        if (this.outputs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.outputs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getOutputs() {
        return this.outputs;
    }

    public String getOutput(int index) {
        return this.outputs.get(index);
    }

    public String getFirstOutput() {
        return this.outputs.get(0);
    }

    public String getLastOutput() {
        return this.outputs.get(this.outputs.size() - 1);
    }

    public String getMatchingOutput(Predicate<String> predicate) {
        for (String item : this.outputs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingOutput(Predicate<String> predicate) {
        for (String item : this.outputs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOutputs(List<String> outputs) {
        if (outputs != null) {
            this.outputs = new ArrayList<String>();
            for (String item : outputs) {
                this.addToOutputs(item);
            }
        } else {
            this.outputs = null;
        }
        return (A)((Object)this);
    }

    public A withOutputs(String ... outputs) {
        if (this.outputs != null) {
            this.outputs.clear();
            this._visitables.remove((Object)"outputs");
        }
        if (outputs != null) {
            for (String item : outputs) {
                this.addToOutputs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasOutputs() {
        return this.outputs != null && !this.outputs.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JmxTransQueryTemplateFluent that = (JmxTransQueryTemplateFluent)((Object)o);
        if (!Objects.equals(this.targetMBean, that.targetMBean)) {
            return false;
        }
        if (!Objects.equals(this.attributes, that.attributes)) {
            return false;
        }
        return Objects.equals(this.outputs, that.outputs);
    }

    public int hashCode() {
        return Objects.hash(this.targetMBean, this.attributes, this.outputs, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.targetMBean != null) {
            sb.append("targetMBean:");
            sb.append(this.targetMBean + ",");
        }
        if (this.attributes != null && !this.attributes.isEmpty()) {
            sb.append("attributes:");
            sb.append(this.attributes + ",");
        }
        if (this.outputs != null && !this.outputs.isEmpty()) {
            sb.append("outputs:");
            sb.append(this.outputs);
        }
        sb.append("}");
        return sb.toString();
    }
}

