package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AclRuleBuilder extends AclRuleFluent<AclRuleBuilder> implements VisitableBuilder<AclRule,AclRuleBuilder>{
  public AclRuleBuilder() {
    this(false);
  }
  public AclRuleBuilder(Boolean validationEnabled) {
    this(new AclRule(), validationEnabled);
  }
  public AclRuleBuilder(AclRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public AclRuleBuilder(AclRuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AclRule(), validationEnabled);
  }
  public AclRuleBuilder(AclRuleFluent<?> fluent,AclRule instance) {
    this(fluent, instance, false);
  }
  public AclRuleBuilder(AclRuleFluent<?> fluent,AclRule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AclRule());

    if (instance != null) {
      fluent.withType(instance.getType());
      fluent.withResource(instance.getResource());
      fluent.withHost(instance.getHost());
      fluent.withOperations(instance.getOperations());
      fluent.withType(instance.getType());
      fluent.withResource(instance.getResource());
      fluent.withHost(instance.getHost());
      fluent.withOperation(instance.getOperation());
      fluent.withOperations(instance.getOperations());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AclRuleBuilder(AclRule instance) {
    this(instance,false);
  }
  public AclRuleBuilder(AclRule instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AclRule());

    if (instance != null) {
      this.withType(instance.getType());
      this.withResource(instance.getResource());
      this.withHost(instance.getHost());
      this.withOperations(instance.getOperations());
      this.withType(instance.getType());
      this.withResource(instance.getResource());
      this.withHost(instance.getHost());
      this.withOperation(instance.getOperation());
      this.withOperations(instance.getOperations());
    }
    this.validationEnabled = validationEnabled; 
  }
  AclRuleFluent<?> fluent;
  Boolean validationEnabled;
  public AclRule build() {
    AclRule buildable = new AclRule(fluent.getType(),fluent.buildResource(),fluent.getHost(),fluent.getOperations());
    buildable.setOperation(fluent.getOperation());
    return buildable;
  }
  
}