package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AutoRestartBuilder extends AutoRestartFluent<AutoRestartBuilder> implements VisitableBuilder<AutoRestart,AutoRestartBuilder>{
  public AutoRestartBuilder() {
    this(false);
  }
  public AutoRestartBuilder(Boolean validationEnabled) {
    this(new AutoRestart(), validationEnabled);
  }
  public AutoRestartBuilder(AutoRestartFluent<?> fluent) {
    this(fluent, false);
  }
  public AutoRestartBuilder(AutoRestartFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AutoRestart(), validationEnabled);
  }
  public AutoRestartBuilder(AutoRestartFluent<?> fluent,AutoRestart instance) {
    this(fluent, instance, false);
  }
  public AutoRestartBuilder(AutoRestartFluent<?> fluent,AutoRestart instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AutoRestart());

    if (instance != null) {
      fluent.withEnabled(instance.isEnabled());
      fluent.withMaxRestarts(instance.getMaxRestarts());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AutoRestartBuilder(AutoRestart instance) {
    this(instance,false);
  }
  public AutoRestartBuilder(AutoRestart instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AutoRestart());

    if (instance != null) {
      this.withEnabled(instance.isEnabled());
      this.withMaxRestarts(instance.getMaxRestarts());
    }
    this.validationEnabled = validationEnabled; 
  }
  AutoRestartFluent<?> fluent;
  Boolean validationEnabled;
  public AutoRestart build() {
    AutoRestart buildable = new AutoRestart();
    buildable.setEnabled(fluent.isEnabled());
    buildable.setMaxRestarts(fluent.getMaxRestarts());
    return buildable;
  }
  
}