package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertSecretSourceBuilder extends CertSecretSourceFluent<CertSecretSourceBuilder> implements VisitableBuilder<CertSecretSource,CertSecretSourceBuilder>{
  public CertSecretSourceBuilder() {
    this(false);
  }
  public CertSecretSourceBuilder(Boolean validationEnabled) {
    this(new CertSecretSource(), validationEnabled);
  }
  public CertSecretSourceBuilder(CertSecretSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public CertSecretSourceBuilder(CertSecretSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertSecretSource(), validationEnabled);
  }
  public CertSecretSourceBuilder(CertSecretSourceFluent<?> fluent,CertSecretSource instance) {
    this(fluent, instance, false);
  }
  public CertSecretSourceBuilder(CertSecretSourceFluent<?> fluent,CertSecretSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CertSecretSource());

    if (instance != null) {
      fluent.withSecretName(instance.getSecretName());
      fluent.withCertificate(instance.getCertificate());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CertSecretSourceBuilder(CertSecretSource instance) {
    this(instance,false);
  }
  public CertSecretSourceBuilder(CertSecretSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CertSecretSource());

    if (instance != null) {
      this.withSecretName(instance.getSecretName());
      this.withCertificate(instance.getCertificate());
    }
    this.validationEnabled = validationEnabled; 
  }
  CertSecretSourceFluent<?> fluent;
  Boolean validationEnabled;
  public CertSecretSource build() {
    CertSecretSource buildable = new CertSecretSource();
    buildable.setSecretName(fluent.getSecretName());
    buildable.setCertificate(fluent.getCertificate());
    return buildable;
  }
  
}