package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateAuthorityBuilder extends CertificateAuthorityFluent<CertificateAuthorityBuilder> implements VisitableBuilder<CertificateAuthority,CertificateAuthorityBuilder>{
  public CertificateAuthorityBuilder() {
    this(false);
  }
  public CertificateAuthorityBuilder(Boolean validationEnabled) {
    this(new CertificateAuthority(), validationEnabled);
  }
  public CertificateAuthorityBuilder(CertificateAuthorityFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateAuthorityBuilder(CertificateAuthorityFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertificateAuthority(), validationEnabled);
  }
  public CertificateAuthorityBuilder(CertificateAuthorityFluent<?> fluent,CertificateAuthority instance) {
    this(fluent, instance, false);
  }
  public CertificateAuthorityBuilder(CertificateAuthorityFluent<?> fluent,CertificateAuthority instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CertificateAuthority());

    if (instance != null) {
      fluent.withValidityDays(instance.getValidityDays());
      fluent.withGenerateCertificateAuthority(instance.isGenerateCertificateAuthority());
      fluent.withGenerateSecretOwnerReference(instance.isGenerateSecretOwnerReference());
      fluent.withRenewalDays(instance.getRenewalDays());
      fluent.withCertificateExpirationPolicy(instance.getCertificateExpirationPolicy());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CertificateAuthorityBuilder(CertificateAuthority instance) {
    this(instance,false);
  }
  public CertificateAuthorityBuilder(CertificateAuthority instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CertificateAuthority());

    if (instance != null) {
      this.withValidityDays(instance.getValidityDays());
      this.withGenerateCertificateAuthority(instance.isGenerateCertificateAuthority());
      this.withGenerateSecretOwnerReference(instance.isGenerateSecretOwnerReference());
      this.withRenewalDays(instance.getRenewalDays());
      this.withCertificateExpirationPolicy(instance.getCertificateExpirationPolicy());
    }
    this.validationEnabled = validationEnabled; 
  }
  CertificateAuthorityFluent<?> fluent;
  Boolean validationEnabled;
  public CertificateAuthority build() {
    CertificateAuthority buildable = new CertificateAuthority();
    buildable.setValidityDays(fluent.getValidityDays());
    buildable.setGenerateCertificateAuthority(fluent.isGenerateCertificateAuthority());
    buildable.setGenerateSecretOwnerReference(fluent.isGenerateSecretOwnerReference());
    buildable.setRenewalDays(fluent.getRenewalDays());
    buildable.setCertificateExpirationPolicy(fluent.getCertificateExpirationPolicy());
    return buildable;
  }
  
}