package io.strimzi.api.kafka.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CertificateAuthorityFluent<A extends CertificateAuthorityFluent<A>> extends BaseFluent<A>{
  public CertificateAuthorityFluent() {
  }
  public CertificateAuthorityFluent(CertificateAuthority instance) {
    instance = (instance != null ? instance : new CertificateAuthority());

    if (instance != null) {
      this.withValidityDays(instance.getValidityDays());
      this.withGenerateCertificateAuthority(instance.isGenerateCertificateAuthority());
      this.withGenerateSecretOwnerReference(instance.isGenerateSecretOwnerReference());
      this.withRenewalDays(instance.getRenewalDays());
      this.withCertificateExpirationPolicy(instance.getCertificateExpirationPolicy());
    }
  }
  private int validityDays;
  private boolean generateCertificateAuthority;
  private boolean generateSecretOwnerReference;
  private int renewalDays;
  private CertificateExpirationPolicy certificateExpirationPolicy;
  public int getValidityDays() {
    return this.validityDays;
  }
  public A withValidityDays(int validityDays) {
    this.validityDays=validityDays; return (A) this;
  }
  public boolean hasValidityDays() {
    return true;
  }
  public boolean isGenerateCertificateAuthority() {
    return this.generateCertificateAuthority;
  }
  public A withGenerateCertificateAuthority(boolean generateCertificateAuthority) {
    this.generateCertificateAuthority=generateCertificateAuthority; return (A) this;
  }
  public boolean hasGenerateCertificateAuthority() {
    return true;
  }
  public boolean isGenerateSecretOwnerReference() {
    return this.generateSecretOwnerReference;
  }
  public A withGenerateSecretOwnerReference(boolean generateSecretOwnerReference) {
    this.generateSecretOwnerReference=generateSecretOwnerReference; return (A) this;
  }
  public boolean hasGenerateSecretOwnerReference() {
    return true;
  }
  public int getRenewalDays() {
    return this.renewalDays;
  }
  public A withRenewalDays(int renewalDays) {
    this.renewalDays=renewalDays; return (A) this;
  }
  public boolean hasRenewalDays() {
    return true;
  }
  public CertificateExpirationPolicy getCertificateExpirationPolicy() {
    return this.certificateExpirationPolicy;
  }
  public A withCertificateExpirationPolicy(CertificateExpirationPolicy certificateExpirationPolicy) {
    this.certificateExpirationPolicy=certificateExpirationPolicy; return (A) this;
  }
  public boolean hasCertificateExpirationPolicy() {
    return this.certificateExpirationPolicy != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CertificateAuthorityFluent that = (CertificateAuthorityFluent) o;
    if (validityDays != that.validityDays) return false;
    if (generateCertificateAuthority != that.generateCertificateAuthority) return false;
    if (generateSecretOwnerReference != that.generateSecretOwnerReference) return false;
    if (renewalDays != that.renewalDays) return false;
    if (!java.util.Objects.equals(certificateExpirationPolicy, that.certificateExpirationPolicy)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(validityDays,  generateCertificateAuthority,  generateSecretOwnerReference,  renewalDays,  certificateExpirationPolicy,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    sb.append("validityDays:"); sb.append(validityDays + ",");
    sb.append("generateCertificateAuthority:"); sb.append(generateCertificateAuthority + ",");
    sb.append("generateSecretOwnerReference:"); sb.append(generateSecretOwnerReference + ",");
    sb.append("renewalDays:"); sb.append(renewalDays + ",");
    if (certificateExpirationPolicy != null) { sb.append("certificateExpirationPolicy:"); sb.append(certificateExpirationPolicy); }
    sb.append("}");
    return sb.toString();
  }
  public A withGenerateCertificateAuthority() {
    return withGenerateCertificateAuthority(true);
  }
  public A withGenerateSecretOwnerReference() {
    return withGenerateSecretOwnerReference(true);
  }
  
}