package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerEnvVarBuilder extends ContainerEnvVarFluent<ContainerEnvVarBuilder> implements VisitableBuilder<ContainerEnvVar,ContainerEnvVarBuilder>{
  public ContainerEnvVarBuilder() {
    this(false);
  }
  public ContainerEnvVarBuilder(Boolean validationEnabled) {
    this(new ContainerEnvVar(), validationEnabled);
  }
  public ContainerEnvVarBuilder(ContainerEnvVarFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerEnvVarBuilder(ContainerEnvVarFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerEnvVar(), validationEnabled);
  }
  public ContainerEnvVarBuilder(ContainerEnvVarFluent<?> fluent,ContainerEnvVar instance) {
    this(fluent, instance, false);
  }
  public ContainerEnvVarBuilder(ContainerEnvVarFluent<?> fluent,ContainerEnvVar instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ContainerEnvVar());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ContainerEnvVarBuilder(ContainerEnvVar instance) {
    this(instance,false);
  }
  public ContainerEnvVarBuilder(ContainerEnvVar instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ContainerEnvVar());

    if (instance != null) {
      this.withName(instance.getName());
      this.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  ContainerEnvVarFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerEnvVar build() {
    ContainerEnvVar buildable = new ContainerEnvVar();
    buildable.setName(fluent.getName());
    buildable.setValue(fluent.getValue());
    return buildable;
  }
  
}