package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EntityOperatorSpecBuilder extends EntityOperatorSpecFluent<EntityOperatorSpecBuilder> implements VisitableBuilder<EntityOperatorSpec,EntityOperatorSpecBuilder>{
  public EntityOperatorSpecBuilder() {
    this(false);
  }
  public EntityOperatorSpecBuilder(Boolean validationEnabled) {
    this(new EntityOperatorSpec(), validationEnabled);
  }
  public EntityOperatorSpecBuilder(EntityOperatorSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public EntityOperatorSpecBuilder(EntityOperatorSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EntityOperatorSpec(), validationEnabled);
  }
  public EntityOperatorSpecBuilder(EntityOperatorSpecFluent<?> fluent,EntityOperatorSpec instance) {
    this(fluent, instance, false);
  }
  public EntityOperatorSpecBuilder(EntityOperatorSpecFluent<?> fluent,EntityOperatorSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EntityOperatorSpec());

    if (instance != null) {
      fluent.withTopicOperator(instance.getTopicOperator());
      fluent.withUserOperator(instance.getUserOperator());
      fluent.withTlsSidecar(instance.getTlsSidecar());
      fluent.withTemplate(instance.getTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EntityOperatorSpecBuilder(EntityOperatorSpec instance) {
    this(instance,false);
  }
  public EntityOperatorSpecBuilder(EntityOperatorSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EntityOperatorSpec());

    if (instance != null) {
      this.withTopicOperator(instance.getTopicOperator());
      this.withUserOperator(instance.getUserOperator());
      this.withTlsSidecar(instance.getTlsSidecar());
      this.withTemplate(instance.getTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  EntityOperatorSpecFluent<?> fluent;
  Boolean validationEnabled;
  public EntityOperatorSpec build() {
    EntityOperatorSpec buildable = new EntityOperatorSpec();
    buildable.setTopicOperator(fluent.buildTopicOperator());
    buildable.setUserOperator(fluent.buildUserOperator());
    buildable.setTlsSidecar(fluent.buildTlsSidecar());
    buildable.setTemplate(fluent.buildTemplate());
    return buildable;
  }
  
}