package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.template.EntityOperatorTemplateBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent;
import io.strimzi.api.kafka.model.template.EntityOperatorTemplate;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EntityOperatorSpecFluent<A extends EntityOperatorSpecFluent<A>> extends BaseFluent<A>{
  public EntityOperatorSpecFluent() {
  }
  public EntityOperatorSpecFluent(EntityOperatorSpec instance) {
    instance = (instance != null ? instance : new EntityOperatorSpec());

    if (instance != null) {
      this.withTopicOperator(instance.getTopicOperator());
      this.withUserOperator(instance.getUserOperator());
      this.withTlsSidecar(instance.getTlsSidecar());
      this.withTemplate(instance.getTemplate());
    }
  }
  private EntityTopicOperatorSpecBuilder topicOperator;
  private EntityUserOperatorSpecBuilder userOperator;
  private TlsSidecarBuilder tlsSidecar;
  private EntityOperatorTemplateBuilder template;
  public EntityTopicOperatorSpec buildTopicOperator() {
    return this.topicOperator!=null ?this.topicOperator.build():null;
  }
  public A withTopicOperator(EntityTopicOperatorSpec topicOperator) {
    _visitables.get("topicOperator").remove(this.topicOperator);
    if (topicOperator!=null){ this.topicOperator= new EntityTopicOperatorSpecBuilder(topicOperator); _visitables.get("topicOperator").add(this.topicOperator);} else { this.topicOperator = null; _visitables.get("topicOperator").remove(this.topicOperator); } return (A) this;
  }
  public boolean hasTopicOperator() {
    return this.topicOperator != null;
  }
  public TopicOperatorNested<A> withNewTopicOperator() {
    return new TopicOperatorNested(null);
  }
  public TopicOperatorNested<A> withNewTopicOperatorLike(EntityTopicOperatorSpec item) {
    return new TopicOperatorNested(item);
  }
  public TopicOperatorNested<A> editTopicOperator() {
    return withNewTopicOperatorLike(java.util.Optional.ofNullable(buildTopicOperator()).orElse(null));
  }
  public TopicOperatorNested<A> editOrNewTopicOperator() {
    return withNewTopicOperatorLike(java.util.Optional.ofNullable(buildTopicOperator()).orElse(new EntityTopicOperatorSpecBuilder().build()));
  }
  public TopicOperatorNested<A> editOrNewTopicOperatorLike(EntityTopicOperatorSpec item) {
    return withNewTopicOperatorLike(java.util.Optional.ofNullable(buildTopicOperator()).orElse(item));
  }
  public EntityUserOperatorSpec buildUserOperator() {
    return this.userOperator!=null ?this.userOperator.build():null;
  }
  public A withUserOperator(EntityUserOperatorSpec userOperator) {
    _visitables.get("userOperator").remove(this.userOperator);
    if (userOperator!=null){ this.userOperator= new EntityUserOperatorSpecBuilder(userOperator); _visitables.get("userOperator").add(this.userOperator);} else { this.userOperator = null; _visitables.get("userOperator").remove(this.userOperator); } return (A) this;
  }
  public boolean hasUserOperator() {
    return this.userOperator != null;
  }
  public UserOperatorNested<A> withNewUserOperator() {
    return new UserOperatorNested(null);
  }
  public UserOperatorNested<A> withNewUserOperatorLike(EntityUserOperatorSpec item) {
    return new UserOperatorNested(item);
  }
  public UserOperatorNested<A> editUserOperator() {
    return withNewUserOperatorLike(java.util.Optional.ofNullable(buildUserOperator()).orElse(null));
  }
  public UserOperatorNested<A> editOrNewUserOperator() {
    return withNewUserOperatorLike(java.util.Optional.ofNullable(buildUserOperator()).orElse(new EntityUserOperatorSpecBuilder().build()));
  }
  public UserOperatorNested<A> editOrNewUserOperatorLike(EntityUserOperatorSpec item) {
    return withNewUserOperatorLike(java.util.Optional.ofNullable(buildUserOperator()).orElse(item));
  }
  public TlsSidecar buildTlsSidecar() {
    return this.tlsSidecar!=null ?this.tlsSidecar.build():null;
  }
  public A withTlsSidecar(TlsSidecar tlsSidecar) {
    _visitables.get("tlsSidecar").remove(this.tlsSidecar);
    if (tlsSidecar!=null){ this.tlsSidecar= new TlsSidecarBuilder(tlsSidecar); _visitables.get("tlsSidecar").add(this.tlsSidecar);} else { this.tlsSidecar = null; _visitables.get("tlsSidecar").remove(this.tlsSidecar); } return (A) this;
  }
  public boolean hasTlsSidecar() {
    return this.tlsSidecar != null;
  }
  public TlsSidecarNested<A> withNewTlsSidecar() {
    return new TlsSidecarNested(null);
  }
  public TlsSidecarNested<A> withNewTlsSidecarLike(TlsSidecar item) {
    return new TlsSidecarNested(item);
  }
  public TlsSidecarNested<A> editTlsSidecar() {
    return withNewTlsSidecarLike(java.util.Optional.ofNullable(buildTlsSidecar()).orElse(null));
  }
  public TlsSidecarNested<A> editOrNewTlsSidecar() {
    return withNewTlsSidecarLike(java.util.Optional.ofNullable(buildTlsSidecar()).orElse(new TlsSidecarBuilder().build()));
  }
  public TlsSidecarNested<A> editOrNewTlsSidecarLike(TlsSidecar item) {
    return withNewTlsSidecarLike(java.util.Optional.ofNullable(buildTlsSidecar()).orElse(item));
  }
  public EntityOperatorTemplate buildTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public A withTemplate(EntityOperatorTemplate template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new EntityOperatorTemplateBuilder(template); _visitables.get("template").add(this.template);} else { this.template = null; _visitables.get("template").remove(this.template); } return (A) this;
  }
  public boolean hasTemplate() {
    return this.template != null;
  }
  public TemplateNested<A> withNewTemplate() {
    return new TemplateNested(null);
  }
  public TemplateNested<A> withNewTemplateLike(EntityOperatorTemplate item) {
    return new TemplateNested(item);
  }
  public TemplateNested<A> editTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(null));
  }
  public TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(new EntityOperatorTemplateBuilder().build()));
  }
  public TemplateNested<A> editOrNewTemplateLike(EntityOperatorTemplate item) {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EntityOperatorSpecFluent that = (EntityOperatorSpecFluent) o;
    if (!java.util.Objects.equals(topicOperator, that.topicOperator)) return false;

    if (!java.util.Objects.equals(userOperator, that.userOperator)) return false;

    if (!java.util.Objects.equals(tlsSidecar, that.tlsSidecar)) return false;

    if (!java.util.Objects.equals(template, that.template)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(topicOperator,  userOperator,  tlsSidecar,  template,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (topicOperator != null) { sb.append("topicOperator:"); sb.append(topicOperator + ","); }
    if (userOperator != null) { sb.append("userOperator:"); sb.append(userOperator + ","); }
    if (tlsSidecar != null) { sb.append("tlsSidecar:"); sb.append(tlsSidecar + ","); }
    if (template != null) { sb.append("template:"); sb.append(template); }
    sb.append("}");
    return sb.toString();
  }
  public class TopicOperatorNested<N> extends EntityTopicOperatorSpecFluent<TopicOperatorNested<N>> implements Nested<N>{
    TopicOperatorNested(EntityTopicOperatorSpec item) {
      this.builder = new EntityTopicOperatorSpecBuilder(this, item);
    }
    EntityTopicOperatorSpecBuilder builder;
    public N and() {
      return (N) EntityOperatorSpecFluent.this.withTopicOperator(builder.build());
    }
    public N endTopicOperator() {
      return and();
    }
    
  }
  public class UserOperatorNested<N> extends EntityUserOperatorSpecFluent<UserOperatorNested<N>> implements Nested<N>{
    UserOperatorNested(EntityUserOperatorSpec item) {
      this.builder = new EntityUserOperatorSpecBuilder(this, item);
    }
    EntityUserOperatorSpecBuilder builder;
    public N and() {
      return (N) EntityOperatorSpecFluent.this.withUserOperator(builder.build());
    }
    public N endUserOperator() {
      return and();
    }
    
  }
  public class TlsSidecarNested<N> extends TlsSidecarFluent<TlsSidecarNested<N>> implements Nested<N>{
    TlsSidecarNested(TlsSidecar item) {
      this.builder = new TlsSidecarBuilder(this, item);
    }
    TlsSidecarBuilder builder;
    public N and() {
      return (N) EntityOperatorSpecFluent.this.withTlsSidecar(builder.build());
    }
    public N endTlsSidecar() {
      return and();
    }
    
  }
  public class TemplateNested<N> extends EntityOperatorTemplateFluent<TemplateNested<N>> implements Nested<N>{
    TemplateNested(EntityOperatorTemplate item) {
      this.builder = new EntityOperatorTemplateBuilder(this, item);
    }
    EntityOperatorTemplateBuilder builder;
    public N and() {
      return (N) EntityOperatorSpecFluent.this.withTemplate(builder.build());
    }
    public N endTemplate() {
      return and();
    }
    
  }
  
}