package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EntityTopicOperatorSpecBuilder extends EntityTopicOperatorSpecFluent<EntityTopicOperatorSpecBuilder> implements VisitableBuilder<EntityTopicOperatorSpec,EntityTopicOperatorSpecBuilder>{
  public EntityTopicOperatorSpecBuilder() {
    this(false);
  }
  public EntityTopicOperatorSpecBuilder(Boolean validationEnabled) {
    this(new EntityTopicOperatorSpec(), validationEnabled);
  }
  public EntityTopicOperatorSpecBuilder(EntityTopicOperatorSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public EntityTopicOperatorSpecBuilder(EntityTopicOperatorSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EntityTopicOperatorSpec(), validationEnabled);
  }
  public EntityTopicOperatorSpecBuilder(EntityTopicOperatorSpecFluent<?> fluent,EntityTopicOperatorSpec instance) {
    this(fluent, instance, false);
  }
  public EntityTopicOperatorSpecBuilder(EntityTopicOperatorSpecFluent<?> fluent,EntityTopicOperatorSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EntityTopicOperatorSpec());

    if (instance != null) {
      fluent.withWatchedNamespace(instance.getWatchedNamespace());
      fluent.withImage(instance.getImage());
      fluent.withReconciliationIntervalSeconds(instance.getReconciliationIntervalSeconds());
      fluent.withZookeeperSessionTimeoutSeconds(instance.getZookeeperSessionTimeoutSeconds());
      fluent.withTopicMetadataMaxAttempts(instance.getTopicMetadataMaxAttempts());
      fluent.withStartupProbe(instance.getStartupProbe());
      fluent.withLivenessProbe(instance.getLivenessProbe());
      fluent.withReadinessProbe(instance.getReadinessProbe());
      fluent.withResources(instance.getResources());
      fluent.withLogging(instance.getLogging());
      fluent.withJvmOptions(instance.getJvmOptions());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EntityTopicOperatorSpecBuilder(EntityTopicOperatorSpec instance) {
    this(instance,false);
  }
  public EntityTopicOperatorSpecBuilder(EntityTopicOperatorSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EntityTopicOperatorSpec());

    if (instance != null) {
      this.withWatchedNamespace(instance.getWatchedNamespace());
      this.withImage(instance.getImage());
      this.withReconciliationIntervalSeconds(instance.getReconciliationIntervalSeconds());
      this.withZookeeperSessionTimeoutSeconds(instance.getZookeeperSessionTimeoutSeconds());
      this.withTopicMetadataMaxAttempts(instance.getTopicMetadataMaxAttempts());
      this.withStartupProbe(instance.getStartupProbe());
      this.withLivenessProbe(instance.getLivenessProbe());
      this.withReadinessProbe(instance.getReadinessProbe());
      this.withResources(instance.getResources());
      this.withLogging(instance.getLogging());
      this.withJvmOptions(instance.getJvmOptions());
    }
    this.validationEnabled = validationEnabled; 
  }
  EntityTopicOperatorSpecFluent<?> fluent;
  Boolean validationEnabled;
  public EntityTopicOperatorSpec build() {
    EntityTopicOperatorSpec buildable = new EntityTopicOperatorSpec();
    buildable.setWatchedNamespace(fluent.getWatchedNamespace());
    buildable.setImage(fluent.getImage());
    buildable.setReconciliationIntervalSeconds(fluent.getReconciliationIntervalSeconds());
    buildable.setZookeeperSessionTimeoutSeconds(fluent.getZookeeperSessionTimeoutSeconds());
    buildable.setTopicMetadataMaxAttempts(fluent.getTopicMetadataMaxAttempts());
    buildable.setStartupProbe(fluent.buildStartupProbe());
    buildable.setLivenessProbe(fluent.buildLivenessProbe());
    buildable.setReadinessProbe(fluent.buildReadinessProbe());
    buildable.setResources(fluent.getResources());
    buildable.setLogging(fluent.buildLogging());
    buildable.setJvmOptions(fluent.buildJvmOptions());
    return buildable;
  }
  
}