package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EntityTopicOperatorSpecFluent<A extends EntityTopicOperatorSpecFluent<A>> extends BaseFluent<A>{
  public EntityTopicOperatorSpecFluent() {
  }
  public EntityTopicOperatorSpecFluent(EntityTopicOperatorSpec instance) {
    instance = (instance != null ? instance : new EntityTopicOperatorSpec());

    if (instance != null) {
      this.withWatchedNamespace(instance.getWatchedNamespace());
      this.withImage(instance.getImage());
      this.withReconciliationIntervalSeconds(instance.getReconciliationIntervalSeconds());
      this.withZookeeperSessionTimeoutSeconds(instance.getZookeeperSessionTimeoutSeconds());
      this.withTopicMetadataMaxAttempts(instance.getTopicMetadataMaxAttempts());
      this.withStartupProbe(instance.getStartupProbe());
      this.withLivenessProbe(instance.getLivenessProbe());
      this.withReadinessProbe(instance.getReadinessProbe());
      this.withResources(instance.getResources());
      this.withLogging(instance.getLogging());
      this.withJvmOptions(instance.getJvmOptions());
    }
  }
  private String watchedNamespace;
  private String image;
  private int reconciliationIntervalSeconds;
  private int zookeeperSessionTimeoutSeconds;
  private int topicMetadataMaxAttempts;
  private ProbeBuilder startupProbe;
  private ProbeBuilder livenessProbe;
  private ProbeBuilder readinessProbe;
  private ResourceRequirements resources;
  private VisitableBuilder<? extends Logging,?> logging;
  private JvmOptionsBuilder jvmOptions;
  public String getWatchedNamespace() {
    return this.watchedNamespace;
  }
  public A withWatchedNamespace(String watchedNamespace) {
    this.watchedNamespace=watchedNamespace; return (A) this;
  }
  public boolean hasWatchedNamespace() {
    return this.watchedNamespace != null;
  }
  public String getImage() {
    return this.image;
  }
  public A withImage(String image) {
    this.image=image; return (A) this;
  }
  public boolean hasImage() {
    return this.image != null;
  }
  public int getReconciliationIntervalSeconds() {
    return this.reconciliationIntervalSeconds;
  }
  public A withReconciliationIntervalSeconds(int reconciliationIntervalSeconds) {
    this.reconciliationIntervalSeconds=reconciliationIntervalSeconds; return (A) this;
  }
  public boolean hasReconciliationIntervalSeconds() {
    return true;
  }
  public int getZookeeperSessionTimeoutSeconds() {
    return this.zookeeperSessionTimeoutSeconds;
  }
  public A withZookeeperSessionTimeoutSeconds(int zookeeperSessionTimeoutSeconds) {
    this.zookeeperSessionTimeoutSeconds=zookeeperSessionTimeoutSeconds; return (A) this;
  }
  public boolean hasZookeeperSessionTimeoutSeconds() {
    return true;
  }
  public int getTopicMetadataMaxAttempts() {
    return this.topicMetadataMaxAttempts;
  }
  public A withTopicMetadataMaxAttempts(int topicMetadataMaxAttempts) {
    this.topicMetadataMaxAttempts=topicMetadataMaxAttempts; return (A) this;
  }
  public boolean hasTopicMetadataMaxAttempts() {
    return true;
  }
  public Probe buildStartupProbe() {
    return this.startupProbe!=null ?this.startupProbe.build():null;
  }
  public A withStartupProbe(Probe startupProbe) {
    _visitables.get("startupProbe").remove(this.startupProbe);
    if (startupProbe!=null){ this.startupProbe= new ProbeBuilder(startupProbe); _visitables.get("startupProbe").add(this.startupProbe);} else { this.startupProbe = null; _visitables.get("startupProbe").remove(this.startupProbe); } return (A) this;
  }
  public boolean hasStartupProbe() {
    return this.startupProbe != null;
  }
  public A withNewStartupProbe(int initialDelaySeconds,int timeoutSeconds) {
    return (A)withStartupProbe(new Probe(initialDelaySeconds, timeoutSeconds));
  }
  public StartupProbeNested<A> withNewStartupProbe() {
    return new StartupProbeNested(null);
  }
  public StartupProbeNested<A> withNewStartupProbeLike(Probe item) {
    return new StartupProbeNested(item);
  }
  public StartupProbeNested<A> editStartupProbe() {
    return withNewStartupProbeLike(java.util.Optional.ofNullable(buildStartupProbe()).orElse(null));
  }
  public StartupProbeNested<A> editOrNewStartupProbe() {
    return withNewStartupProbeLike(java.util.Optional.ofNullable(buildStartupProbe()).orElse(new ProbeBuilder().build()));
  }
  public StartupProbeNested<A> editOrNewStartupProbeLike(Probe item) {
    return withNewStartupProbeLike(java.util.Optional.ofNullable(buildStartupProbe()).orElse(item));
  }
  public Probe buildLivenessProbe() {
    return this.livenessProbe!=null ?this.livenessProbe.build():null;
  }
  public A withLivenessProbe(Probe livenessProbe) {
    _visitables.get("livenessProbe").remove(this.livenessProbe);
    if (livenessProbe!=null){ this.livenessProbe= new ProbeBuilder(livenessProbe); _visitables.get("livenessProbe").add(this.livenessProbe);} else { this.livenessProbe = null; _visitables.get("livenessProbe").remove(this.livenessProbe); } return (A) this;
  }
  public boolean hasLivenessProbe() {
    return this.livenessProbe != null;
  }
  public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds) {
    return (A)withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
  }
  public LivenessProbeNested<A> withNewLivenessProbe() {
    return new LivenessProbeNested(null);
  }
  public LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
    return new LivenessProbeNested(item);
  }
  public LivenessProbeNested<A> editLivenessProbe() {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(null));
  }
  public LivenessProbeNested<A> editOrNewLivenessProbe() {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(new ProbeBuilder().build()));
  }
  public LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(item));
  }
  public Probe buildReadinessProbe() {
    return this.readinessProbe!=null ?this.readinessProbe.build():null;
  }
  public A withReadinessProbe(Probe readinessProbe) {
    _visitables.get("readinessProbe").remove(this.readinessProbe);
    if (readinessProbe!=null){ this.readinessProbe= new ProbeBuilder(readinessProbe); _visitables.get("readinessProbe").add(this.readinessProbe);} else { this.readinessProbe = null; _visitables.get("readinessProbe").remove(this.readinessProbe); } return (A) this;
  }
  public boolean hasReadinessProbe() {
    return this.readinessProbe != null;
  }
  public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds) {
    return (A)withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
  }
  public ReadinessProbeNested<A> withNewReadinessProbe() {
    return new ReadinessProbeNested(null);
  }
  public ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
    return new ReadinessProbeNested(item);
  }
  public ReadinessProbeNested<A> editReadinessProbe() {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(null));
  }
  public ReadinessProbeNested<A> editOrNewReadinessProbe() {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(new ProbeBuilder().build()));
  }
  public ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(item));
  }
  public ResourceRequirements getResources() {
    return this.resources;
  }
  public A withResources(ResourceRequirements resources) {
    this.resources=resources; return (A) this;
  }
  public boolean hasResources() {
    return this.resources != null;
  }
  public Logging buildLogging() {
    return this.logging!=null?this.logging.build():null;
  }
  public A withLogging(Logging logging) {
    if (logging==null){ this.logging = null; _visitables.remove("logging"); return (A) this;}
    VisitableBuilder<? extends Logging,?> builder = builder(logging); _visitables.get("logging").clear();_visitables.get("logging").add(builder);this.logging = builder;
    return (A) this;
  }
  public boolean hasLogging() {
    return this.logging != null;
  }
  public ExternalLoggingNested<A> withNewExternalLogging() {
    return new ExternalLoggingNested(null);
  }
  public ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item) {
    return new ExternalLoggingNested(item);
  }
  public InlineLoggingNested<A> withNewInlineLogging() {
    return new InlineLoggingNested(null);
  }
  public InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item) {
    return new InlineLoggingNested(item);
  }
  public JvmOptions buildJvmOptions() {
    return this.jvmOptions!=null ?this.jvmOptions.build():null;
  }
  public A withJvmOptions(JvmOptions jvmOptions) {
    _visitables.get("jvmOptions").remove(this.jvmOptions);
    if (jvmOptions!=null){ this.jvmOptions= new JvmOptionsBuilder(jvmOptions); _visitables.get("jvmOptions").add(this.jvmOptions);} else { this.jvmOptions = null; _visitables.get("jvmOptions").remove(this.jvmOptions); } return (A) this;
  }
  public boolean hasJvmOptions() {
    return this.jvmOptions != null;
  }
  public JvmOptionsNested<A> withNewJvmOptions() {
    return new JvmOptionsNested(null);
  }
  public JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
    return new JvmOptionsNested(item);
  }
  public JvmOptionsNested<A> editJvmOptions() {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(null));
  }
  public JvmOptionsNested<A> editOrNewJvmOptions() {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(new JvmOptionsBuilder().build()));
  }
  public JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EntityTopicOperatorSpecFluent that = (EntityTopicOperatorSpecFluent) o;
    if (!java.util.Objects.equals(watchedNamespace, that.watchedNamespace)) return false;

    if (!java.util.Objects.equals(image, that.image)) return false;

    if (reconciliationIntervalSeconds != that.reconciliationIntervalSeconds) return false;
    if (zookeeperSessionTimeoutSeconds != that.zookeeperSessionTimeoutSeconds) return false;
    if (topicMetadataMaxAttempts != that.topicMetadataMaxAttempts) return false;
    if (!java.util.Objects.equals(startupProbe, that.startupProbe)) return false;

    if (!java.util.Objects.equals(livenessProbe, that.livenessProbe)) return false;

    if (!java.util.Objects.equals(readinessProbe, that.readinessProbe)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    if (!java.util.Objects.equals(logging, that.logging)) return false;

    if (!java.util.Objects.equals(jvmOptions, that.jvmOptions)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(watchedNamespace,  image,  reconciliationIntervalSeconds,  zookeeperSessionTimeoutSeconds,  topicMetadataMaxAttempts,  startupProbe,  livenessProbe,  readinessProbe,  resources,  logging,  jvmOptions,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (watchedNamespace != null) { sb.append("watchedNamespace:"); sb.append(watchedNamespace + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    sb.append("reconciliationIntervalSeconds:"); sb.append(reconciliationIntervalSeconds + ",");
    sb.append("zookeeperSessionTimeoutSeconds:"); sb.append(zookeeperSessionTimeoutSeconds + ",");
    sb.append("topicMetadataMaxAttempts:"); sb.append(topicMetadataMaxAttempts + ",");
    if (startupProbe != null) { sb.append("startupProbe:"); sb.append(startupProbe + ","); }
    if (livenessProbe != null) { sb.append("livenessProbe:"); sb.append(livenessProbe + ","); }
    if (readinessProbe != null) { sb.append("readinessProbe:"); sb.append(readinessProbe + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (logging != null) { sb.append("logging:"); sb.append(logging + ","); }
    if (jvmOptions != null) { sb.append("jvmOptions:"); sb.append(jvmOptions); }
    sb.append("}");
    return sb.toString();
  }
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.strimzi.api.kafka.model."+"ExternalLogging": return (VisitableBuilder<T, ?>)new ExternalLoggingBuilder((ExternalLogging) item);
    case "io.strimzi.api.kafka.model."+"InlineLogging": return (VisitableBuilder<T, ?>)new InlineLoggingBuilder((InlineLogging) item);
    }
 return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class StartupProbeNested<N> extends ProbeFluent<StartupProbeNested<N>> implements Nested<N>{
    StartupProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    public N and() {
      return (N) EntityTopicOperatorSpecFluent.this.withStartupProbe(builder.build());
    }
    public N endStartupProbe() {
      return and();
    }
    
  }
  public class LivenessProbeNested<N> extends ProbeFluent<LivenessProbeNested<N>> implements Nested<N>{
    LivenessProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    public N and() {
      return (N) EntityTopicOperatorSpecFluent.this.withLivenessProbe(builder.build());
    }
    public N endLivenessProbe() {
      return and();
    }
    
  }
  public class ReadinessProbeNested<N> extends ProbeFluent<ReadinessProbeNested<N>> implements Nested<N>{
    ReadinessProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    public N and() {
      return (N) EntityTopicOperatorSpecFluent.this.withReadinessProbe(builder.build());
    }
    public N endReadinessProbe() {
      return and();
    }
    
  }
  public class ExternalLoggingNested<N> extends ExternalLoggingFluent<ExternalLoggingNested<N>> implements Nested<N>{
    ExternalLoggingNested(ExternalLogging item) {
      this.builder = new ExternalLoggingBuilder(this, item);
    }
    ExternalLoggingBuilder builder;
    public N and() {
      return (N) EntityTopicOperatorSpecFluent.this.withLogging(builder.build());
    }
    public N endExternalLogging() {
      return and();
    }
    
  }
  public class InlineLoggingNested<N> extends InlineLoggingFluent<InlineLoggingNested<N>> implements Nested<N>{
    InlineLoggingNested(InlineLogging item) {
      this.builder = new InlineLoggingBuilder(this, item);
    }
    InlineLoggingBuilder builder;
    public N and() {
      return (N) EntityTopicOperatorSpecFluent.this.withLogging(builder.build());
    }
    public N endInlineLogging() {
      return and();
    }
    
  }
  public class JvmOptionsNested<N> extends JvmOptionsFluent<JvmOptionsNested<N>> implements Nested<N>{
    JvmOptionsNested(JvmOptions item) {
      this.builder = new JvmOptionsBuilder(this, item);
    }
    JvmOptionsBuilder builder;
    public N and() {
      return (N) EntityTopicOperatorSpecFluent.this.withJvmOptions(builder.build());
    }
    public N endJvmOptions() {
      return and();
    }
    
  }
  
}