package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JmxTransSpecBuilder extends JmxTransSpecFluent<JmxTransSpecBuilder> implements VisitableBuilder<JmxTransSpec,JmxTransSpecBuilder>{
  public JmxTransSpecBuilder() {
    this(false);
  }
  public JmxTransSpecBuilder(Boolean validationEnabled) {
    this(new JmxTransSpec(), validationEnabled);
  }
  public JmxTransSpecBuilder(JmxTransSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public JmxTransSpecBuilder(JmxTransSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JmxTransSpec(), validationEnabled);
  }
  public JmxTransSpecBuilder(JmxTransSpecFluent<?> fluent,JmxTransSpec instance) {
    this(fluent, instance, false);
  }
  public JmxTransSpecBuilder(JmxTransSpecFluent<?> fluent,JmxTransSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new JmxTransSpec());

    if (instance != null) {
      fluent.withImage(instance.getImage());
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withOutputDefinitions(instance.getOutputDefinitions());
      fluent.withKafkaQueries(instance.getKafkaQueries());
      fluent.withResources(instance.getResources());
      fluent.withTemplate(instance.getTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  public JmxTransSpecBuilder(JmxTransSpec instance) {
    this(instance,false);
  }
  public JmxTransSpecBuilder(JmxTransSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new JmxTransSpec());

    if (instance != null) {
      this.withImage(instance.getImage());
      this.withLogLevel(instance.getLogLevel());
      this.withOutputDefinitions(instance.getOutputDefinitions());
      this.withKafkaQueries(instance.getKafkaQueries());
      this.withResources(instance.getResources());
      this.withTemplate(instance.getTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  JmxTransSpecFluent<?> fluent;
  Boolean validationEnabled;
  public JmxTransSpec build() {
    JmxTransSpec buildable = new JmxTransSpec();
    buildable.setImage(fluent.getImage());
    buildable.setLogLevel(fluent.getLogLevel());
    buildable.setOutputDefinitions(fluent.buildOutputDefinitions());
    buildable.setKafkaQueries(fluent.buildKafkaQueries());
    buildable.setResources(fluent.getResources());
    buildable.setTemplate(fluent.buildTemplate());
    return buildable;
  }
  
}