package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaAuthorizationKeycloakFluent<A extends KafkaAuthorizationKeycloakFluent<A>> extends BaseFluent<A>{
  public KafkaAuthorizationKeycloakFluent() {
  }
  public KafkaAuthorizationKeycloakFluent(KafkaAuthorizationKeycloak instance) {
    instance = (instance != null ? instance : new KafkaAuthorizationKeycloak());

    if (instance != null) {
      this.withClientId(instance.getClientId());
      this.withTokenEndpointUri(instance.getTokenEndpointUri());
      this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
      this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
      this.withDelegateToKafkaAcls(instance.isDelegateToKafkaAcls());
      this.withGrantsRefreshPeriodSeconds(instance.getGrantsRefreshPeriodSeconds());
      this.withGrantsRefreshPoolSize(instance.getGrantsRefreshPoolSize());
      this.withGrantsMaxIdleTimeSeconds(instance.getGrantsMaxIdleTimeSeconds());
      this.withGrantsGcPeriodSeconds(instance.getGrantsGcPeriodSeconds());
      this.withGrantsAlwaysLatest(instance.isGrantsAlwaysLatest());
      this.withConnectTimeoutSeconds(instance.getConnectTimeoutSeconds());
      this.withReadTimeoutSeconds(instance.getReadTimeoutSeconds());
      this.withHttpRetries(instance.getHttpRetries());
      this.withSuperUsers(instance.getSuperUsers());
      this.withEnableMetrics(instance.isEnableMetrics());
      this.withIncludeAcceptHeader(instance.isIncludeAcceptHeader());
    }
  }
  private String clientId;
  private String tokenEndpointUri;
  private ArrayList<CertSecretSourceBuilder> tlsTrustedCertificates;
  private boolean disableTlsHostnameVerification;
  private boolean delegateToKafkaAcls;
  private Integer grantsRefreshPeriodSeconds;
  private Integer grantsRefreshPoolSize;
  private Integer grantsMaxIdleTimeSeconds;
  private Integer grantsGcPeriodSeconds;
  private boolean grantsAlwaysLatest;
  private Integer connectTimeoutSeconds;
  private Integer readTimeoutSeconds;
  private Integer httpRetries;
  private List<String> superUsers;
  private boolean enableMetrics;
  private boolean includeAcceptHeader;
  public String getClientId() {
    return this.clientId;
  }
  public A withClientId(String clientId) {
    this.clientId=clientId; return (A) this;
  }
  public boolean hasClientId() {
    return this.clientId != null;
  }
  public String getTokenEndpointUri() {
    return this.tokenEndpointUri;
  }
  public A withTokenEndpointUri(String tokenEndpointUri) {
    this.tokenEndpointUri=tokenEndpointUri; return (A) this;
  }
  public boolean hasTokenEndpointUri() {
    return this.tokenEndpointUri != null;
  }
  public A addToTlsTrustedCertificates(int index,CertSecretSource item) {
    if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
    CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
    if (index < 0 || index >= tlsTrustedCertificates.size()) { _visitables.get("tlsTrustedCertificates").add(builder); tlsTrustedCertificates.add(builder); } else { _visitables.get("tlsTrustedCertificates").add(index, builder); tlsTrustedCertificates.add(index, builder);}
    return (A)this;
  }
  public A setToTlsTrustedCertificates(int index,CertSecretSource item) {
    if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
    CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
    if (index < 0 || index >= tlsTrustedCertificates.size()) { _visitables.get("tlsTrustedCertificates").add(builder); tlsTrustedCertificates.add(builder); } else { _visitables.get("tlsTrustedCertificates").set(index, builder); tlsTrustedCertificates.set(index, builder);}
    return (A)this;
  }
  public A addToTlsTrustedCertificates(io.strimzi.api.kafka.model.CertSecretSource... items) {
    if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
    for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(builder);this.tlsTrustedCertificates.add(builder);} return (A)this;
  }
  public A addAllToTlsTrustedCertificates(Collection<CertSecretSource> items) {
    if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
    for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(builder);this.tlsTrustedCertificates.add(builder);} return (A)this;
  }
  public A removeFromTlsTrustedCertificates(io.strimzi.api.kafka.model.CertSecretSource... items) {
    if (this.tlsTrustedCertificates == null) return (A)this;
    for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").remove(builder); this.tlsTrustedCertificates.remove(builder);} return (A)this;
  }
  public A removeAllFromTlsTrustedCertificates(Collection<CertSecretSource> items) {
    if (this.tlsTrustedCertificates == null) return (A)this;
    for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").remove(builder); this.tlsTrustedCertificates.remove(builder);} return (A)this;
  }
  public A removeMatchingFromTlsTrustedCertificates(Predicate<CertSecretSourceBuilder> predicate) {
    if (tlsTrustedCertificates == null) return (A) this;
    final Iterator<CertSecretSourceBuilder> each = tlsTrustedCertificates.iterator();
    final List visitables = _visitables.get("tlsTrustedCertificates");
    while (each.hasNext()) {
      CertSecretSourceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<CertSecretSource> buildTlsTrustedCertificates() {
    return tlsTrustedCertificates != null ? build(tlsTrustedCertificates) : null;
  }
  public CertSecretSource buildTlsTrustedCertificate(int index) {
    return this.tlsTrustedCertificates.get(index).build();
  }
  public CertSecretSource buildFirstTlsTrustedCertificate() {
    return this.tlsTrustedCertificates.get(0).build();
  }
  public CertSecretSource buildLastTlsTrustedCertificate() {
    return this.tlsTrustedCertificates.get(tlsTrustedCertificates.size() - 1).build();
  }
  public CertSecretSource buildMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
    for (CertSecretSourceBuilder item: tlsTrustedCertificates) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
    for (CertSecretSourceBuilder item: tlsTrustedCertificates) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTlsTrustedCertificates(List<CertSecretSource> tlsTrustedCertificates) {
    if (this.tlsTrustedCertificates != null) { _visitables.get("tlsTrustedCertificates").clear();}
    if (tlsTrustedCertificates != null) {this.tlsTrustedCertificates = new ArrayList(); for (CertSecretSource item : tlsTrustedCertificates){this.addToTlsTrustedCertificates(item);}} else { this.tlsTrustedCertificates = null;} return (A) this;
  }
  public A withTlsTrustedCertificates(io.strimzi.api.kafka.model.CertSecretSource... tlsTrustedCertificates) {
    if (this.tlsTrustedCertificates != null) {this.tlsTrustedCertificates.clear(); _visitables.remove("tlsTrustedCertificates"); }
    if (tlsTrustedCertificates != null) {for (CertSecretSource item :tlsTrustedCertificates){ this.addToTlsTrustedCertificates(item);}} return (A) this;
  }
  public boolean hasTlsTrustedCertificates() {
    return tlsTrustedCertificates != null && !tlsTrustedCertificates.isEmpty();
  }
  public TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificate() {
    return new TlsTrustedCertificatesNested(-1, null);
  }
  public TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificateLike(CertSecretSource item) {
    return new TlsTrustedCertificatesNested(-1, item);
  }
  public TlsTrustedCertificatesNested<A> setNewTlsTrustedCertificateLike(int index,CertSecretSource item) {
    return new TlsTrustedCertificatesNested(index, item);
  }
  public TlsTrustedCertificatesNested<A> editTlsTrustedCertificate(int index) {
    if (tlsTrustedCertificates.size() <= index) throw new RuntimeException("Can't edit tlsTrustedCertificates. Index exceeds size.");
    return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
  }
  public TlsTrustedCertificatesNested<A> editFirstTlsTrustedCertificate() {
    if (tlsTrustedCertificates.size() == 0) throw new RuntimeException("Can't edit first tlsTrustedCertificates. The list is empty.");
    return setNewTlsTrustedCertificateLike(0, buildTlsTrustedCertificate(0));
  }
  public TlsTrustedCertificatesNested<A> editLastTlsTrustedCertificate() {
    int index = tlsTrustedCertificates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last tlsTrustedCertificates. The list is empty.");
    return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
  }
  public TlsTrustedCertificatesNested<A> editMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<tlsTrustedCertificates.size();i++) { 
    if (predicate.test(tlsTrustedCertificates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching tlsTrustedCertificates. No match found.");
    return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
  }
  public boolean isDisableTlsHostnameVerification() {
    return this.disableTlsHostnameVerification;
  }
  public A withDisableTlsHostnameVerification(boolean disableTlsHostnameVerification) {
    this.disableTlsHostnameVerification=disableTlsHostnameVerification; return (A) this;
  }
  public boolean hasDisableTlsHostnameVerification() {
    return true;
  }
  public boolean isDelegateToKafkaAcls() {
    return this.delegateToKafkaAcls;
  }
  public A withDelegateToKafkaAcls(boolean delegateToKafkaAcls) {
    this.delegateToKafkaAcls=delegateToKafkaAcls; return (A) this;
  }
  public boolean hasDelegateToKafkaAcls() {
    return true;
  }
  public Integer getGrantsRefreshPeriodSeconds() {
    return this.grantsRefreshPeriodSeconds;
  }
  public A withGrantsRefreshPeriodSeconds(Integer grantsRefreshPeriodSeconds) {
    this.grantsRefreshPeriodSeconds=grantsRefreshPeriodSeconds; return (A) this;
  }
  public boolean hasGrantsRefreshPeriodSeconds() {
    return this.grantsRefreshPeriodSeconds != null;
  }
  public Integer getGrantsRefreshPoolSize() {
    return this.grantsRefreshPoolSize;
  }
  public A withGrantsRefreshPoolSize(Integer grantsRefreshPoolSize) {
    this.grantsRefreshPoolSize=grantsRefreshPoolSize; return (A) this;
  }
  public boolean hasGrantsRefreshPoolSize() {
    return this.grantsRefreshPoolSize != null;
  }
  public Integer getGrantsMaxIdleTimeSeconds() {
    return this.grantsMaxIdleTimeSeconds;
  }
  public A withGrantsMaxIdleTimeSeconds(Integer grantsMaxIdleTimeSeconds) {
    this.grantsMaxIdleTimeSeconds=grantsMaxIdleTimeSeconds; return (A) this;
  }
  public boolean hasGrantsMaxIdleTimeSeconds() {
    return this.grantsMaxIdleTimeSeconds != null;
  }
  public Integer getGrantsGcPeriodSeconds() {
    return this.grantsGcPeriodSeconds;
  }
  public A withGrantsGcPeriodSeconds(Integer grantsGcPeriodSeconds) {
    this.grantsGcPeriodSeconds=grantsGcPeriodSeconds; return (A) this;
  }
  public boolean hasGrantsGcPeriodSeconds() {
    return this.grantsGcPeriodSeconds != null;
  }
  public boolean isGrantsAlwaysLatest() {
    return this.grantsAlwaysLatest;
  }
  public A withGrantsAlwaysLatest(boolean grantsAlwaysLatest) {
    this.grantsAlwaysLatest=grantsAlwaysLatest; return (A) this;
  }
  public boolean hasGrantsAlwaysLatest() {
    return true;
  }
  public Integer getConnectTimeoutSeconds() {
    return this.connectTimeoutSeconds;
  }
  public A withConnectTimeoutSeconds(Integer connectTimeoutSeconds) {
    this.connectTimeoutSeconds=connectTimeoutSeconds; return (A) this;
  }
  public boolean hasConnectTimeoutSeconds() {
    return this.connectTimeoutSeconds != null;
  }
  public Integer getReadTimeoutSeconds() {
    return this.readTimeoutSeconds;
  }
  public A withReadTimeoutSeconds(Integer readTimeoutSeconds) {
    this.readTimeoutSeconds=readTimeoutSeconds; return (A) this;
  }
  public boolean hasReadTimeoutSeconds() {
    return this.readTimeoutSeconds != null;
  }
  public Integer getHttpRetries() {
    return this.httpRetries;
  }
  public A withHttpRetries(Integer httpRetries) {
    this.httpRetries=httpRetries; return (A) this;
  }
  public boolean hasHttpRetries() {
    return this.httpRetries != null;
  }
  public A addToSuperUsers(int index,String item) {
    if (this.superUsers == null) {this.superUsers = new ArrayList<String>();}
    this.superUsers.add(index, item);
    return (A)this;
  }
  public A setToSuperUsers(int index,String item) {
    if (this.superUsers == null) {this.superUsers = new ArrayList<String>();}
    this.superUsers.set(index, item); return (A)this;
  }
  public A addToSuperUsers(java.lang.String... items) {
    if (this.superUsers == null) {this.superUsers = new ArrayList<String>();}
    for (String item : items) {this.superUsers.add(item);} return (A)this;
  }
  public A addAllToSuperUsers(Collection<String> items) {
    if (this.superUsers == null) {this.superUsers = new ArrayList<String>();}
    for (String item : items) {this.superUsers.add(item);} return (A)this;
  }
  public A removeFromSuperUsers(java.lang.String... items) {
    if (this.superUsers == null) return (A)this;
    for (String item : items) { this.superUsers.remove(item);} return (A)this;
  }
  public A removeAllFromSuperUsers(Collection<String> items) {
    if (this.superUsers == null) return (A)this;
    for (String item : items) { this.superUsers.remove(item);} return (A)this;
  }
  public List<String> getSuperUsers() {
    return this.superUsers;
  }
  public String getSuperUser(int index) {
    return this.superUsers.get(index);
  }
  public String getFirstSuperUser() {
    return this.superUsers.get(0);
  }
  public String getLastSuperUser() {
    return this.superUsers.get(superUsers.size() - 1);
  }
  public String getMatchingSuperUser(Predicate<String> predicate) {
    for (String item: superUsers) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingSuperUser(Predicate<String> predicate) {
    for (String item: superUsers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSuperUsers(List<String> superUsers) {
    if (superUsers != null) {this.superUsers = new ArrayList(); for (String item : superUsers){this.addToSuperUsers(item);}} else { this.superUsers = null;} return (A) this;
  }
  public A withSuperUsers(java.lang.String... superUsers) {
    if (this.superUsers != null) {this.superUsers.clear(); _visitables.remove("superUsers"); }
    if (superUsers != null) {for (String item :superUsers){ this.addToSuperUsers(item);}} return (A) this;
  }
  public boolean hasSuperUsers() {
    return superUsers != null && !superUsers.isEmpty();
  }
  public boolean isEnableMetrics() {
    return this.enableMetrics;
  }
  public A withEnableMetrics(boolean enableMetrics) {
    this.enableMetrics=enableMetrics; return (A) this;
  }
  public boolean hasEnableMetrics() {
    return true;
  }
  public boolean isIncludeAcceptHeader() {
    return this.includeAcceptHeader;
  }
  public A withIncludeAcceptHeader(boolean includeAcceptHeader) {
    this.includeAcceptHeader=includeAcceptHeader; return (A) this;
  }
  public boolean hasIncludeAcceptHeader() {
    return true;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaAuthorizationKeycloakFluent that = (KafkaAuthorizationKeycloakFluent) o;
    if (!java.util.Objects.equals(clientId, that.clientId)) return false;

    if (!java.util.Objects.equals(tokenEndpointUri, that.tokenEndpointUri)) return false;

    if (!java.util.Objects.equals(tlsTrustedCertificates, that.tlsTrustedCertificates)) return false;

    if (disableTlsHostnameVerification != that.disableTlsHostnameVerification) return false;
    if (delegateToKafkaAcls != that.delegateToKafkaAcls) return false;
    if (!java.util.Objects.equals(grantsRefreshPeriodSeconds, that.grantsRefreshPeriodSeconds)) return false;

    if (!java.util.Objects.equals(grantsRefreshPoolSize, that.grantsRefreshPoolSize)) return false;

    if (!java.util.Objects.equals(grantsMaxIdleTimeSeconds, that.grantsMaxIdleTimeSeconds)) return false;

    if (!java.util.Objects.equals(grantsGcPeriodSeconds, that.grantsGcPeriodSeconds)) return false;

    if (grantsAlwaysLatest != that.grantsAlwaysLatest) return false;
    if (!java.util.Objects.equals(connectTimeoutSeconds, that.connectTimeoutSeconds)) return false;

    if (!java.util.Objects.equals(readTimeoutSeconds, that.readTimeoutSeconds)) return false;

    if (!java.util.Objects.equals(httpRetries, that.httpRetries)) return false;

    if (!java.util.Objects.equals(superUsers, that.superUsers)) return false;

    if (enableMetrics != that.enableMetrics) return false;
    if (includeAcceptHeader != that.includeAcceptHeader) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clientId,  tokenEndpointUri,  tlsTrustedCertificates,  disableTlsHostnameVerification,  delegateToKafkaAcls,  grantsRefreshPeriodSeconds,  grantsRefreshPoolSize,  grantsMaxIdleTimeSeconds,  grantsGcPeriodSeconds,  grantsAlwaysLatest,  connectTimeoutSeconds,  readTimeoutSeconds,  httpRetries,  superUsers,  enableMetrics,  includeAcceptHeader,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clientId != null) { sb.append("clientId:"); sb.append(clientId + ","); }
    if (tokenEndpointUri != null) { sb.append("tokenEndpointUri:"); sb.append(tokenEndpointUri + ","); }
    if (tlsTrustedCertificates != null && !tlsTrustedCertificates.isEmpty()) { sb.append("tlsTrustedCertificates:"); sb.append(tlsTrustedCertificates + ","); }
    sb.append("disableTlsHostnameVerification:"); sb.append(disableTlsHostnameVerification + ",");
    sb.append("delegateToKafkaAcls:"); sb.append(delegateToKafkaAcls + ",");
    if (grantsRefreshPeriodSeconds != null) { sb.append("grantsRefreshPeriodSeconds:"); sb.append(grantsRefreshPeriodSeconds + ","); }
    if (grantsRefreshPoolSize != null) { sb.append("grantsRefreshPoolSize:"); sb.append(grantsRefreshPoolSize + ","); }
    if (grantsMaxIdleTimeSeconds != null) { sb.append("grantsMaxIdleTimeSeconds:"); sb.append(grantsMaxIdleTimeSeconds + ","); }
    if (grantsGcPeriodSeconds != null) { sb.append("grantsGcPeriodSeconds:"); sb.append(grantsGcPeriodSeconds + ","); }
    sb.append("grantsAlwaysLatest:"); sb.append(grantsAlwaysLatest + ",");
    if (connectTimeoutSeconds != null) { sb.append("connectTimeoutSeconds:"); sb.append(connectTimeoutSeconds + ","); }
    if (readTimeoutSeconds != null) { sb.append("readTimeoutSeconds:"); sb.append(readTimeoutSeconds + ","); }
    if (httpRetries != null) { sb.append("httpRetries:"); sb.append(httpRetries + ","); }
    if (superUsers != null && !superUsers.isEmpty()) { sb.append("superUsers:"); sb.append(superUsers + ","); }
    sb.append("enableMetrics:"); sb.append(enableMetrics + ",");
    sb.append("includeAcceptHeader:"); sb.append(includeAcceptHeader);
    sb.append("}");
    return sb.toString();
  }
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.strimzi.api.kafka.model."+"CertAndKeySecretSource": return (VisitableBuilder<T, ?>)new io.strimzi.api.kafka.model.CertAndKeySecretSourceBuilder((io.strimzi.api.kafka.model.CertAndKeySecretSource) item);
    }
 return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public A withDisableTlsHostnameVerification() {
    return withDisableTlsHostnameVerification(true);
  }
  public A withDelegateToKafkaAcls() {
    return withDelegateToKafkaAcls(true);
  }
  public A withGrantsAlwaysLatest() {
    return withGrantsAlwaysLatest(true);
  }
  public A withEnableMetrics() {
    return withEnableMetrics(true);
  }
  public A withIncludeAcceptHeader() {
    return withIncludeAcceptHeader(true);
  }
  public class TlsTrustedCertificatesNested<N> extends CertSecretSourceFluent<TlsTrustedCertificatesNested<N>> implements Nested<N>{
    TlsTrustedCertificatesNested(int index,CertSecretSource item) {
      this.index = index;
      this.builder = new CertSecretSourceBuilder(this, item);
    }
    CertSecretSourceBuilder builder;
    int index;
    public N and() {
      return (N) KafkaAuthorizationKeycloakFluent.this.setToTlsTrustedCertificates(index,builder.build());
    }
    public N endTlsTrustedCertificate() {
      return and();
    }
    
  }
  
}