package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaAuthorizationOpaBuilder extends KafkaAuthorizationOpaFluent<KafkaAuthorizationOpaBuilder> implements VisitableBuilder<KafkaAuthorizationOpa,KafkaAuthorizationOpaBuilder>{
  public KafkaAuthorizationOpaBuilder() {
    this(false);
  }
  public KafkaAuthorizationOpaBuilder(Boolean validationEnabled) {
    this(new KafkaAuthorizationOpa(), validationEnabled);
  }
  public KafkaAuthorizationOpaBuilder(KafkaAuthorizationOpaFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaAuthorizationOpaBuilder(KafkaAuthorizationOpaFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaAuthorizationOpa(), validationEnabled);
  }
  public KafkaAuthorizationOpaBuilder(KafkaAuthorizationOpaFluent<?> fluent,KafkaAuthorizationOpa instance) {
    this(fluent, instance, false);
  }
  public KafkaAuthorizationOpaBuilder(KafkaAuthorizationOpaFluent<?> fluent,KafkaAuthorizationOpa instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaAuthorizationOpa());

    if (instance != null) {
      fluent.withSuperUsers(instance.getSuperUsers());
      fluent.withUrl(instance.getUrl());
      fluent.withAllowOnError(instance.isAllowOnError());
      fluent.withInitialCacheCapacity(instance.getInitialCacheCapacity());
      fluent.withMaximumCacheSize(instance.getMaximumCacheSize());
      fluent.withExpireAfterMs(instance.getExpireAfterMs());
      fluent.withEnableMetrics(instance.isEnableMetrics());
      fluent.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaAuthorizationOpaBuilder(KafkaAuthorizationOpa instance) {
    this(instance,false);
  }
  public KafkaAuthorizationOpaBuilder(KafkaAuthorizationOpa instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaAuthorizationOpa());

    if (instance != null) {
      this.withSuperUsers(instance.getSuperUsers());
      this.withUrl(instance.getUrl());
      this.withAllowOnError(instance.isAllowOnError());
      this.withInitialCacheCapacity(instance.getInitialCacheCapacity());
      this.withMaximumCacheSize(instance.getMaximumCacheSize());
      this.withExpireAfterMs(instance.getExpireAfterMs());
      this.withEnableMetrics(instance.isEnableMetrics());
      this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaAuthorizationOpaFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaAuthorizationOpa build() {
    KafkaAuthorizationOpa buildable = new KafkaAuthorizationOpa();
    buildable.setSuperUsers(fluent.getSuperUsers());
    buildable.setUrl(fluent.getUrl());
    buildable.setAllowOnError(fluent.isAllowOnError());
    buildable.setInitialCacheCapacity(fluent.getInitialCacheCapacity());
    buildable.setMaximumCacheSize(fluent.getMaximumCacheSize());
    buildable.setExpireAfterMs(fluent.getExpireAfterMs());
    buildable.setEnableMetrics(fluent.isEnableMetrics());
    buildable.setTlsTrustedCertificates(fluent.buildTlsTrustedCertificates());
    return buildable;
  }
  
}