package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaAuthorizationSimpleBuilder extends KafkaAuthorizationSimpleFluent<KafkaAuthorizationSimpleBuilder> implements VisitableBuilder<KafkaAuthorizationSimple,KafkaAuthorizationSimpleBuilder>{
  public KafkaAuthorizationSimpleBuilder() {
    this(false);
  }
  public KafkaAuthorizationSimpleBuilder(Boolean validationEnabled) {
    this(new KafkaAuthorizationSimple(), validationEnabled);
  }
  public KafkaAuthorizationSimpleBuilder(KafkaAuthorizationSimpleFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaAuthorizationSimpleBuilder(KafkaAuthorizationSimpleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaAuthorizationSimple(), validationEnabled);
  }
  public KafkaAuthorizationSimpleBuilder(KafkaAuthorizationSimpleFluent<?> fluent,KafkaAuthorizationSimple instance) {
    this(fluent, instance, false);
  }
  public KafkaAuthorizationSimpleBuilder(KafkaAuthorizationSimpleFluent<?> fluent,KafkaAuthorizationSimple instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaAuthorizationSimple());

    if (instance != null) {
      fluent.withSuperUsers(instance.getSuperUsers());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaAuthorizationSimpleBuilder(KafkaAuthorizationSimple instance) {
    this(instance,false);
  }
  public KafkaAuthorizationSimpleBuilder(KafkaAuthorizationSimple instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaAuthorizationSimple());

    if (instance != null) {
      this.withSuperUsers(instance.getSuperUsers());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaAuthorizationSimpleFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaAuthorizationSimple build() {
    KafkaAuthorizationSimple buildable = new KafkaAuthorizationSimple();
    buildable.setSuperUsers(fluent.getSuperUsers());
    return buildable;
  }
  
}