package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaBridgeAdminClientSpecBuilder extends KafkaBridgeAdminClientSpecFluent<KafkaBridgeAdminClientSpecBuilder> implements VisitableBuilder<KafkaBridgeAdminClientSpec,KafkaBridgeAdminClientSpecBuilder>{
  public KafkaBridgeAdminClientSpecBuilder() {
    this(false);
  }
  public KafkaBridgeAdminClientSpecBuilder(Boolean validationEnabled) {
    this(new KafkaBridgeAdminClientSpec(), validationEnabled);
  }
  public KafkaBridgeAdminClientSpecBuilder(KafkaBridgeAdminClientSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaBridgeAdminClientSpecBuilder(KafkaBridgeAdminClientSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaBridgeAdminClientSpec(), validationEnabled);
  }
  public KafkaBridgeAdminClientSpecBuilder(KafkaBridgeAdminClientSpecFluent<?> fluent,KafkaBridgeAdminClientSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaBridgeAdminClientSpecBuilder(KafkaBridgeAdminClientSpecFluent<?> fluent,KafkaBridgeAdminClientSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaBridgeAdminClientSpec());

    if (instance != null) {
      fluent.withConfig(instance.getConfig());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaBridgeAdminClientSpecBuilder(KafkaBridgeAdminClientSpec instance) {
    this(instance,false);
  }
  public KafkaBridgeAdminClientSpecBuilder(KafkaBridgeAdminClientSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaBridgeAdminClientSpec());

    if (instance != null) {
      this.withConfig(instance.getConfig());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaBridgeAdminClientSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaBridgeAdminClientSpec build() {
    KafkaBridgeAdminClientSpec buildable = new KafkaBridgeAdminClientSpec();
    buildable.setConfig(fluent.getConfig());
    return buildable;
  }
  
}