package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaBridgeBuilder extends KafkaBridgeFluent<KafkaBridgeBuilder> implements VisitableBuilder<KafkaBridge,KafkaBridgeBuilder>{
  public KafkaBridgeBuilder() {
    this(false);
  }
  public KafkaBridgeBuilder(Boolean validationEnabled) {
    this(new KafkaBridge(), validationEnabled);
  }
  public KafkaBridgeBuilder(KafkaBridgeFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaBridgeBuilder(KafkaBridgeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaBridge(), validationEnabled);
  }
  public KafkaBridgeBuilder(KafkaBridgeFluent<?> fluent,KafkaBridge instance) {
    this(fluent, instance, false);
  }
  public KafkaBridgeBuilder(KafkaBridgeFluent<?> fluent,KafkaBridge instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaBridge());

    if (instance != null) {
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaBridgeBuilder(KafkaBridge instance) {
    this(instance,false);
  }
  public KafkaBridgeBuilder(KafkaBridge instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaBridge());

    if (instance != null) {
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaBridgeFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaBridge build() {
    KafkaBridge buildable = new KafkaBridge(fluent.buildSpec(),fluent.buildStatus());
    buildable.setApiVersion(fluent.getApiVersion());
    buildable.setKind(fluent.getKind());
    buildable.setMetadata(fluent.buildMetadata());
    return buildable;
  }
  
}