package io.strimzi.api.kafka.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.function.Predicate;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaBridgeHttpCorsFluent<A extends KafkaBridgeHttpCorsFluent<A>> extends BaseFluent<A>{
  public KafkaBridgeHttpCorsFluent() {
  }
  public KafkaBridgeHttpCorsFluent(KafkaBridgeHttpCors instance) {
    instance = (instance != null ? instance : new KafkaBridgeHttpCors());

    if (instance != null) {
      this.withAllowedOrigins(instance.getAllowedOrigins());
      this.withAllowedMethods(instance.getAllowedMethods());
    }
  }
  private List<String> allowedOrigins;
  private List<String> allowedMethods;
  public A addToAllowedOrigins(int index,String item) {
    if (this.allowedOrigins == null) {this.allowedOrigins = new ArrayList<String>();}
    this.allowedOrigins.add(index, item);
    return (A)this;
  }
  public A setToAllowedOrigins(int index,String item) {
    if (this.allowedOrigins == null) {this.allowedOrigins = new ArrayList<String>();}
    this.allowedOrigins.set(index, item); return (A)this;
  }
  public A addToAllowedOrigins(java.lang.String... items) {
    if (this.allowedOrigins == null) {this.allowedOrigins = new ArrayList<String>();}
    for (String item : items) {this.allowedOrigins.add(item);} return (A)this;
  }
  public A addAllToAllowedOrigins(Collection<String> items) {
    if (this.allowedOrigins == null) {this.allowedOrigins = new ArrayList<String>();}
    for (String item : items) {this.allowedOrigins.add(item);} return (A)this;
  }
  public A removeFromAllowedOrigins(java.lang.String... items) {
    if (this.allowedOrigins == null) return (A)this;
    for (String item : items) { this.allowedOrigins.remove(item);} return (A)this;
  }
  public A removeAllFromAllowedOrigins(Collection<String> items) {
    if (this.allowedOrigins == null) return (A)this;
    for (String item : items) { this.allowedOrigins.remove(item);} return (A)this;
  }
  public List<String> getAllowedOrigins() {
    return this.allowedOrigins;
  }
  public String getAllowedOrigin(int index) {
    return this.allowedOrigins.get(index);
  }
  public String getFirstAllowedOrigin() {
    return this.allowedOrigins.get(0);
  }
  public String getLastAllowedOrigin() {
    return this.allowedOrigins.get(allowedOrigins.size() - 1);
  }
  public String getMatchingAllowedOrigin(Predicate<String> predicate) {
    for (String item: allowedOrigins) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingAllowedOrigin(Predicate<String> predicate) {
    for (String item: allowedOrigins) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowedOrigins(List<String> allowedOrigins) {
    if (allowedOrigins != null) {this.allowedOrigins = new ArrayList(); for (String item : allowedOrigins){this.addToAllowedOrigins(item);}} else { this.allowedOrigins = null;} return (A) this;
  }
  public A withAllowedOrigins(java.lang.String... allowedOrigins) {
    if (this.allowedOrigins != null) {this.allowedOrigins.clear(); _visitables.remove("allowedOrigins"); }
    if (allowedOrigins != null) {for (String item :allowedOrigins){ this.addToAllowedOrigins(item);}} return (A) this;
  }
  public boolean hasAllowedOrigins() {
    return allowedOrigins != null && !allowedOrigins.isEmpty();
  }
  public A addToAllowedMethods(int index,String item) {
    if (this.allowedMethods == null) {this.allowedMethods = new ArrayList<String>();}
    this.allowedMethods.add(index, item);
    return (A)this;
  }
  public A setToAllowedMethods(int index,String item) {
    if (this.allowedMethods == null) {this.allowedMethods = new ArrayList<String>();}
    this.allowedMethods.set(index, item); return (A)this;
  }
  public A addToAllowedMethods(java.lang.String... items) {
    if (this.allowedMethods == null) {this.allowedMethods = new ArrayList<String>();}
    for (String item : items) {this.allowedMethods.add(item);} return (A)this;
  }
  public A addAllToAllowedMethods(Collection<String> items) {
    if (this.allowedMethods == null) {this.allowedMethods = new ArrayList<String>();}
    for (String item : items) {this.allowedMethods.add(item);} return (A)this;
  }
  public A removeFromAllowedMethods(java.lang.String... items) {
    if (this.allowedMethods == null) return (A)this;
    for (String item : items) { this.allowedMethods.remove(item);} return (A)this;
  }
  public A removeAllFromAllowedMethods(Collection<String> items) {
    if (this.allowedMethods == null) return (A)this;
    for (String item : items) { this.allowedMethods.remove(item);} return (A)this;
  }
  public List<String> getAllowedMethods() {
    return this.allowedMethods;
  }
  public String getAllowedMethod(int index) {
    return this.allowedMethods.get(index);
  }
  public String getFirstAllowedMethod() {
    return this.allowedMethods.get(0);
  }
  public String getLastAllowedMethod() {
    return this.allowedMethods.get(allowedMethods.size() - 1);
  }
  public String getMatchingAllowedMethod(Predicate<String> predicate) {
    for (String item: allowedMethods) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingAllowedMethod(Predicate<String> predicate) {
    for (String item: allowedMethods) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowedMethods(List<String> allowedMethods) {
    if (allowedMethods != null) {this.allowedMethods = new ArrayList(); for (String item : allowedMethods){this.addToAllowedMethods(item);}} else { this.allowedMethods = null;} return (A) this;
  }
  public A withAllowedMethods(java.lang.String... allowedMethods) {
    if (this.allowedMethods != null) {this.allowedMethods.clear(); _visitables.remove("allowedMethods"); }
    if (allowedMethods != null) {for (String item :allowedMethods){ this.addToAllowedMethods(item);}} return (A) this;
  }
  public boolean hasAllowedMethods() {
    return allowedMethods != null && !allowedMethods.isEmpty();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaBridgeHttpCorsFluent that = (KafkaBridgeHttpCorsFluent) o;
    if (!java.util.Objects.equals(allowedOrigins, that.allowedOrigins)) return false;

    if (!java.util.Objects.equals(allowedMethods, that.allowedMethods)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(allowedOrigins,  allowedMethods,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allowedOrigins != null && !allowedOrigins.isEmpty()) { sb.append("allowedOrigins:"); sb.append(allowedOrigins + ","); }
    if (allowedMethods != null && !allowedMethods.isEmpty()) { sb.append("allowedMethods:"); sb.append(allowedMethods); }
    sb.append("}");
    return sb.toString();
  }
  
}