package io.strimzi.api.kafka.model;

import java.lang.String;
import io.strimzi.api.kafka.model.tracing.OpenTelemetryTracing;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Builder;
import java.lang.Object;
import io.strimzi.api.kafka.model.tracing.Tracing;
import io.strimzi.api.kafka.model.tracing.OpenTelemetryTracingBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.tracing.OpenTelemetryTracingFluent;
import io.strimzi.api.kafka.model.template.KafkaBridgeTemplate;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent;
import io.strimzi.api.kafka.model.tracing.JaegerTracingFluent;
import io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent;
import io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain;
import io.strimzi.api.kafka.model.tracing.JaegerTracing;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent;
import io.strimzi.api.kafka.model.template.KafkaBridgeTemplateBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Fluent;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaBridgeSpecFluent<A extends KafkaBridgeSpecFluent<A>> extends SpecFluent<A>{
  public KafkaBridgeSpecFluent() {
  }
  public KafkaBridgeSpecFluent(KafkaBridgeSpec instance) {
    instance = (instance != null ? instance : new KafkaBridgeSpec());

    if (instance != null) {
      this.withReplicas(instance.getReplicas());
      this.withImage(instance.getImage());
      this.withHttp(instance.getHttp());
      this.withBootstrapServers(instance.getBootstrapServers());
      this.withTls(instance.getTls());
      this.withAuthentication(instance.getAuthentication());
      this.withConsumer(instance.getConsumer());
      this.withProducer(instance.getProducer());
      this.withAdminClient(instance.getAdminClient());
      this.withResources(instance.getResources());
      this.withJvmOptions(instance.getJvmOptions());
      this.withLogging(instance.getLogging());
      this.withEnableMetrics(instance.getEnableMetrics());
      this.withLivenessProbe(instance.getLivenessProbe());
      this.withReadinessProbe(instance.getReadinessProbe());
      this.withTemplate(instance.getTemplate());
      this.withTracing(instance.getTracing());
      this.withClientRackInitImage(instance.getClientRackInitImage());
      this.withRack(instance.getRack());
    }
  }
  private int replicas;
  private String image;
  private KafkaBridgeHttpConfigBuilder http;
  private String bootstrapServers;
  private ClientTlsBuilder tls;
  private VisitableBuilder<? extends KafkaClientAuthentication,?> authentication;
  private KafkaBridgeConsumerSpecBuilder consumer;
  private KafkaBridgeProducerSpecBuilder producer;
  private KafkaBridgeAdminClientSpecBuilder adminClient;
  private ResourceRequirements resources;
  private JvmOptionsBuilder jvmOptions;
  private VisitableBuilder<? extends Logging,?> logging;
  private boolean enableMetrics;
  private ProbeBuilder livenessProbe;
  private ProbeBuilder readinessProbe;
  private KafkaBridgeTemplateBuilder template;
  private VisitableBuilder<? extends Tracing,?> tracing;
  private String clientRackInitImage;
  private RackBuilder rack;
  public int getReplicas() {
    return this.replicas;
  }
  public A withReplicas(int replicas) {
    this.replicas=replicas; return (A) this;
  }
  public boolean hasReplicas() {
    return true;
  }
  public String getImage() {
    return this.image;
  }
  public A withImage(String image) {
    this.image=image; return (A) this;
  }
  public boolean hasImage() {
    return this.image != null;
  }
  public KafkaBridgeHttpConfig buildHttp() {
    return this.http!=null ?this.http.build():null;
  }
  public A withHttp(KafkaBridgeHttpConfig http) {
    _visitables.get("http").remove(this.http);
    if (http!=null){ this.http= new KafkaBridgeHttpConfigBuilder(http); _visitables.get("http").add(this.http);} else { this.http = null; _visitables.get("http").remove(this.http); } return (A) this;
  }
  public boolean hasHttp() {
    return this.http != null;
  }
  public A withNewHttp(int port) {
    return (A)withHttp(new KafkaBridgeHttpConfig(port));
  }
  public HttpNested<A> withNewHttp() {
    return new HttpNested(null);
  }
  public HttpNested<A> withNewHttpLike(KafkaBridgeHttpConfig item) {
    return new HttpNested(item);
  }
  public HttpNested<A> editHttp() {
    return withNewHttpLike(java.util.Optional.ofNullable(buildHttp()).orElse(null));
  }
  public HttpNested<A> editOrNewHttp() {
    return withNewHttpLike(java.util.Optional.ofNullable(buildHttp()).orElse(new KafkaBridgeHttpConfigBuilder().build()));
  }
  public HttpNested<A> editOrNewHttpLike(KafkaBridgeHttpConfig item) {
    return withNewHttpLike(java.util.Optional.ofNullable(buildHttp()).orElse(item));
  }
  public String getBootstrapServers() {
    return this.bootstrapServers;
  }
  public A withBootstrapServers(String bootstrapServers) {
    this.bootstrapServers=bootstrapServers; return (A) this;
  }
  public boolean hasBootstrapServers() {
    return this.bootstrapServers != null;
  }
  public ClientTls buildTls() {
    return this.tls!=null ?this.tls.build():null;
  }
  public A withTls(ClientTls tls) {
    _visitables.get("tls").remove(this.tls);
    if (tls!=null){ this.tls= new ClientTlsBuilder(tls); _visitables.get("tls").add(this.tls);} else { this.tls = null; _visitables.get("tls").remove(this.tls); } return (A) this;
  }
  public boolean hasTls() {
    return this.tls != null;
  }
  public TlsNested<A> withNewTls() {
    return new TlsNested(null);
  }
  public TlsNested<A> withNewTlsLike(ClientTls item) {
    return new TlsNested(item);
  }
  public TlsNested<A> editTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(null));
  }
  public TlsNested<A> editOrNewTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(new ClientTlsBuilder().build()));
  }
  public TlsNested<A> editOrNewTlsLike(ClientTls item) {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(item));
  }
  public KafkaClientAuthentication buildAuthentication() {
    return this.authentication!=null?this.authentication.build():null;
  }
  public A withAuthentication(KafkaClientAuthentication authentication) {
    if (authentication==null){ this.authentication = null; _visitables.remove("authentication"); return (A) this;}
    VisitableBuilder<? extends KafkaClientAuthentication,?> builder = builder(authentication); _visitables.get("authentication").clear();_visitables.get("authentication").add(builder);this.authentication = builder;
    return (A) this;
  }
  public boolean hasAuthentication() {
    return this.authentication != null;
  }
  public KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512() {
    return new KafkaClientAuthenticationScramSha512Nested(null);
  }
  public KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512Like(KafkaClientAuthenticationScramSha512 item) {
    return new KafkaClientAuthenticationScramSha512Nested(item);
  }
  public KafkaClientAuthenticationScramSha256Nested<A> withNewKafkaClientAuthenticationScramSha256() {
    return new KafkaClientAuthenticationScramSha256Nested(null);
  }
  public KafkaClientAuthenticationScramSha256Nested<A> withNewKafkaClientAuthenticationScramSha256Like(KafkaClientAuthenticationScramSha256 item) {
    return new KafkaClientAuthenticationScramSha256Nested(item);
  }
  public KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlain() {
    return new KafkaClientAuthenticationPlainNested(null);
  }
  public KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlainLike(KafkaClientAuthenticationPlain item) {
    return new KafkaClientAuthenticationPlainNested(item);
  }
  public KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuth() {
    return new KafkaClientAuthenticationOAuthNested(null);
  }
  public KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuthLike(KafkaClientAuthenticationOAuth item) {
    return new KafkaClientAuthenticationOAuthNested(item);
  }
  public KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTls() {
    return new KafkaClientAuthenticationTlsNested(null);
  }
  public KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTlsLike(KafkaClientAuthenticationTls item) {
    return new KafkaClientAuthenticationTlsNested(item);
  }
  public KafkaBridgeConsumerSpec buildConsumer() {
    return this.consumer!=null ?this.consumer.build():null;
  }
  public A withConsumer(KafkaBridgeConsumerSpec consumer) {
    _visitables.get("consumer").remove(this.consumer);
    if (consumer!=null){ this.consumer= new KafkaBridgeConsumerSpecBuilder(consumer); _visitables.get("consumer").add(this.consumer);} else { this.consumer = null; _visitables.get("consumer").remove(this.consumer); } return (A) this;
  }
  public boolean hasConsumer() {
    return this.consumer != null;
  }
  public ConsumerNested<A> withNewConsumer() {
    return new ConsumerNested(null);
  }
  public ConsumerNested<A> withNewConsumerLike(KafkaBridgeConsumerSpec item) {
    return new ConsumerNested(item);
  }
  public ConsumerNested<A> editConsumer() {
    return withNewConsumerLike(java.util.Optional.ofNullable(buildConsumer()).orElse(null));
  }
  public ConsumerNested<A> editOrNewConsumer() {
    return withNewConsumerLike(java.util.Optional.ofNullable(buildConsumer()).orElse(new KafkaBridgeConsumerSpecBuilder().build()));
  }
  public ConsumerNested<A> editOrNewConsumerLike(KafkaBridgeConsumerSpec item) {
    return withNewConsumerLike(java.util.Optional.ofNullable(buildConsumer()).orElse(item));
  }
  public KafkaBridgeProducerSpec buildProducer() {
    return this.producer!=null ?this.producer.build():null;
  }
  public A withProducer(KafkaBridgeProducerSpec producer) {
    _visitables.get("producer").remove(this.producer);
    if (producer!=null){ this.producer= new KafkaBridgeProducerSpecBuilder(producer); _visitables.get("producer").add(this.producer);} else { this.producer = null; _visitables.get("producer").remove(this.producer); } return (A) this;
  }
  public boolean hasProducer() {
    return this.producer != null;
  }
  public ProducerNested<A> withNewProducer() {
    return new ProducerNested(null);
  }
  public ProducerNested<A> withNewProducerLike(KafkaBridgeProducerSpec item) {
    return new ProducerNested(item);
  }
  public ProducerNested<A> editProducer() {
    return withNewProducerLike(java.util.Optional.ofNullable(buildProducer()).orElse(null));
  }
  public ProducerNested<A> editOrNewProducer() {
    return withNewProducerLike(java.util.Optional.ofNullable(buildProducer()).orElse(new KafkaBridgeProducerSpecBuilder().build()));
  }
  public ProducerNested<A> editOrNewProducerLike(KafkaBridgeProducerSpec item) {
    return withNewProducerLike(java.util.Optional.ofNullable(buildProducer()).orElse(item));
  }
  public KafkaBridgeAdminClientSpec buildAdminClient() {
    return this.adminClient!=null ?this.adminClient.build():null;
  }
  public A withAdminClient(KafkaBridgeAdminClientSpec adminClient) {
    _visitables.get("adminClient").remove(this.adminClient);
    if (adminClient!=null){ this.adminClient= new KafkaBridgeAdminClientSpecBuilder(adminClient); _visitables.get("adminClient").add(this.adminClient);} else { this.adminClient = null; _visitables.get("adminClient").remove(this.adminClient); } return (A) this;
  }
  public boolean hasAdminClient() {
    return this.adminClient != null;
  }
  public AdminClientNested<A> withNewAdminClient() {
    return new AdminClientNested(null);
  }
  public AdminClientNested<A> withNewAdminClientLike(KafkaBridgeAdminClientSpec item) {
    return new AdminClientNested(item);
  }
  public AdminClientNested<A> editAdminClient() {
    return withNewAdminClientLike(java.util.Optional.ofNullable(buildAdminClient()).orElse(null));
  }
  public AdminClientNested<A> editOrNewAdminClient() {
    return withNewAdminClientLike(java.util.Optional.ofNullable(buildAdminClient()).orElse(new KafkaBridgeAdminClientSpecBuilder().build()));
  }
  public AdminClientNested<A> editOrNewAdminClientLike(KafkaBridgeAdminClientSpec item) {
    return withNewAdminClientLike(java.util.Optional.ofNullable(buildAdminClient()).orElse(item));
  }
  public ResourceRequirements getResources() {
    return this.resources;
  }
  public A withResources(ResourceRequirements resources) {
    this.resources=resources; return (A) this;
  }
  public boolean hasResources() {
    return this.resources != null;
  }
  public JvmOptions buildJvmOptions() {
    return this.jvmOptions!=null ?this.jvmOptions.build():null;
  }
  public A withJvmOptions(JvmOptions jvmOptions) {
    _visitables.get("jvmOptions").remove(this.jvmOptions);
    if (jvmOptions!=null){ this.jvmOptions= new JvmOptionsBuilder(jvmOptions); _visitables.get("jvmOptions").add(this.jvmOptions);} else { this.jvmOptions = null; _visitables.get("jvmOptions").remove(this.jvmOptions); } return (A) this;
  }
  public boolean hasJvmOptions() {
    return this.jvmOptions != null;
  }
  public JvmOptionsNested<A> withNewJvmOptions() {
    return new JvmOptionsNested(null);
  }
  public JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
    return new JvmOptionsNested(item);
  }
  public JvmOptionsNested<A> editJvmOptions() {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(null));
  }
  public JvmOptionsNested<A> editOrNewJvmOptions() {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(new JvmOptionsBuilder().build()));
  }
  public JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(item));
  }
  public Logging buildLogging() {
    return this.logging!=null?this.logging.build():null;
  }
  public A withLogging(Logging logging) {
    if (logging==null){ this.logging = null; _visitables.remove("logging"); return (A) this;}
    VisitableBuilder<? extends Logging,?> builder = builder(logging); _visitables.get("logging").clear();_visitables.get("logging").add(builder);this.logging = builder;
    return (A) this;
  }
  public boolean hasLogging() {
    return this.logging != null;
  }
  public ExternalLoggingNested<A> withNewExternalLogging() {
    return new ExternalLoggingNested(null);
  }
  public ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item) {
    return new ExternalLoggingNested(item);
  }
  public InlineLoggingNested<A> withNewInlineLogging() {
    return new InlineLoggingNested(null);
  }
  public InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item) {
    return new InlineLoggingNested(item);
  }
  public boolean isEnableMetrics() {
    return this.enableMetrics;
  }
  public A withEnableMetrics(boolean enableMetrics) {
    this.enableMetrics=enableMetrics; return (A) this;
  }
  public boolean hasEnableMetrics() {
    return true;
  }
  public Probe buildLivenessProbe() {
    return this.livenessProbe!=null ?this.livenessProbe.build():null;
  }
  public A withLivenessProbe(Probe livenessProbe) {
    _visitables.get("livenessProbe").remove(this.livenessProbe);
    if (livenessProbe!=null){ this.livenessProbe= new ProbeBuilder(livenessProbe); _visitables.get("livenessProbe").add(this.livenessProbe);} else { this.livenessProbe = null; _visitables.get("livenessProbe").remove(this.livenessProbe); } return (A) this;
  }
  public boolean hasLivenessProbe() {
    return this.livenessProbe != null;
  }
  public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds) {
    return (A)withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
  }
  public LivenessProbeNested<A> withNewLivenessProbe() {
    return new LivenessProbeNested(null);
  }
  public LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
    return new LivenessProbeNested(item);
  }
  public LivenessProbeNested<A> editLivenessProbe() {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(null));
  }
  public LivenessProbeNested<A> editOrNewLivenessProbe() {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(new ProbeBuilder().build()));
  }
  public LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(item));
  }
  public Probe buildReadinessProbe() {
    return this.readinessProbe!=null ?this.readinessProbe.build():null;
  }
  public A withReadinessProbe(Probe readinessProbe) {
    _visitables.get("readinessProbe").remove(this.readinessProbe);
    if (readinessProbe!=null){ this.readinessProbe= new ProbeBuilder(readinessProbe); _visitables.get("readinessProbe").add(this.readinessProbe);} else { this.readinessProbe = null; _visitables.get("readinessProbe").remove(this.readinessProbe); } return (A) this;
  }
  public boolean hasReadinessProbe() {
    return this.readinessProbe != null;
  }
  public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds) {
    return (A)withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
  }
  public ReadinessProbeNested<A> withNewReadinessProbe() {
    return new ReadinessProbeNested(null);
  }
  public ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
    return new ReadinessProbeNested(item);
  }
  public ReadinessProbeNested<A> editReadinessProbe() {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(null));
  }
  public ReadinessProbeNested<A> editOrNewReadinessProbe() {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(new ProbeBuilder().build()));
  }
  public ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(item));
  }
  public KafkaBridgeTemplate buildTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public A withTemplate(KafkaBridgeTemplate template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new KafkaBridgeTemplateBuilder(template); _visitables.get("template").add(this.template);} else { this.template = null; _visitables.get("template").remove(this.template); } return (A) this;
  }
  public boolean hasTemplate() {
    return this.template != null;
  }
  public TemplateNested<A> withNewTemplate() {
    return new TemplateNested(null);
  }
  public TemplateNested<A> withNewTemplateLike(KafkaBridgeTemplate item) {
    return new TemplateNested(item);
  }
  public TemplateNested<A> editTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(null));
  }
  public TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(new KafkaBridgeTemplateBuilder().build()));
  }
  public TemplateNested<A> editOrNewTemplateLike(KafkaBridgeTemplate item) {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(item));
  }
  public Tracing buildTracing() {
    return this.tracing!=null?this.tracing.build():null;
  }
  public A withTracing(Tracing tracing) {
    if (tracing==null){ this.tracing = null; _visitables.remove("tracing"); return (A) this;}
    VisitableBuilder<? extends Tracing,?> builder = builder(tracing); _visitables.get("tracing").clear();_visitables.get("tracing").add(builder);this.tracing = builder;
    return (A) this;
  }
  public boolean hasTracing() {
    return this.tracing != null;
  }
  public JaegerTracingNested<A> withNewJaegerTracing() {
    return new JaegerTracingNested(null);
  }
  public JaegerTracingNested<A> withNewJaegerTracingLike(JaegerTracing item) {
    return new JaegerTracingNested(item);
  }
  public OpenTelemetryTracingNested<A> withNewOpenTelemetryTracing() {
    return new OpenTelemetryTracingNested(null);
  }
  public OpenTelemetryTracingNested<A> withNewOpenTelemetryTracingLike(OpenTelemetryTracing item) {
    return new OpenTelemetryTracingNested(item);
  }
  public String getClientRackInitImage() {
    return this.clientRackInitImage;
  }
  public A withClientRackInitImage(String clientRackInitImage) {
    this.clientRackInitImage=clientRackInitImage; return (A) this;
  }
  public boolean hasClientRackInitImage() {
    return this.clientRackInitImage != null;
  }
  public Rack buildRack() {
    return this.rack!=null ?this.rack.build():null;
  }
  public A withRack(Rack rack) {
    _visitables.get("rack").remove(this.rack);
    if (rack!=null){ this.rack= new RackBuilder(rack); _visitables.get("rack").add(this.rack);} else { this.rack = null; _visitables.get("rack").remove(this.rack); } return (A) this;
  }
  public boolean hasRack() {
    return this.rack != null;
  }
  public A withNewRack(String topologyKey) {
    return (A)withRack(new Rack(topologyKey));
  }
  public RackNested<A> withNewRack() {
    return new RackNested(null);
  }
  public RackNested<A> withNewRackLike(Rack item) {
    return new RackNested(item);
  }
  public RackNested<A> editRack() {
    return withNewRackLike(java.util.Optional.ofNullable(buildRack()).orElse(null));
  }
  public RackNested<A> editOrNewRack() {
    return withNewRackLike(java.util.Optional.ofNullable(buildRack()).orElse(new RackBuilder().build()));
  }
  public RackNested<A> editOrNewRackLike(Rack item) {
    return withNewRackLike(java.util.Optional.ofNullable(buildRack()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaBridgeSpecFluent that = (KafkaBridgeSpecFluent) o;
    if (replicas != that.replicas) return false;
    if (!java.util.Objects.equals(image, that.image)) return false;

    if (!java.util.Objects.equals(http, that.http)) return false;

    if (!java.util.Objects.equals(bootstrapServers, that.bootstrapServers)) return false;

    if (!java.util.Objects.equals(tls, that.tls)) return false;

    if (!java.util.Objects.equals(authentication, that.authentication)) return false;

    if (!java.util.Objects.equals(consumer, that.consumer)) return false;

    if (!java.util.Objects.equals(producer, that.producer)) return false;

    if (!java.util.Objects.equals(adminClient, that.adminClient)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    if (!java.util.Objects.equals(jvmOptions, that.jvmOptions)) return false;

    if (!java.util.Objects.equals(logging, that.logging)) return false;

    if (enableMetrics != that.enableMetrics) return false;
    if (!java.util.Objects.equals(livenessProbe, that.livenessProbe)) return false;

    if (!java.util.Objects.equals(readinessProbe, that.readinessProbe)) return false;

    if (!java.util.Objects.equals(template, that.template)) return false;

    if (!java.util.Objects.equals(tracing, that.tracing)) return false;

    if (!java.util.Objects.equals(clientRackInitImage, that.clientRackInitImage)) return false;

    if (!java.util.Objects.equals(rack, that.rack)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(replicas,  image,  http,  bootstrapServers,  tls,  authentication,  consumer,  producer,  adminClient,  resources,  jvmOptions,  logging,  enableMetrics,  livenessProbe,  readinessProbe,  template,  tracing,  clientRackInitImage,  rack,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    sb.append("replicas:"); sb.append(replicas + ",");
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (http != null) { sb.append("http:"); sb.append(http + ","); }
    if (bootstrapServers != null) { sb.append("bootstrapServers:"); sb.append(bootstrapServers + ","); }
    if (tls != null) { sb.append("tls:"); sb.append(tls + ","); }
    if (authentication != null) { sb.append("authentication:"); sb.append(authentication + ","); }
    if (consumer != null) { sb.append("consumer:"); sb.append(consumer + ","); }
    if (producer != null) { sb.append("producer:"); sb.append(producer + ","); }
    if (adminClient != null) { sb.append("adminClient:"); sb.append(adminClient + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (jvmOptions != null) { sb.append("jvmOptions:"); sb.append(jvmOptions + ","); }
    if (logging != null) { sb.append("logging:"); sb.append(logging + ","); }
    sb.append("enableMetrics:"); sb.append(enableMetrics + ",");
    if (livenessProbe != null) { sb.append("livenessProbe:"); sb.append(livenessProbe + ","); }
    if (readinessProbe != null) { sb.append("readinessProbe:"); sb.append(readinessProbe + ","); }
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (tracing != null) { sb.append("tracing:"); sb.append(tracing + ","); }
    if (clientRackInitImage != null) { sb.append("clientRackInitImage:"); sb.append(clientRackInitImage + ","); }
    if (rack != null) { sb.append("rack:"); sb.append(rack); }
    sb.append("}");
    return sb.toString();
  }
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.strimzi.api.kafka.model.authentication."+"KafkaClientAuthenticationScramSha512": return (VisitableBuilder<T, ?>)new KafkaClientAuthenticationScramSha512Builder((KafkaClientAuthenticationScramSha512) item);
    case "io.strimzi.api.kafka.model.authentication."+"KafkaClientAuthenticationScramSha256": return (VisitableBuilder<T, ?>)new KafkaClientAuthenticationScramSha256Builder((KafkaClientAuthenticationScramSha256) item);
    case "io.strimzi.api.kafka.model.authentication."+"KafkaClientAuthenticationPlain": return (VisitableBuilder<T, ?>)new KafkaClientAuthenticationPlainBuilder((KafkaClientAuthenticationPlain) item);
    case "io.strimzi.api.kafka.model.authentication."+"KafkaClientAuthenticationOAuth": return (VisitableBuilder<T, ?>)new KafkaClientAuthenticationOAuthBuilder((KafkaClientAuthenticationOAuth) item);
    case "io.strimzi.api.kafka.model.authentication."+"KafkaClientAuthenticationTls": return (VisitableBuilder<T, ?>)new KafkaClientAuthenticationTlsBuilder((KafkaClientAuthenticationTls) item);
    case "io.strimzi.api.kafka.model."+"ExternalLogging": return (VisitableBuilder<T, ?>)new ExternalLoggingBuilder((ExternalLogging) item);
    case "io.strimzi.api.kafka.model."+"InlineLogging": return (VisitableBuilder<T, ?>)new InlineLoggingBuilder((InlineLogging) item);
    case "io.strimzi.api.kafka.model.tracing."+"JaegerTracing": return (VisitableBuilder<T, ?>)new JaegerTracingBuilder((JaegerTracing) item);
    case "io.strimzi.api.kafka.model.tracing."+"OpenTelemetryTracing": return (VisitableBuilder<T, ?>)new OpenTelemetryTracingBuilder((OpenTelemetryTracing) item);
    }
 return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public A withEnableMetrics() {
    return withEnableMetrics(true);
  }
  public class HttpNested<N> extends KafkaBridgeHttpConfigFluent<HttpNested<N>> implements Nested<N>{
    HttpNested(KafkaBridgeHttpConfig item) {
      this.builder = new KafkaBridgeHttpConfigBuilder(this, item);
    }
    KafkaBridgeHttpConfigBuilder builder;
    public N and() {
      return (N) KafkaBridgeSpecFluent.this.withHttp(builder.build());
    }
    public N endHttp() {
      return and();
    }
    
  }
  public class TlsNested<N> extends ClientTlsFluent<TlsNested<N>> implements Nested<N>{
    TlsNested(ClientTls item) {
      this.builder = new ClientTlsBuilder(this, item);
    }
    ClientTlsBuilder builder;
    public N and() {
      return (N) KafkaBridgeSpecFluent.this.withTls(builder.build());
    }
    public N endTls() {
      return and();
    }
    
  }
  public class KafkaClientAuthenticationScramSha512Nested<N> extends KafkaClientAuthenticationScramSha512Fluent<KafkaClientAuthenticationScramSha512Nested<N>> implements Nested<N>{
    KafkaClientAuthenticationScramSha512Nested(KafkaClientAuthenticationScramSha512 item) {
      this.builder = new KafkaClientAuthenticationScramSha512Builder(this, item);
    }
    KafkaClientAuthenticationScramSha512Builder builder;
    public N and() {
      return (N) KafkaBridgeSpecFluent.this.withAuthentication(builder.build());
    }
    public N endKafkaClientAuthenticationScramSha512() {
      return and();
    }
    
  }
  public class KafkaClientAuthenticationScramSha256Nested<N> extends KafkaClientAuthenticationScramSha256Fluent<KafkaClientAuthenticationScramSha256Nested<N>> implements Nested<N>{
    KafkaClientAuthenticationScramSha256Nested(KafkaClientAuthenticationScramSha256 item) {
      this.builder = new KafkaClientAuthenticationScramSha256Builder(this, item);
    }
    KafkaClientAuthenticationScramSha256Builder builder;
    public N and() {
      return (N) KafkaBridgeSpecFluent.this.withAuthentication(builder.build());
    }
    public N endKafkaClientAuthenticationScramSha256() {
      return and();
    }
    
  }
  public class KafkaClientAuthenticationPlainNested<N> extends KafkaClientAuthenticationPlainFluent<KafkaClientAuthenticationPlainNested<N>> implements Nested<N>{
    KafkaClientAuthenticationPlainNested(KafkaClientAuthenticationPlain item) {
      this.builder = new KafkaClientAuthenticationPlainBuilder(this, item);
    }
    KafkaClientAuthenticationPlainBuilder builder;
    public N and() {
      return (N) KafkaBridgeSpecFluent.this.withAuthentication(builder.build());
    }
    public N endKafkaClientAuthenticationPlain() {
      return and();
    }
    
  }
  public class KafkaClientAuthenticationOAuthNested<N> extends KafkaClientAuthenticationOAuthFluent<KafkaClientAuthenticationOAuthNested<N>> implements Nested<N>{
    KafkaClientAuthenticationOAuthNested(KafkaClientAuthenticationOAuth item) {
      this.builder = new KafkaClientAuthenticationOAuthBuilder(this, item);
    }
    KafkaClientAuthenticationOAuthBuilder builder;
    public N and() {
      return (N) KafkaBridgeSpecFluent.this.withAuthentication(builder.build());
    }
    public N endKafkaClientAuthenticationOAuth() {
      return and();
    }
    
  }
  public class KafkaClientAuthenticationTlsNested<N> extends KafkaClientAuthenticationTlsFluent<KafkaClientAuthenticationTlsNested<N>> implements Nested<N>{
    KafkaClientAuthenticationTlsNested(KafkaClientAuthenticationTls item) {
      this.builder = new KafkaClientAuthenticationTlsBuilder(this, item);
    }
    KafkaClientAuthenticationTlsBuilder builder;
    public N and() {
      return (N) KafkaBridgeSpecFluent.this.withAuthentication(builder.build());
    }
    public N endKafkaClientAuthenticationTls() {
      return and();
    }
    
  }
  public class ConsumerNested<N> extends KafkaBridgeConsumerSpecFluent<ConsumerNested<N>> implements Nested<N>{
    ConsumerNested(KafkaBridgeConsumerSpec item) {
      this.builder = new KafkaBridgeConsumerSpecBuilder(this, item);
    }
    KafkaBridgeConsumerSpecBuilder builder;
    public N and() {
      return (N) KafkaBridgeSpecFluent.this.withConsumer(builder.build());
    }
    public N endConsumer() {
      return and();
    }
    
  }
  public class ProducerNested<N> extends KafkaBridgeProducerSpecFluent<ProducerNested<N>> implements Nested<N>{
    ProducerNested(KafkaBridgeProducerSpec item) {
      this.builder = new KafkaBridgeProducerSpecBuilder(this, item);
    }
    KafkaBridgeProducerSpecBuilder builder;
    public N and() {
      return (N) KafkaBridgeSpecFluent.this.withProducer(builder.build());
    }
    public N endProducer() {
      return and();
    }
    
  }
  public class AdminClientNested<N> extends KafkaBridgeAdminClientSpecFluent<AdminClientNested<N>> implements Nested<N>{
    AdminClientNested(KafkaBridgeAdminClientSpec item) {
      this.builder = new KafkaBridgeAdminClientSpecBuilder(this, item);
    }
    KafkaBridgeAdminClientSpecBuilder builder;
    public N and() {
      return (N) KafkaBridgeSpecFluent.this.withAdminClient(builder.build());
    }
    public N endAdminClient() {
      return and();
    }
    
  }
  public class JvmOptionsNested<N> extends JvmOptionsFluent<JvmOptionsNested<N>> implements Nested<N>{
    JvmOptionsNested(JvmOptions item) {
      this.builder = new JvmOptionsBuilder(this, item);
    }
    JvmOptionsBuilder builder;
    public N and() {
      return (N) KafkaBridgeSpecFluent.this.withJvmOptions(builder.build());
    }
    public N endJvmOptions() {
      return and();
    }
    
  }
  public class ExternalLoggingNested<N> extends ExternalLoggingFluent<ExternalLoggingNested<N>> implements Nested<N>{
    ExternalLoggingNested(ExternalLogging item) {
      this.builder = new ExternalLoggingBuilder(this, item);
    }
    ExternalLoggingBuilder builder;
    public N and() {
      return (N) KafkaBridgeSpecFluent.this.withLogging(builder.build());
    }
    public N endExternalLogging() {
      return and();
    }
    
  }
  public class InlineLoggingNested<N> extends InlineLoggingFluent<InlineLoggingNested<N>> implements Nested<N>{
    InlineLoggingNested(InlineLogging item) {
      this.builder = new InlineLoggingBuilder(this, item);
    }
    InlineLoggingBuilder builder;
    public N and() {
      return (N) KafkaBridgeSpecFluent.this.withLogging(builder.build());
    }
    public N endInlineLogging() {
      return and();
    }
    
  }
  public class LivenessProbeNested<N> extends ProbeFluent<LivenessProbeNested<N>> implements Nested<N>{
    LivenessProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    public N and() {
      return (N) KafkaBridgeSpecFluent.this.withLivenessProbe(builder.build());
    }
    public N endLivenessProbe() {
      return and();
    }
    
  }
  public class ReadinessProbeNested<N> extends ProbeFluent<ReadinessProbeNested<N>> implements Nested<N>{
    ReadinessProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    public N and() {
      return (N) KafkaBridgeSpecFluent.this.withReadinessProbe(builder.build());
    }
    public N endReadinessProbe() {
      return and();
    }
    
  }
  public class TemplateNested<N> extends KafkaBridgeTemplateFluent<TemplateNested<N>> implements Nested<N>{
    TemplateNested(KafkaBridgeTemplate item) {
      this.builder = new KafkaBridgeTemplateBuilder(this, item);
    }
    KafkaBridgeTemplateBuilder builder;
    public N and() {
      return (N) KafkaBridgeSpecFluent.this.withTemplate(builder.build());
    }
    public N endTemplate() {
      return and();
    }
    
  }
  public class JaegerTracingNested<N> extends JaegerTracingFluent<JaegerTracingNested<N>> implements Nested<N>{
    JaegerTracingNested(JaegerTracing item) {
      this.builder = new JaegerTracingBuilder(this, item);
    }
    JaegerTracingBuilder builder;
    public N and() {
      return (N) KafkaBridgeSpecFluent.this.withTracing(builder.build());
    }
    public N endJaegerTracing() {
      return and();
    }
    
  }
  public class OpenTelemetryTracingNested<N> extends OpenTelemetryTracingFluent<OpenTelemetryTracingNested<N>> implements Nested<N>{
    OpenTelemetryTracingNested(OpenTelemetryTracing item) {
      this.builder = new OpenTelemetryTracingBuilder(this, item);
    }
    OpenTelemetryTracingBuilder builder;
    public N and() {
      return (N) KafkaBridgeSpecFluent.this.withTracing(builder.build());
    }
    public N endOpenTelemetryTracing() {
      return and();
    }
    
  }
  public class RackNested<N> extends RackFluent<RackNested<N>> implements Nested<N>{
    RackNested(Rack item) {
      this.builder = new RackBuilder(this, item);
    }
    RackBuilder builder;
    public N and() {
      return (N) KafkaBridgeSpecFluent.this.withRack(builder.build());
    }
    public N endRack() {
      return and();
    }
    
  }
  
}