package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaBuilder extends KafkaFluent<KafkaBuilder> implements VisitableBuilder<Kafka,KafkaBuilder>{
  public KafkaBuilder() {
    this(false);
  }
  public KafkaBuilder(Boolean validationEnabled) {
    this(new Kafka(), validationEnabled);
  }
  public KafkaBuilder(KafkaFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaBuilder(KafkaFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Kafka(), validationEnabled);
  }
  public KafkaBuilder(KafkaFluent<?> fluent,Kafka instance) {
    this(fluent, instance, false);
  }
  public KafkaBuilder(KafkaFluent<?> fluent,Kafka instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Kafka());

    if (instance != null) {
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaBuilder(Kafka instance) {
    this(instance,false);
  }
  public KafkaBuilder(Kafka instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Kafka());

    if (instance != null) {
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaFluent<?> fluent;
  Boolean validationEnabled;
  public Kafka build() {
    Kafka buildable = new Kafka(fluent.buildSpec(),fluent.buildStatus());
    buildable.setApiVersion(fluent.getApiVersion());
    buildable.setKind(fluent.getKind());
    buildable.setMetadata(fluent.buildMetadata());
    return buildable;
  }
  
}