package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaConnectBuilder extends KafkaConnectFluent<KafkaConnectBuilder> implements VisitableBuilder<KafkaConnect,KafkaConnectBuilder>{
  public KafkaConnectBuilder() {
    this(false);
  }
  public KafkaConnectBuilder(Boolean validationEnabled) {
    this(new KafkaConnect(), validationEnabled);
  }
  public KafkaConnectBuilder(KafkaConnectFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaConnectBuilder(KafkaConnectFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaConnect(), validationEnabled);
  }
  public KafkaConnectBuilder(KafkaConnectFluent<?> fluent,KafkaConnect instance) {
    this(fluent, instance, false);
  }
  public KafkaConnectBuilder(KafkaConnectFluent<?> fluent,KafkaConnect instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaConnect());

    if (instance != null) {
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaConnectBuilder(KafkaConnect instance) {
    this(instance,false);
  }
  public KafkaConnectBuilder(KafkaConnect instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaConnect());

    if (instance != null) {
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaConnectFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaConnect build() {
    KafkaConnect buildable = new KafkaConnect(fluent.buildSpec(),fluent.buildStatus());
    buildable.setApiVersion(fluent.getApiVersion());
    buildable.setKind(fluent.getKind());
    buildable.setMetadata(fluent.buildMetadata());
    return buildable;
  }
  
}