package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaConnectSpecBuilder extends KafkaConnectSpecFluent<KafkaConnectSpecBuilder> implements VisitableBuilder<KafkaConnectSpec,KafkaConnectSpecBuilder>{
  public KafkaConnectSpecBuilder() {
    this(false);
  }
  public KafkaConnectSpecBuilder(Boolean validationEnabled) {
    this(new KafkaConnectSpec(), validationEnabled);
  }
  public KafkaConnectSpecBuilder(KafkaConnectSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaConnectSpecBuilder(KafkaConnectSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaConnectSpec(), validationEnabled);
  }
  public KafkaConnectSpecBuilder(KafkaConnectSpecFluent<?> fluent,KafkaConnectSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaConnectSpecBuilder(KafkaConnectSpecFluent<?> fluent,KafkaConnectSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaConnectSpec());

    if (instance != null) {
      fluent.withConfig(instance.getConfig());
      fluent.withBootstrapServers(instance.getBootstrapServers());
      fluent.withTls(instance.getTls());
      fluent.withAuthentication(instance.getAuthentication());
      fluent.withBuild(instance.getBuild());
      fluent.withLogging(instance.getLogging());
      fluent.withReplicas(instance.getReplicas());
      fluent.withVersion(instance.getVersion());
      fluent.withImage(instance.getImage());
      fluent.withResources(instance.getResources());
      fluent.withLivenessProbe(instance.getLivenessProbe());
      fluent.withReadinessProbe(instance.getReadinessProbe());
      fluent.withJmxOptions(instance.getJmxOptions());
      fluent.withJvmOptions(instance.getJvmOptions());
      fluent.withMetricsConfig(instance.getMetricsConfig());
      fluent.withTracing(instance.getTracing());
      fluent.withTemplate(instance.getTemplate());
      fluent.withExternalConfiguration(instance.getExternalConfiguration());
      fluent.withClientRackInitImage(instance.getClientRackInitImage());
      fluent.withRack(instance.getRack());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaConnectSpecBuilder(KafkaConnectSpec instance) {
    this(instance,false);
  }
  public KafkaConnectSpecBuilder(KafkaConnectSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaConnectSpec());

    if (instance != null) {
      this.withConfig(instance.getConfig());
      this.withBootstrapServers(instance.getBootstrapServers());
      this.withTls(instance.getTls());
      this.withAuthentication(instance.getAuthentication());
      this.withBuild(instance.getBuild());
      this.withLogging(instance.getLogging());
      this.withReplicas(instance.getReplicas());
      this.withVersion(instance.getVersion());
      this.withImage(instance.getImage());
      this.withResources(instance.getResources());
      this.withLivenessProbe(instance.getLivenessProbe());
      this.withReadinessProbe(instance.getReadinessProbe());
      this.withJmxOptions(instance.getJmxOptions());
      this.withJvmOptions(instance.getJvmOptions());
      this.withMetricsConfig(instance.getMetricsConfig());
      this.withTracing(instance.getTracing());
      this.withTemplate(instance.getTemplate());
      this.withExternalConfiguration(instance.getExternalConfiguration());
      this.withClientRackInitImage(instance.getClientRackInitImage());
      this.withRack(instance.getRack());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaConnectSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaConnectSpec build() {
    KafkaConnectSpec buildable = new KafkaConnectSpec();
    buildable.setConfig(fluent.getConfig());
    buildable.setBootstrapServers(fluent.getBootstrapServers());
    buildable.setTls(fluent.buildTls());
    buildable.setAuthentication(fluent.buildAuthentication());
    buildable.setBuild(fluent.buildBuild());
    buildable.setLogging(fluent.buildLogging());
    buildable.setReplicas(fluent.getReplicas());
    buildable.setVersion(fluent.getVersion());
    buildable.setImage(fluent.getImage());
    buildable.setResources(fluent.getResources());
    buildable.setLivenessProbe(fluent.buildLivenessProbe());
    buildable.setReadinessProbe(fluent.buildReadinessProbe());
    buildable.setJmxOptions(fluent.buildJmxOptions());
    buildable.setJvmOptions(fluent.buildJvmOptions());
    buildable.setMetricsConfig(fluent.buildMetricsConfig());
    buildable.setTracing(fluent.buildTracing());
    buildable.setTemplate(fluent.buildTemplate());
    buildable.setExternalConfiguration(fluent.buildExternalConfiguration());
    buildable.setClientRackInitImage(fluent.getClientRackInitImage());
    buildable.setRack(fluent.buildRack());
    return buildable;
  }
  
}