package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaConnectorSpecBuilder extends KafkaConnectorSpecFluent<KafkaConnectorSpecBuilder> implements VisitableBuilder<KafkaConnectorSpec,KafkaConnectorSpecBuilder>{
  public KafkaConnectorSpecBuilder() {
    this(false);
  }
  public KafkaConnectorSpecBuilder(Boolean validationEnabled) {
    this(new KafkaConnectorSpec(), validationEnabled);
  }
  public KafkaConnectorSpecBuilder(KafkaConnectorSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaConnectorSpecBuilder(KafkaConnectorSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaConnectorSpec(), validationEnabled);
  }
  public KafkaConnectorSpecBuilder(KafkaConnectorSpecFluent<?> fluent,KafkaConnectorSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaConnectorSpecBuilder(KafkaConnectorSpecFluent<?> fluent,KafkaConnectorSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaConnectorSpec());

    if (instance != null) {
      fluent.withClassName(instance.getClassName());
      fluent.withTasksMax(instance.getTasksMax());
      fluent.withPause(instance.getPause());
      fluent.withConfig(instance.getConfig());
      fluent.withState(instance.getState());
      fluent.withAutoRestart(instance.getAutoRestart());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaConnectorSpecBuilder(KafkaConnectorSpec instance) {
    this(instance,false);
  }
  public KafkaConnectorSpecBuilder(KafkaConnectorSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaConnectorSpec());

    if (instance != null) {
      this.withClassName(instance.getClassName());
      this.withTasksMax(instance.getTasksMax());
      this.withPause(instance.getPause());
      this.withConfig(instance.getConfig());
      this.withState(instance.getState());
      this.withAutoRestart(instance.getAutoRestart());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaConnectorSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaConnectorSpec build() {
    KafkaConnectorSpec buildable = new KafkaConnectorSpec();
    buildable.setClassName(fluent.getClassName());
    buildable.setTasksMax(fluent.getTasksMax());
    buildable.setPause(fluent.getPause());
    buildable.setConfig(fluent.getConfig());
    buildable.setState(fluent.getState());
    buildable.setAutoRestart(fluent.buildAutoRestart());
    return buildable;
  }
  
}