package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaExporterSpecBuilder extends KafkaExporterSpecFluent<KafkaExporterSpecBuilder> implements VisitableBuilder<KafkaExporterSpec,KafkaExporterSpecBuilder>{
  public KafkaExporterSpecBuilder() {
    this(false);
  }
  public KafkaExporterSpecBuilder(Boolean validationEnabled) {
    this(new KafkaExporterSpec(), validationEnabled);
  }
  public KafkaExporterSpecBuilder(KafkaExporterSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaExporterSpecBuilder(KafkaExporterSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaExporterSpec(), validationEnabled);
  }
  public KafkaExporterSpecBuilder(KafkaExporterSpecFluent<?> fluent,KafkaExporterSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaExporterSpecBuilder(KafkaExporterSpecFluent<?> fluent,KafkaExporterSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaExporterSpec());

    if (instance != null) {
      fluent.withImage(instance.getImage());
      fluent.withGroupRegex(instance.getGroupRegex());
      fluent.withTopicRegex(instance.getTopicRegex());
      fluent.withTopicExcludeRegex(instance.getTopicExcludeRegex());
      fluent.withGroupExcludeRegex(instance.getGroupExcludeRegex());
      fluent.withResources(instance.getResources());
      fluent.withLivenessProbe(instance.getLivenessProbe());
      fluent.withReadinessProbe(instance.getReadinessProbe());
      fluent.withLogging(instance.getLogging());
      fluent.withEnableSaramaLogging(instance.getEnableSaramaLogging());
      fluent.withTemplate(instance.getTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaExporterSpecBuilder(KafkaExporterSpec instance) {
    this(instance,false);
  }
  public KafkaExporterSpecBuilder(KafkaExporterSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaExporterSpec());

    if (instance != null) {
      this.withImage(instance.getImage());
      this.withGroupRegex(instance.getGroupRegex());
      this.withTopicRegex(instance.getTopicRegex());
      this.withTopicExcludeRegex(instance.getTopicExcludeRegex());
      this.withGroupExcludeRegex(instance.getGroupExcludeRegex());
      this.withResources(instance.getResources());
      this.withLivenessProbe(instance.getLivenessProbe());
      this.withReadinessProbe(instance.getReadinessProbe());
      this.withLogging(instance.getLogging());
      this.withEnableSaramaLogging(instance.getEnableSaramaLogging());
      this.withTemplate(instance.getTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaExporterSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaExporterSpec build() {
    KafkaExporterSpec buildable = new KafkaExporterSpec();
    buildable.setImage(fluent.getImage());
    buildable.setGroupRegex(fluent.getGroupRegex());
    buildable.setTopicRegex(fluent.getTopicRegex());
    buildable.setTopicExcludeRegex(fluent.getTopicExcludeRegex());
    buildable.setGroupExcludeRegex(fluent.getGroupExcludeRegex());
    buildable.setResources(fluent.getResources());
    buildable.setLivenessProbe(fluent.buildLivenessProbe());
    buildable.setReadinessProbe(fluent.buildReadinessProbe());
    buildable.setLogging(fluent.getLogging());
    buildable.setEnableSaramaLogging(fluent.isEnableSaramaLogging());
    buildable.setTemplate(fluent.buildTemplate());
    return buildable;
  }
  
}