package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaMirrorMaker2ClusterSpecBuilder extends KafkaMirrorMaker2ClusterSpecFluent<KafkaMirrorMaker2ClusterSpecBuilder> implements VisitableBuilder<KafkaMirrorMaker2ClusterSpec,KafkaMirrorMaker2ClusterSpecBuilder>{
  public KafkaMirrorMaker2ClusterSpecBuilder() {
    this(false);
  }
  public KafkaMirrorMaker2ClusterSpecBuilder(Boolean validationEnabled) {
    this(new KafkaMirrorMaker2ClusterSpec(), validationEnabled);
  }
  public KafkaMirrorMaker2ClusterSpecBuilder(KafkaMirrorMaker2ClusterSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaMirrorMaker2ClusterSpecBuilder(KafkaMirrorMaker2ClusterSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaMirrorMaker2ClusterSpec(), validationEnabled);
  }
  public KafkaMirrorMaker2ClusterSpecBuilder(KafkaMirrorMaker2ClusterSpecFluent<?> fluent,KafkaMirrorMaker2ClusterSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaMirrorMaker2ClusterSpecBuilder(KafkaMirrorMaker2ClusterSpecFluent<?> fluent,KafkaMirrorMaker2ClusterSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaMirrorMaker2ClusterSpec());

    if (instance != null) {
      fluent.withAlias(instance.getAlias());
      fluent.withBootstrapServers(instance.getBootstrapServers());
      fluent.withConfig(instance.getConfig());
      fluent.withTls(instance.getTls());
      fluent.withAuthentication(instance.getAuthentication());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaMirrorMaker2ClusterSpecBuilder(KafkaMirrorMaker2ClusterSpec instance) {
    this(instance,false);
  }
  public KafkaMirrorMaker2ClusterSpecBuilder(KafkaMirrorMaker2ClusterSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaMirrorMaker2ClusterSpec());

    if (instance != null) {
      this.withAlias(instance.getAlias());
      this.withBootstrapServers(instance.getBootstrapServers());
      this.withConfig(instance.getConfig());
      this.withTls(instance.getTls());
      this.withAuthentication(instance.getAuthentication());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaMirrorMaker2ClusterSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaMirrorMaker2ClusterSpec build() {
    KafkaMirrorMaker2ClusterSpec buildable = new KafkaMirrorMaker2ClusterSpec();
    buildable.setAlias(fluent.getAlias());
    buildable.setBootstrapServers(fluent.getBootstrapServers());
    buildable.setConfig(fluent.getConfig());
    buildable.setTls(fluent.buildTls());
    buildable.setAuthentication(fluent.buildAuthentication());
    return buildable;
  }
  
}