package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaMirrorMaker2ConnectorSpecBuilder extends KafkaMirrorMaker2ConnectorSpecFluent<KafkaMirrorMaker2ConnectorSpecBuilder> implements VisitableBuilder<KafkaMirrorMaker2ConnectorSpec,KafkaMirrorMaker2ConnectorSpecBuilder>{
  public KafkaMirrorMaker2ConnectorSpecBuilder() {
    this(false);
  }
  public KafkaMirrorMaker2ConnectorSpecBuilder(Boolean validationEnabled) {
    this(new KafkaMirrorMaker2ConnectorSpec(), validationEnabled);
  }
  public KafkaMirrorMaker2ConnectorSpecBuilder(KafkaMirrorMaker2ConnectorSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaMirrorMaker2ConnectorSpecBuilder(KafkaMirrorMaker2ConnectorSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaMirrorMaker2ConnectorSpec(), validationEnabled);
  }
  public KafkaMirrorMaker2ConnectorSpecBuilder(KafkaMirrorMaker2ConnectorSpecFluent<?> fluent,KafkaMirrorMaker2ConnectorSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaMirrorMaker2ConnectorSpecBuilder(KafkaMirrorMaker2ConnectorSpecFluent<?> fluent,KafkaMirrorMaker2ConnectorSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaMirrorMaker2ConnectorSpec());

    if (instance != null) {
      fluent.withTasksMax(instance.getTasksMax());
      fluent.withPause(instance.getPause());
      fluent.withConfig(instance.getConfig());
      fluent.withState(instance.getState());
      fluent.withAutoRestart(instance.getAutoRestart());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaMirrorMaker2ConnectorSpecBuilder(KafkaMirrorMaker2ConnectorSpec instance) {
    this(instance,false);
  }
  public KafkaMirrorMaker2ConnectorSpecBuilder(KafkaMirrorMaker2ConnectorSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaMirrorMaker2ConnectorSpec());

    if (instance != null) {
      this.withTasksMax(instance.getTasksMax());
      this.withPause(instance.getPause());
      this.withConfig(instance.getConfig());
      this.withState(instance.getState());
      this.withAutoRestart(instance.getAutoRestart());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaMirrorMaker2ConnectorSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaMirrorMaker2ConnectorSpec build() {
    KafkaMirrorMaker2ConnectorSpec buildable = new KafkaMirrorMaker2ConnectorSpec();
    buildable.setTasksMax(fluent.getTasksMax());
    buildable.setPause(fluent.getPause());
    buildable.setConfig(fluent.getConfig());
    buildable.setState(fluent.getState());
    buildable.setAutoRestart(fluent.buildAutoRestart());
    return buildable;
  }
  
}