package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaMirrorMaker2MirrorSpecBuilder extends KafkaMirrorMaker2MirrorSpecFluent<KafkaMirrorMaker2MirrorSpecBuilder> implements VisitableBuilder<KafkaMirrorMaker2MirrorSpec,KafkaMirrorMaker2MirrorSpecBuilder>{
  public KafkaMirrorMaker2MirrorSpecBuilder() {
    this(false);
  }
  public KafkaMirrorMaker2MirrorSpecBuilder(Boolean validationEnabled) {
    this(new KafkaMirrorMaker2MirrorSpec(), validationEnabled);
  }
  public KafkaMirrorMaker2MirrorSpecBuilder(KafkaMirrorMaker2MirrorSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaMirrorMaker2MirrorSpecBuilder(KafkaMirrorMaker2MirrorSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaMirrorMaker2MirrorSpec(), validationEnabled);
  }
  public KafkaMirrorMaker2MirrorSpecBuilder(KafkaMirrorMaker2MirrorSpecFluent<?> fluent,KafkaMirrorMaker2MirrorSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaMirrorMaker2MirrorSpecBuilder(KafkaMirrorMaker2MirrorSpecFluent<?> fluent,KafkaMirrorMaker2MirrorSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaMirrorMaker2MirrorSpec());

    if (instance != null) {
      fluent.withSourceCluster(instance.getSourceCluster());
      fluent.withTargetCluster(instance.getTargetCluster());
      fluent.withSourceConnector(instance.getSourceConnector());
      fluent.withCheckpointConnector(instance.getCheckpointConnector());
      fluent.withHeartbeatConnector(instance.getHeartbeatConnector());
      fluent.withTopicsPattern(instance.getTopicsPattern());
      fluent.withTopicsBlacklistPattern(instance.getTopicsBlacklistPattern());
      fluent.withTopicsExcludePattern(instance.getTopicsExcludePattern());
      fluent.withGroupsPattern(instance.getGroupsPattern());
      fluent.withGroupsBlacklistPattern(instance.getGroupsBlacklistPattern());
      fluent.withGroupsExcludePattern(instance.getGroupsExcludePattern());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaMirrorMaker2MirrorSpecBuilder(KafkaMirrorMaker2MirrorSpec instance) {
    this(instance,false);
  }
  public KafkaMirrorMaker2MirrorSpecBuilder(KafkaMirrorMaker2MirrorSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaMirrorMaker2MirrorSpec());

    if (instance != null) {
      this.withSourceCluster(instance.getSourceCluster());
      this.withTargetCluster(instance.getTargetCluster());
      this.withSourceConnector(instance.getSourceConnector());
      this.withCheckpointConnector(instance.getCheckpointConnector());
      this.withHeartbeatConnector(instance.getHeartbeatConnector());
      this.withTopicsPattern(instance.getTopicsPattern());
      this.withTopicsBlacklistPattern(instance.getTopicsBlacklistPattern());
      this.withTopicsExcludePattern(instance.getTopicsExcludePattern());
      this.withGroupsPattern(instance.getGroupsPattern());
      this.withGroupsBlacklistPattern(instance.getGroupsBlacklistPattern());
      this.withGroupsExcludePattern(instance.getGroupsExcludePattern());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaMirrorMaker2MirrorSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaMirrorMaker2MirrorSpec build() {
    KafkaMirrorMaker2MirrorSpec buildable = new KafkaMirrorMaker2MirrorSpec();
    buildable.setSourceCluster(fluent.getSourceCluster());
    buildable.setTargetCluster(fluent.getTargetCluster());
    buildable.setSourceConnector(fluent.buildSourceConnector());
    buildable.setCheckpointConnector(fluent.buildCheckpointConnector());
    buildable.setHeartbeatConnector(fluent.buildHeartbeatConnector());
    buildable.setTopicsPattern(fluent.getTopicsPattern());
    buildable.setTopicsBlacklistPattern(fluent.getTopicsBlacklistPattern());
    buildable.setTopicsExcludePattern(fluent.getTopicsExcludePattern());
    buildable.setGroupsPattern(fluent.getGroupsPattern());
    buildable.setGroupsBlacklistPattern(fluent.getGroupsBlacklistPattern());
    buildable.setGroupsExcludePattern(fluent.getGroupsExcludePattern());
    return buildable;
  }
  
}