package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaMirrorMaker2SpecBuilder extends KafkaMirrorMaker2SpecFluent<KafkaMirrorMaker2SpecBuilder> implements VisitableBuilder<KafkaMirrorMaker2Spec,KafkaMirrorMaker2SpecBuilder>{
  public KafkaMirrorMaker2SpecBuilder() {
    this(false);
  }
  public KafkaMirrorMaker2SpecBuilder(Boolean validationEnabled) {
    this(new KafkaMirrorMaker2Spec(), validationEnabled);
  }
  public KafkaMirrorMaker2SpecBuilder(KafkaMirrorMaker2SpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaMirrorMaker2SpecBuilder(KafkaMirrorMaker2SpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaMirrorMaker2Spec(), validationEnabled);
  }
  public KafkaMirrorMaker2SpecBuilder(KafkaMirrorMaker2SpecFluent<?> fluent,KafkaMirrorMaker2Spec instance) {
    this(fluent, instance, false);
  }
  public KafkaMirrorMaker2SpecBuilder(KafkaMirrorMaker2SpecFluent<?> fluent,KafkaMirrorMaker2Spec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaMirrorMaker2Spec());

    if (instance != null) {
      fluent.withClusters(instance.getClusters());
      fluent.withConnectCluster(instance.getConnectCluster());
      fluent.withMirrors(instance.getMirrors());
      fluent.withLogging(instance.getLogging());
      fluent.withReplicas(instance.getReplicas());
      fluent.withVersion(instance.getVersion());
      fluent.withImage(instance.getImage());
      fluent.withResources(instance.getResources());
      fluent.withLivenessProbe(instance.getLivenessProbe());
      fluent.withReadinessProbe(instance.getReadinessProbe());
      fluent.withJmxOptions(instance.getJmxOptions());
      fluent.withJvmOptions(instance.getJvmOptions());
      fluent.withMetricsConfig(instance.getMetricsConfig());
      fluent.withTracing(instance.getTracing());
      fluent.withTemplate(instance.getTemplate());
      fluent.withExternalConfiguration(instance.getExternalConfiguration());
      fluent.withClientRackInitImage(instance.getClientRackInitImage());
      fluent.withRack(instance.getRack());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaMirrorMaker2SpecBuilder(KafkaMirrorMaker2Spec instance) {
    this(instance,false);
  }
  public KafkaMirrorMaker2SpecBuilder(KafkaMirrorMaker2Spec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaMirrorMaker2Spec());

    if (instance != null) {
      this.withClusters(instance.getClusters());
      this.withConnectCluster(instance.getConnectCluster());
      this.withMirrors(instance.getMirrors());
      this.withLogging(instance.getLogging());
      this.withReplicas(instance.getReplicas());
      this.withVersion(instance.getVersion());
      this.withImage(instance.getImage());
      this.withResources(instance.getResources());
      this.withLivenessProbe(instance.getLivenessProbe());
      this.withReadinessProbe(instance.getReadinessProbe());
      this.withJmxOptions(instance.getJmxOptions());
      this.withJvmOptions(instance.getJvmOptions());
      this.withMetricsConfig(instance.getMetricsConfig());
      this.withTracing(instance.getTracing());
      this.withTemplate(instance.getTemplate());
      this.withExternalConfiguration(instance.getExternalConfiguration());
      this.withClientRackInitImage(instance.getClientRackInitImage());
      this.withRack(instance.getRack());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaMirrorMaker2SpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaMirrorMaker2Spec build() {
    KafkaMirrorMaker2Spec buildable = new KafkaMirrorMaker2Spec();
    buildable.setClusters(fluent.buildClusters());
    buildable.setConnectCluster(fluent.getConnectCluster());
    buildable.setMirrors(fluent.buildMirrors());
    buildable.setLogging(fluent.buildLogging());
    buildable.setReplicas(fluent.getReplicas());
    buildable.setVersion(fluent.getVersion());
    buildable.setImage(fluent.getImage());
    buildable.setResources(fluent.getResources());
    buildable.setLivenessProbe(fluent.buildLivenessProbe());
    buildable.setReadinessProbe(fluent.buildReadinessProbe());
    buildable.setJmxOptions(fluent.buildJmxOptions());
    buildable.setJvmOptions(fluent.buildJvmOptions());
    buildable.setMetricsConfig(fluent.buildMetricsConfig());
    buildable.setTracing(fluent.buildTracing());
    buildable.setTemplate(fluent.buildTemplate());
    buildable.setExternalConfiguration(fluent.buildExternalConfiguration());
    buildable.setClientRackInitImage(fluent.getClientRackInitImage());
    buildable.setRack(fluent.buildRack());
    return buildable;
  }
  
}