package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaMirrorMakerBuilder extends KafkaMirrorMakerFluent<KafkaMirrorMakerBuilder> implements VisitableBuilder<KafkaMirrorMaker,KafkaMirrorMakerBuilder>{
  public KafkaMirrorMakerBuilder() {
    this(false);
  }
  public KafkaMirrorMakerBuilder(Boolean validationEnabled) {
    this(new KafkaMirrorMaker(), validationEnabled);
  }
  public KafkaMirrorMakerBuilder(KafkaMirrorMakerFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaMirrorMakerBuilder(KafkaMirrorMakerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaMirrorMaker(), validationEnabled);
  }
  public KafkaMirrorMakerBuilder(KafkaMirrorMakerFluent<?> fluent,KafkaMirrorMaker instance) {
    this(fluent, instance, false);
  }
  public KafkaMirrorMakerBuilder(KafkaMirrorMakerFluent<?> fluent,KafkaMirrorMaker instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaMirrorMaker());

    if (instance != null) {
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaMirrorMakerBuilder(KafkaMirrorMaker instance) {
    this(instance,false);
  }
  public KafkaMirrorMakerBuilder(KafkaMirrorMaker instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaMirrorMaker());

    if (instance != null) {
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaMirrorMakerFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaMirrorMaker build() {
    KafkaMirrorMaker buildable = new KafkaMirrorMaker(fluent.buildSpec(),fluent.buildStatus());
    buildable.setApiVersion(fluent.getApiVersion());
    buildable.setKind(fluent.getKind());
    buildable.setMetadata(fluent.buildMetadata());
    return buildable;
  }
  
}