package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaMirrorMakerClientSpecBuilder extends KafkaMirrorMakerClientSpecFluent<KafkaMirrorMakerClientSpecBuilder> implements VisitableBuilder<KafkaMirrorMakerClientSpec,KafkaMirrorMakerClientSpecBuilder>{
  public KafkaMirrorMakerClientSpecBuilder() {
    this(false);
  }
  public KafkaMirrorMakerClientSpecBuilder(Boolean validationEnabled) {
    this(new KafkaMirrorMakerClientSpec(), validationEnabled);
  }
  public KafkaMirrorMakerClientSpecBuilder(KafkaMirrorMakerClientSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaMirrorMakerClientSpecBuilder(KafkaMirrorMakerClientSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaMirrorMakerClientSpec(), validationEnabled);
  }
  public KafkaMirrorMakerClientSpecBuilder(KafkaMirrorMakerClientSpecFluent<?> fluent,KafkaMirrorMakerClientSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaMirrorMakerClientSpecBuilder(KafkaMirrorMakerClientSpecFluent<?> fluent,KafkaMirrorMakerClientSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaMirrorMakerClientSpec());

    if (instance != null) {
      fluent.withBootstrapServers(instance.getBootstrapServers());
      fluent.withConfig(instance.getConfig());
      fluent.withTls(instance.getTls());
      fluent.withAuthentication(instance.getAuthentication());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaMirrorMakerClientSpecBuilder(KafkaMirrorMakerClientSpec instance) {
    this(instance,false);
  }
  public KafkaMirrorMakerClientSpecBuilder(KafkaMirrorMakerClientSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaMirrorMakerClientSpec());

    if (instance != null) {
      this.withBootstrapServers(instance.getBootstrapServers());
      this.withConfig(instance.getConfig());
      this.withTls(instance.getTls());
      this.withAuthentication(instance.getAuthentication());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaMirrorMakerClientSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaMirrorMakerClientSpec build() {
    KafkaMirrorMakerClientSpec buildable = new KafkaMirrorMakerClientSpec();
    buildable.setBootstrapServers(fluent.getBootstrapServers());
    buildable.setConfig(fluent.getConfig());
    buildable.setTls(fluent.buildTls());
    buildable.setAuthentication(fluent.buildAuthentication());
    return buildable;
  }
  
}