package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatus;
import io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatusBuilder;
import java.lang.SuppressWarnings;
import io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatusFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.client.CustomResourceFluent;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaMirrorMakerFluent<A extends KafkaMirrorMakerFluent<A>> extends CustomResourceFluent<KafkaMirrorMakerSpec,KafkaMirrorMakerStatus,A>{
  public KafkaMirrorMakerFluent() {
  }
  public KafkaMirrorMakerFluent(KafkaMirrorMaker instance) {
    instance = (instance != null ? instance : new KafkaMirrorMaker());

    if (instance != null) {
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
  }
  private String apiVersion;
  private String kind;
  private KafkaMirrorMakerSpecBuilder spec;
  private KafkaMirrorMakerStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public boolean hasKind() {
    return this.kind != null;
  }
  public KafkaMirrorMakerSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(KafkaMirrorMakerSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new KafkaMirrorMakerSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public boolean hasSpec() {
    return this.spec != null;
  }
  public SpecNested<A> withNewSpec() {
    return new SpecNested(null);
  }
  public SpecNested<A> withNewSpecLike(KafkaMirrorMakerSpec item) {
    return new SpecNested(item);
  }
  public SpecNested<A> editSpec() {
    return withNewSpecLike(java.util.Optional.ofNullable(buildSpec()).orElse(null));
  }
  public SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(java.util.Optional.ofNullable(buildSpec()).orElse(new KafkaMirrorMakerSpecBuilder().build()));
  }
  public SpecNested<A> editOrNewSpecLike(KafkaMirrorMakerSpec item) {
    return withNewSpecLike(java.util.Optional.ofNullable(buildSpec()).orElse(item));
  }
  public KafkaMirrorMakerStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(KafkaMirrorMakerStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new KafkaMirrorMakerStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public boolean hasStatus() {
    return this.status != null;
  }
  public StatusNested<A> withNewStatus() {
    return new StatusNested(null);
  }
  public StatusNested<A> withNewStatusLike(KafkaMirrorMakerStatus item) {
    return new StatusNested(item);
  }
  public StatusNested<A> editStatus() {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(null));
  }
  public StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(new KafkaMirrorMakerStatusBuilder().build()));
  }
  public StatusNested<A> editOrNewStatusLike(KafkaMirrorMakerStatus item) {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaMirrorMakerFluent that = (KafkaMirrorMakerFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(spec, that.spec)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  public class SpecNested<N> extends KafkaMirrorMakerSpecFluent<SpecNested<N>> implements Nested<N>{
    SpecNested(KafkaMirrorMakerSpec item) {
      this.builder = new KafkaMirrorMakerSpecBuilder(this, item);
    }
    KafkaMirrorMakerSpecBuilder builder;
    public N and() {
      return (N) KafkaMirrorMakerFluent.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  public class StatusNested<N> extends KafkaMirrorMakerStatusFluent<StatusNested<N>> implements Nested<N>{
    StatusNested(KafkaMirrorMakerStatus item) {
      this.builder = new KafkaMirrorMakerStatusBuilder(this, item);
    }
    KafkaMirrorMakerStatusBuilder builder;
    public N and() {
      return (N) KafkaMirrorMakerFluent.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}