package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaMirrorMakerSpecBuilder extends KafkaMirrorMakerSpecFluent<KafkaMirrorMakerSpecBuilder> implements VisitableBuilder<KafkaMirrorMakerSpec,KafkaMirrorMakerSpecBuilder>{
  public KafkaMirrorMakerSpecBuilder() {
    this(false);
  }
  public KafkaMirrorMakerSpecBuilder(Boolean validationEnabled) {
    this(new KafkaMirrorMakerSpec(), validationEnabled);
  }
  public KafkaMirrorMakerSpecBuilder(KafkaMirrorMakerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaMirrorMakerSpecBuilder(KafkaMirrorMakerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaMirrorMakerSpec(), validationEnabled);
  }
  public KafkaMirrorMakerSpecBuilder(KafkaMirrorMakerSpecFluent<?> fluent,KafkaMirrorMakerSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaMirrorMakerSpecBuilder(KafkaMirrorMakerSpecFluent<?> fluent,KafkaMirrorMakerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaMirrorMakerSpec());

    if (instance != null) {
      fluent.withReplicas(instance.getReplicas());
      fluent.withVersion(instance.getVersion());
      fluent.withImage(instance.getImage());
      fluent.withWhitelist(instance.getWhitelist());
      fluent.withInclude(instance.getInclude());
      fluent.withConsumer(instance.getConsumer());
      fluent.withProducer(instance.getProducer());
      fluent.withResources(instance.getResources());
      fluent.withLivenessProbe(instance.getLivenessProbe());
      fluent.withReadinessProbe(instance.getReadinessProbe());
      fluent.withJvmOptions(instance.getJvmOptions());
      fluent.withLogging(instance.getLogging());
      fluent.withMetricsConfig(instance.getMetricsConfig());
      fluent.withTracing(instance.getTracing());
      fluent.withTemplate(instance.getTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaMirrorMakerSpecBuilder(KafkaMirrorMakerSpec instance) {
    this(instance,false);
  }
  public KafkaMirrorMakerSpecBuilder(KafkaMirrorMakerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaMirrorMakerSpec());

    if (instance != null) {
      this.withReplicas(instance.getReplicas());
      this.withVersion(instance.getVersion());
      this.withImage(instance.getImage());
      this.withWhitelist(instance.getWhitelist());
      this.withInclude(instance.getInclude());
      this.withConsumer(instance.getConsumer());
      this.withProducer(instance.getProducer());
      this.withResources(instance.getResources());
      this.withLivenessProbe(instance.getLivenessProbe());
      this.withReadinessProbe(instance.getReadinessProbe());
      this.withJvmOptions(instance.getJvmOptions());
      this.withLogging(instance.getLogging());
      this.withMetricsConfig(instance.getMetricsConfig());
      this.withTracing(instance.getTracing());
      this.withTemplate(instance.getTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaMirrorMakerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaMirrorMakerSpec build() {
    KafkaMirrorMakerSpec buildable = new KafkaMirrorMakerSpec();
    buildable.setReplicas(fluent.getReplicas());
    buildable.setVersion(fluent.getVersion());
    buildable.setImage(fluent.getImage());
    buildable.setWhitelist(fluent.getWhitelist());
    buildable.setInclude(fluent.getInclude());
    buildable.setConsumer(fluent.buildConsumer());
    buildable.setProducer(fluent.buildProducer());
    buildable.setResources(fluent.getResources());
    buildable.setLivenessProbe(fluent.buildLivenessProbe());
    buildable.setReadinessProbe(fluent.buildReadinessProbe());
    buildable.setJvmOptions(fluent.buildJvmOptions());
    buildable.setLogging(fluent.buildLogging());
    buildable.setMetricsConfig(fluent.buildMetricsConfig());
    buildable.setTracing(fluent.buildTracing());
    buildable.setTemplate(fluent.buildTemplate());
    return buildable;
  }
  
}